/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.incremental;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.incremental.BranchAddDependency;
import org.mindswap.pellet.tableau.completion.incremental.BranchDependency;
import org.mindswap.pellet.tableau.completion.incremental.ClashDependency;
import org.mindswap.pellet.tableau.completion.incremental.CloseBranchDependency;
import org.mindswap.pellet.tableau.completion.incremental.MergeDependency;
import org.mindswap.pellet.tableau.completion.incremental.TypeDependency;

public class DependencyEntry {
    private Set<TypeDependency> types = new HashSet<TypeDependency>();
    private Set<MergeDependency> merges;
    private Set<Edge> edges = new HashSet<Edge>();
    private Set<BranchAddDependency> branchAdds;
    private Set<CloseBranchDependency> branchCloses;
    private ClashDependency clash = null;

    public DependencyEntry() {
        this.merges = new HashSet<MergeDependency>();
        this.branchAdds = new HashSet<BranchAddDependency>();
        this.branchCloses = new HashSet<CloseBranchDependency>();
    }

    public DependencyEntry copy() {
        DependencyEntry dependencyEntry = new DependencyEntry();
        dependencyEntry.types = new HashSet<TypeDependency>(this.types);
        dependencyEntry.merges = new HashSet<MergeDependency>(this.merges);
        for (Edge edge : this.edges) {
            DefaultEdge defaultEdge = new DefaultEdge(edge.getRole(), edge.getFrom(), edge.getTo(), edge.getDepends());
            dependencyEntry.edges.add(defaultEdge);
        }
        dependencyEntry.branchAdds = new HashSet<BranchAddDependency>(this.branchAdds);
        dependencyEntry.branchCloses = new HashSet<CloseBranchDependency>(this.branchCloses);
        dependencyEntry.clash = this.clash;
        return dependencyEntry;
    }

    protected void addTypeDependency(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.types.add(new TypeDependency(aTermAppl, aTermAppl2));
    }

    protected void addEdgeDependency(Edge edge) {
        this.edges.add(edge);
    }

    protected void addMergeDependency(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.merges.add(new MergeDependency(aTermAppl, aTermAppl2));
    }

    protected BranchDependency addBranchAddDependency(ATermAppl aTermAppl, int n, Branch branch) {
        BranchAddDependency branchAddDependency = new BranchAddDependency(aTermAppl, n, branch);
        this.branchAdds.add(branchAddDependency);
        return branchAddDependency;
    }

    protected BranchDependency addCloseBranchDependency(ATermAppl aTermAppl, Branch branch) {
        CloseBranchDependency closeBranchDependency = new CloseBranchDependency(aTermAppl, branch.getTryNext(), branch);
        if (this.branchCloses.contains(closeBranchDependency)) {
            this.branchCloses.remove(closeBranchDependency);
        }
        this.branchCloses.add(closeBranchDependency);
        return closeBranchDependency;
    }

    public void print() {
        System.out.println("  Edge Dependencies:");
        for (Edge object : this.edges) {
            System.out.println("    " + object.toString());
        }
        System.out.println("  Type Dependencies:");
        for (TypeDependency typeDependency : this.types) {
            System.out.println("    " + typeDependency.toString());
        }
        System.out.println("  Merge Dependencies:");
        for (MergeDependency mergeDependency : this.merges) {
            System.out.println("    " + mergeDependency.toString());
        }
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public Set<MergeDependency> getMerges() {
        return this.merges;
    }

    public Set<TypeDependency> getTypes() {
        return this.types;
    }

    public Set<BranchAddDependency> getBranchAdds() {
        return this.branchAdds;
    }

    public Set<CloseBranchDependency> getCloseBranches() {
        return this.branchCloses;
    }

    public ClashDependency getClash() {
        return this.clash;
    }

    protected void setClash(ClashDependency clashDependency) {
        this.clash = clashDependency;
    }
}

