/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyRestrictedDatatype;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.FloatingPointInterval;
import com.clarkparsia.pellet.datatypes.FloatingPointType;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class RestrictedFloatingPointDatatype<T extends Number>
implements RestrictedDatatype<T> {
    private static final Logger log = Logger.getLogger(RestrictedFloatingPointDatatype.class.getCanonicalName());
    private final boolean containsNaN;
    private final Datatype<? extends T> datatype;
    private final RestrictedDatatype<T> empty;
    private final List<FloatingPointInterval<T>> intervals;
    private final FloatingPointType<T> type;

    public RestrictedFloatingPointDatatype(Datatype<? extends T> datatype, FloatingPointType<T> floatingPointType) {
        this.datatype = datatype;
        this.type = floatingPointType;
        this.empty = new EmptyRestrictedDatatype<T>(datatype);
        this.intervals = Collections.singletonList(FloatingPointInterval.unconstrained(floatingPointType));
        this.containsNaN = true;
    }

    private RestrictedFloatingPointDatatype(RestrictedFloatingPointDatatype<T> restrictedFloatingPointDatatype, List<FloatingPointInterval<T>> list, boolean bl) {
        this.datatype = restrictedFloatingPointDatatype.datatype;
        this.type = restrictedFloatingPointDatatype.type;
        this.empty = restrictedFloatingPointDatatype.empty;
        this.intervals = Collections.unmodifiableList(list);
        this.containsNaN = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RestrictedDatatype<T> applyConstrainingFacet(ATermAppl aTermAppl, Object object) {
        T t;
        T t2;
        Facet facet = Facet.Registry.get(aTermAppl);
        if (facet == null) {
            String string = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), aTermAppl, object);
            log.severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.type.isInstance(object)) {
            String string = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), facet, object);
            log.severe(string);
            throw new IllegalArgumentException(string);
        }
        T t3 = this.type.cast(object);
        if (!EnumSet.of(Facet.XSD.MAX_EXCLUSIVE, Facet.XSD.MAX_INCLUSIVE, Facet.XSD.MIN_EXCLUSIVE, Facet.XSD.MIN_INCLUSIVE).contains(facet)) throw new IllegalStateException();
        if (this.type.isNaN(t3)) {
            return this.empty;
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(facet)) {
            t2 = this.type.getNegativeInfinity();
            if (t3.equals(this.type.getNegativeInfinity())) {
                return this.empty;
            }
            t = this.type.decrement(t3);
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(facet)) {
            t2 = this.type.getNegativeInfinity();
            t = t3;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(facet)) {
            if (t3.equals(this.type.getPositiveInfinity())) {
                return this.empty;
            }
            t2 = t3;
            t = this.type.getPositiveInfinity();
        } else {
            if (!Facet.XSD.MIN_INCLUSIVE.equals(facet)) throw new IllegalStateException();
            t2 = t3;
            t = this.type.getPositiveInfinity();
        }
        FloatingPointInterval<T> floatingPointInterval = new FloatingPointInterval<T>(this.type, t2, t);
        ArrayList<FloatingPointInterval<T>> arrayList = new ArrayList<FloatingPointInterval<T>>();
        boolean bl = this.containsNaN;
        for (FloatingPointInterval<T> floatingPointInterval2 : this.intervals) {
            FloatingPointInterval<T> floatingPointInterval3 = floatingPointInterval2.intersection(floatingPointInterval);
            if (floatingPointInterval3 != null) {
                arrayList.add(floatingPointInterval3);
                if (floatingPointInterval2 == floatingPointInterval3) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        if (!bl) return this;
        if (!arrayList.isEmpty()) return new RestrictedFloatingPointDatatype<T>(this, arrayList, false);
        return this.empty;
    }

    @Override
    public boolean contains(Object object) {
        if (this.type.isInstance(object)) {
            T t = this.type.cast(object);
            if (this.type.isNaN(t)) {
                return this.containsNaN;
            }
            for (FloatingPointInterval<T> floatingPointInterval : this.intervals) {
                if (!floatingPointInterval.contains(t)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (n <= 0) {
            return true;
        }
        Number number = this.containsNaN ? 1 : 0;
        for (FloatingPointInterval<T> floatingPointInterval : this.intervals) {
            if (OWLRealUtils.compare(number = OWLRealUtils.integerSum(number, floatingPointInterval.size()), n) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<T> exclude(Collection<?> collection) {
        boolean bl = false;
        ArrayList<FloatingPointInterval<T>> arrayList = new ArrayList<FloatingPointInterval<T>>(this.intervals);
        block0: for (Object obj : collection) {
            if (!this.type.isInstance(obj)) continue;
            T t = this.type.cast(obj);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                FloatingPointInterval<T> floatingPointInterval;
                FloatingPointInterval floatingPointInterval2 = (FloatingPointInterval)iterator.next();
                if (!floatingPointInterval2.contains(t)) continue;
                bl = true;
                iterator.remove();
                FloatingPointInterval<T> floatingPointInterval3 = floatingPointInterval2.less(t);
                if (floatingPointInterval3 != null) {
                    arrayList.add(floatingPointInterval3);
                }
                if ((floatingPointInterval = floatingPointInterval2.greater(t)) == null) continue block0;
                arrayList.add(floatingPointInterval);
                continue block0;
            }
        }
        if (bl) {
            if (arrayList.isEmpty()) {
                return this.empty;
            }
            return new RestrictedFloatingPointDatatype<T>(this, arrayList, this.containsNaN);
        }
        return this;
    }

    @Override
    public Datatype<? extends T> getDatatype() {
        return this.datatype;
    }

    @Override
    public T getValue(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<T> intersect(RestrictedDatatype<?> restrictedDatatype, boolean bl) {
        if (restrictedDatatype instanceof RestrictedFloatingPointDatatype) {
            boolean bl2;
            FloatingPointInterval floatingPointInterval;
            Object object;
            Object object2;
            Object object3;
            if (!this.type.equals(((RestrictedFloatingPointDatatype)restrictedDatatype).type)) {
                throw new IllegalArgumentException();
            }
            RestrictedFloatingPointDatatype restrictedFloatingPointDatatype = (RestrictedFloatingPointDatatype)restrictedDatatype;
            boolean bl3 = false;
            ArrayList<FloatingPointInterval<T>> arrayList = new ArrayList<FloatingPointInterval<T>>();
            if (bl) {
                object3 = Collections.singletonList(FloatingPointInterval.unconstrained(this.type));
                for (FloatingPointInterval<T> floatingPointInterval2 : restrictedFloatingPointDatatype.intervals) {
                    object2 = new ArrayList();
                    object = object3.iterator();
                    while (object.hasNext()) {
                        floatingPointInterval = (FloatingPointInterval)object.next();
                        object2.addAll(floatingPointInterval.remove(floatingPointInterval2));
                    }
                    object3 = object2;
                }
            } else {
                object3 = restrictedFloatingPointDatatype.intervals;
            }
            for (FloatingPointInterval<T> floatingPointInterval2 : this.intervals) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (FloatingPointInterval)object2.next();
                    floatingPointInterval = floatingPointInterval2.intersection((FloatingPointInterval<T>)object);
                    if (floatingPointInterval == floatingPointInterval2) continue;
                    bl3 = true;
                    if (floatingPointInterval == null) continue;
                    arrayList.add(floatingPointInterval);
                }
            }
            if (this.containsNaN) {
                if (restrictedFloatingPointDatatype.containsNaN) {
                    if (bl) {
                        bl3 = true;
                        bl2 = false;
                    } else {
                        bl2 = true;
                    }
                } else if (bl) {
                    bl2 = true;
                } else {
                    bl3 = true;
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            if (bl3) {
                if (arrayList.isEmpty()) {
                    return this.empty;
                }
                return new RestrictedFloatingPointDatatype<T>(this, arrayList, bl2);
            }
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        long l = this.containsNaN ? 1L : 0L;
        for (FloatingPointInterval<T> floatingPointInterval : this.intervals) {
            if ((l += floatingPointInterval.size().longValue()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public String toString() {
        return String.format("{%s,%s}", this.datatype, this.intervals);
    }

    @Override
    public RestrictedDatatype<T> union(RestrictedDatatype<?> restrictedDatatype) {
        if (restrictedDatatype instanceof RestrictedFloatingPointDatatype) {
            if (!this.type.equals(((RestrictedFloatingPointDatatype)restrictedDatatype).type)) {
                throw new IllegalArgumentException();
            }
            RestrictedFloatingPointDatatype restrictedFloatingPointDatatype = (RestrictedFloatingPointDatatype)restrictedDatatype;
            ArrayList<FloatingPointInterval<T>> arrayList = new ArrayList<FloatingPointInterval<T>>(this.intervals);
            for (FloatingPointInterval<T> floatingPointInterval : restrictedFloatingPointDatatype.intervals) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    FloatingPointInterval floatingPointInterval2 = (FloatingPointInterval)object.next();
                    if (!floatingPointInterval.canUnionWith(floatingPointInterval2)) continue;
                    object.remove();
                    arrayList2.add(floatingPointInterval2);
                }
                if (arrayList2.isEmpty()) {
                    arrayList.add(floatingPointInterval);
                    continue;
                }
                object = new HashSet();
                for (FloatingPointInterval floatingPointInterval3 : arrayList2) {
                    object.addAll(floatingPointInterval.union(floatingPointInterval3));
                }
                arrayList.addAll((Collection<FloatingPointInterval<T>>)object);
            }
            boolean bl = this.containsNaN || restrictedFloatingPointDatatype.containsNaN;
            return new RestrictedFloatingPointDatatype<T>(this, arrayList, bl);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<T> valueIterator() {
        return new Iterator<T>(){
            final Iterator<FloatingPointInterval<T>> iit;
            Iterator<T> nit;
            {
                this.iit = RestrictedFloatingPointDatatype.this.intervals.iterator();
                this.nit = null;
            }

            @Override
            public boolean hasNext() {
                while (this.nit == null || !this.nit.hasNext()) {
                    if (this.iit.hasNext()) {
                        this.nit = this.iit.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Number)this.nit.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

