/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.HashMap;
import java.util.Map;

class FileManagerModelCache {
    boolean cacheModelLoads = false;
    Map<String, Model> modelCache = null;

    public void resetCache() {
        if (this.modelCache != null) {
            this.modelCache.clear();
        }
    }

    public void setModelCaching(boolean state) {
        this.cacheModelLoads = state;
        if (this.cacheModelLoads && this.modelCache == null) {
            this.modelCache = new HashMap<String, Model>();
        }
    }

    public boolean getCachingModels() {
        return this.cacheModelLoads;
    }

    public Model getFromCache(String filenameOrURI) {
        if (!this.getCachingModels()) {
            return null;
        }
        return this.modelCache.get(filenameOrURI);
    }

    public boolean hasCachedModel(String filenameOrURI) {
        if (!this.getCachingModels()) {
            return false;
        }
        return this.modelCache.containsKey(filenameOrURI);
    }

    public void addCacheModel(String uri, Model m) {
        if (this.getCachingModels()) {
            this.modelCache.put(uri, m);
        }
    }

    public void removeCacheModel(String uri) {
        if (this.getCachingModels()) {
            this.modelCache.remove(uri);
        }
    }
}

