/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.MultiMapUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.tbox.impl.TgBox;
import org.mindswap.pellet.tbox.impl.TuBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.MultiIterator;

public class TBoxExpImpl
implements TBox {
    public static Logger log = Logger.getLogger(TBox.class.getName());
    private static final Set<Set<ATermAppl>> SINGLE_EMPTY_SET = Collections.singleton(Collections.emptySet());
    protected KnowledgeBase kb;
    protected Set<ATermAppl> classes = CollectionUtils.makeIdentitySet();
    private Set<ATermAppl> allClasses;
    private Map<ATermAppl, Set<Set<ATermAppl>>> tboxAxioms = CollectionUtils.makeIdentityMap();
    private Map<ATermAppl, Set<ATermAppl>> reverseExplain = CollectionUtils.makeIdentityMap();
    private Set<ATermAppl> tboxAssertedAxioms = CollectionUtils.makeIdentitySet();
    private Set<ATermAppl> absorbedAxioms = CollectionUtils.makeIdentitySet();
    public TuBox Tu = null;
    public TgBox Tg = null;

    public TBoxExpImpl(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.Tu = new TuBox(this);
        this.Tg = new TgBox(this);
        this.kb = knowledgeBase;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public Set<ATermAppl> getAllClasses() {
        if (this.allClasses == null) {
            this.allClasses = new HashSet<ATermAppl>(this.classes);
            this.allClasses.add(ATermUtils.TOP);
            this.allClasses.add(ATermUtils.BOTTOM);
        }
        return this.allClasses;
    }

    @Override
    public Set<Set<ATermAppl>> getAxiomExplanations(ATermAppl aTermAppl) {
        return this.tboxAxioms.get(aTermAppl);
    }

    @Override
    public Set<ATermAppl> getAxiomExplanation(ATermAppl aTermAppl) {
        Set<Set<ATermAppl>> set = this.tboxAxioms.get(aTermAppl);
        if (set == null || set.isEmpty()) {
            log.warning("No explanation for " + aTermAppl);
            return Collections.emptySet();
        }
        Iterator<Set<ATermAppl>> iterator = set.iterator();
        if (iterator.hasNext()) {
            Set<ATermAppl> set2 = iterator.next();
            return set2;
        }
        return Collections.emptySet();
    }

    protected boolean addAxiomExplanation(ATermAppl aTermAppl, Set<ATermAppl> set) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Axiom: " + ATermUtils.toString(aTermAppl) + " Explanation: " + set);
        }
        boolean bl = false;
        bl = !PelletOptions.USE_TRACING ? this.tboxAxioms.put(aTermAppl, SINGLE_EMPTY_SET) == null : MultiMapUtils.add(this.tboxAxioms, aTermAppl, set);
        if (bl) {
            for (ATermAppl aTermAppl2 : set) {
                if (aTermAppl.equals(aTermAppl2)) continue;
                MultiMapUtils.add(this.reverseExplain, aTermAppl2, aTermAppl);
            }
        }
        return bl;
    }

    private static void addDisjointAxiom(ATermAppl aTermAppl, ATermAppl aTermAppl2, List<ATermAppl> list) {
        ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl2);
        list.add(ATermUtils.makeSub((ATerm)aTermAppl, (ATerm)aTermAppl3));
        if (ATermUtils.isPrimitive(aTermAppl2)) {
            ATermAppl aTermAppl4 = ATermUtils.makeNot((ATerm)aTermAppl);
            list.add(ATermUtils.makeSub((ATerm)aTermAppl2, (ATerm)aTermAppl4));
        }
    }

    @Override
    public boolean addAxiom(ATermAppl aTermAppl) {
        ATermAppl aTermAppl2;
        ATermAppl aTermAppl3;
        Set<ATermAppl> set;
        this.tboxAssertedAxioms.add(aTermAppl);
        List<Object> list = null;
        Set<Object> set2 = set = PelletOptions.USE_TRACING ? Collections.singleton(aTermAppl) : Collections.emptySet();
        if (aTermAppl.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            list = Collections.singletonList(aTermAppl);
        } else if (aTermAppl.getAFun().equals(ATermUtils.SUBFUN)) {
            list = Collections.singletonList(aTermAppl);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            list = CollectionUtils.makeList();
            aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
            aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1);
            TBoxExpImpl.addDisjointAxiom(aTermAppl3, aTermAppl2, list);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            list = CollectionUtils.makeList();
            aTermAppl2 = aTermAppl3 = (ATermList)aTermAppl.getArgument(0);
            while (!aTermAppl2.isEmpty()) {
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl2.getFirst();
                ATermList aTermList = aTermAppl2.getNext();
                while (!aTermList.isEmpty()) {
                    ATermAppl aTermAppl5 = (ATermAppl)aTermList.getFirst();
                    TBoxExpImpl.addDisjointAxiom(aTermAppl4, aTermAppl5, list);
                    aTermList = aTermList.getNext();
                }
                aTermAppl2 = aTermAppl2.getNext();
            }
        } else {
            log.warning("Not a valid TBox axiom: " + aTermAppl);
            return false;
        }
        boolean bl = false;
        for (ATermAppl aTermAppl4 : list) {
            if (this.absorbNominals(aTermAppl4, set)) {
                bl = true;
                continue;
            }
            bl |= this.addAxiom(aTermAppl4, set, false);
        }
        return bl;
    }

    protected boolean absorbNominals(ATermAppl aTermAppl, Set<ATermAppl> set) {
        if (PelletOptions.USE_NOMINAL_ABSORPTION || PelletOptions.USE_PSEUDO_NOMINALS) {
            ATermAppl aTermAppl2;
            if (aTermAppl.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
                if (ATermUtils.isOneOf(aTermAppl3)) {
                    this.Tg.absorbOneOf(aTermAppl3, aTermAppl4, set);
                    if (ATermUtils.isOneOf(aTermAppl4)) {
                        this.Tg.absorbOneOf(aTermAppl4, aTermAppl3, set);
                        return true;
                    }
                    aTermAppl = ATermUtils.makeSub((ATerm)aTermAppl4, (ATerm)aTermAppl3);
                } else if (ATermUtils.isOneOf(aTermAppl4)) {
                    this.Tg.absorbOneOf(aTermAppl4, aTermAppl3, set);
                }
            } else if (aTermAppl.getAFun().equals(ATermUtils.SUBFUN) && ATermUtils.isOneOf(aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0))) {
                ATermAppl aTermAppl5 = (ATermAppl)aTermAppl.getArgument(1);
                this.Tg.absorbOneOf(aTermAppl2, aTermAppl5, set);
                return true;
            }
        }
        return false;
    }

    protected boolean addAxiom(ATermAppl aTermAppl, Set<ATermAppl> set, boolean bl) {
        boolean bl2 = this.addAxiomExplanation(aTermAppl, set);
        if ((bl2 || bl) && !this.Tu.addIfUnfoldable(aTermAppl)) {
            if (aTermAppl.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
                ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
                ATermAppl aTermAppl4 = ATermUtils.makeEqClasses((ATerm)aTermAppl3, (ATerm)aTermAppl2);
                if (!this.Tu.addIfUnfoldable(aTermAppl4)) {
                    this.Tg.addDef(aTermAppl);
                } else {
                    this.addAxiomExplanation(aTermAppl4, set);
                }
            } else {
                this.Tg.addDef(aTermAppl);
            }
        }
        return bl2;
    }

    @Override
    public boolean removeAxiom(ATermAppl aTermAppl) {
        return this.removeAxiom(aTermAppl, aTermAppl);
    }

    @Override
    public boolean removeAxiom(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (!PelletOptions.USE_TRACING) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (this.absorbedAxioms.contains(aTermAppl)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms that have been absorbed outside TBox");
            }
            return false;
        }
        this.tboxAssertedAxioms.remove(aTermAppl);
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        boolean bl = this.removeExplanation(aTermAppl, aTermAppl2, hashSet);
        for (ATermAppl aTermAppl3 : hashSet) {
            Set<Set<ATermAppl>> set = this.tboxAxioms.get(aTermAppl3);
            if (set == null) continue;
            Iterator<Set<ATermAppl>> iterator = set.iterator();
            this.addAxiom(aTermAppl3, iterator.next(), true);
            while (iterator.hasNext()) {
                this.addAxiomExplanation(aTermAppl3, iterator.next());
            }
        }
        return bl;
    }

    private boolean removeExplanation(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        Object object;
        boolean bl = false;
        if (!PelletOptions.USE_TRACING) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Removing " + ATermUtils.toString(aTermAppl2));
        }
        MultiMapUtils.remove(this.reverseExplain, aTermAppl2, aTermAppl);
        Set<Set<ATermAppl>> set2 = this.tboxAxioms.get(aTermAppl);
        HashSet<Set<ATermAppl>> hashSet = new HashSet<Set<ATermAppl>>();
        if (set2 != null) {
            for (Set<ATermAppl> set3 : set2) {
                if (!set3.contains(aTermAppl2)) {
                    hashSet.add(set3);
                    continue;
                }
                set.addAll(set3);
                set.remove(aTermAppl2);
            }
        }
        if (!hashSet.isEmpty()) {
            this.tboxAxioms.put(aTermAppl, hashSet);
            this.Tu.updateDef(aTermAppl);
            bl = true;
        } else {
            bl |= this.tboxAxioms.remove(aTermAppl) != null;
            object = aTermAppl.getAFun();
            if (object.equals(ATermUtils.SUBFUN) || object.equals(ATermUtils.EQCLASSFUN)) {
                bl |= this.Tu.removeDef(aTermAppl);
                bl |= this.Tg.removeDef(aTermAppl);
            }
        }
        object = this.reverseExplain.remove(aTermAppl);
        if (object != null) {
            Set<ATermAppl> set3;
            set3 = object.iterator();
            while (set3.hasNext()) {
                ATermAppl aTermAppl3 = (ATermAppl)set3.next();
                if (aTermAppl3.equals(aTermAppl)) continue;
                bl |= this.removeExplanation(aTermAppl3, aTermAppl, set);
            }
        }
        return bl;
    }

    @Override
    public Collection<ATermAppl> getAxioms() {
        return this.tboxAxioms.keySet();
    }

    @Override
    public Collection<ATermAppl> getAssertedAxioms() {
        return this.tboxAssertedAxioms;
    }

    public Collection<ATermAppl> getAbsorbedAxioms() {
        return this.absorbedAxioms;
    }

    public boolean containsAxiom(ATermAppl aTermAppl) {
        return this.tboxAxioms.containsKey(aTermAppl);
    }

    public void absorb() {
        this.Tg.absorb();
    }

    public void print() {
        this.print(System.out);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.print(stringBuilder);
        return stringBuilder.toString();
    }

    public void print(Appendable appendable) {
        try {
            this.Tu.print(appendable);
            this.Tg.print(appendable);
            appendable.append("Explain: [\n");
            for (ATermAppl aTermAppl : this.tboxAxioms.keySet()) {
                appendable.append(ATermUtils.toString(aTermAppl));
                appendable.append(" -> ");
                appendable.append("[");
                boolean bl = true;
                for (Set<ATermAppl> set : this.tboxAxioms.get(aTermAppl)) {
                    if (bl) {
                        bl = false;
                    } else {
                        appendable.append(", ");
                    }
                    appendable.append(ATermUtils.toString(set));
                }
                appendable.append("]");
                appendable.append("\n");
            }
            appendable.append("]\nReverseExplain: [\n");
            for (ATermAppl aTermAppl : this.reverseExplain.keySet()) {
                appendable.append(ATermUtils.toString(aTermAppl));
                appendable.append(" -> ");
                appendable.append(ATermUtils.toString((Collection<ATermAppl>)this.reverseExplain.get(aTermAppl)));
                appendable.append("\n");
            }
            appendable.append("]\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public boolean addClass(ATermAppl aTermAppl) {
        boolean bl = this.classes.add(aTermAppl);
        if (bl) {
            this.allClasses = null;
        }
        return bl;
    }

    @Override
    public Set<ATermAppl> getClasses() {
        return this.classes;
    }

    @Override
    public Collection<ATermAppl> getAxioms(ATermAppl aTermAppl) {
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        TermDefinition termDefinition = this.Tg.getTD((ATerm)aTermAppl);
        if (termDefinition != null) {
            arrayList.addAll(termDefinition.getSubClassAxioms());
            arrayList.addAll(termDefinition.getEqClassAxioms());
        }
        if ((termDefinition = this.Tu.getTD((ATerm)aTermAppl)) != null) {
            arrayList.addAll(termDefinition.getSubClassAxioms());
            arrayList.addAll(termDefinition.getEqClassAxioms());
        }
        return arrayList;
    }

    @Override
    public void prepare() {
        this.Tg.absorb();
        this.Tg.internalize();
        this.Tu.normalize();
    }

    @Override
    public Iterator<Unfolding> unfold(ATermAppl aTermAppl) {
        MultiIterator<Unfolding> multiIterator = new MultiIterator<Unfolding>(this.Tu.unfold(aTermAppl).iterator());
        if (aTermAppl.equals(TermFactory.TOP) && !this.Tg.getUC().isEmpty()) {
            multiIterator.append(this.Tg.getUC().iterator());
        }
        return multiIterator;
    }

    @Override
    public boolean isPrimitive(ATermAppl aTermAppl) {
        TermDefinition termDefinition = this.Tu.getTD((ATerm)aTermAppl);
        return ATermUtils.isPrimitive(aTermAppl) && (termDefinition == null || termDefinition.isPrimitive());
    }
}

