/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;

public class UnfoldingRule
extends AbstractTableauRule {
    public static final Logger log = Logger.getLogger(UnfoldingRule.class.getName());

    public UnfoldingRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.ATOM, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual individual) {
        if (!individual.canApply(0)) {
            return;
        }
        List<ATermAppl> list = individual.getTypes(0);
        int n = list.size();
        for (int i = individual.applyNext[0]; i < n; ++i) {
            ATermAppl aTermAppl = list.get(i);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && individual.getDepends((ATerm)aTermAppl) == null) continue;
            this.applyUnfoldingRule(individual, aTermAppl);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
            n = list.size();
        }
        individual.applyNext[0] = n;
    }

    protected void applyUnfoldingRule(Individual individual, ATermAppl aTermAppl) {
        DependencySet dependencySet = individual.getDepends((ATerm)aTermAppl);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && dependencySet == null) {
            return;
        }
        Iterator<Unfolding> iterator = this.strategy.getTBox().unfold(aTermAppl);
        while (iterator.hasNext()) {
            Unfolding unfolding = iterator.next();
            ATermAppl aTermAppl2 = unfolding.getCondition();
            DependencySet dependencySet2 = individual.getDepends((ATerm)aTermAppl2);
            if (dependencySet2 == null) continue;
            Set<ATermAppl> set = unfolding.getExplanation();
            dependencySet2 = dependencySet2.union(dependencySet, this.strategy.getABox().doExplanation());
            dependencySet2 = dependencySet2.union(set, this.strategy.getABox().doExplanation());
            ATermAppl aTermAppl3 = unfolding.getResult();
            if (log.isLoggable(Level.FINE) && !individual.hasType((ATerm)aTermAppl3)) {
                log.fine("UNF : " + individual + ", " + ATermUtils.toString(aTermAppl) + " -> " + ATermUtils.toString(aTermAppl3) + " - " + dependencySet2);
            }
            this.strategy.addType(individual, aTermAppl3, dependencySet2);
        }
    }
}

