/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;

public class Individual
extends Node
implements CachedNode {
    private EdgeList outEdges;
    private ArrayList<ATermAppl>[] types = new ArrayList[7];
    public int[] applyNext = new int[7];
    private int nominalLevel;
    private Individual parent;
    private boolean modifiedAfterMerge = false;
    private short depth;
    private boolean isBlocked;

    Individual(ATermAppl aTermAppl, ABox aBox, Individual individual) {
        super(aTermAppl, aBox);
        this.parent = individual;
        if (individual == null) {
            this.nominalLevel = 0;
            this.depth = 0;
        } else {
            this.nominalLevel = Integer.MAX_VALUE;
            this.depth = (short)(individual.depth + 1);
        }
        for (int i = 0; i < 7; ++i) {
            this.types[i] = new ArrayList();
            this.applyNext[i] = 0;
        }
        this.outEdges = new EdgeList();
    }

    Individual(Individual individual, ABox aBox) {
        super(individual, aBox);
        this.nominalLevel = individual.nominalLevel;
        this.parent = individual.parent;
        for (int i = 0; i < 7; ++i) {
            this.types[i] = new ArrayList<ATermAppl>(individual.types[i]);
            this.applyNext[i] = individual.applyNext[i];
        }
        this.outEdges = this.isPruned() ? new EdgeList(individual.outEdges) : new EdgeList(individual.outEdges.size());
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean bl) {
        this.isBlocked = bl;
    }

    public short getDepth() {
        return this.depth;
    }

    @Override
    public DependencySet getNodeDepends() {
        return this.getDepends((ATerm)ATermUtils.TOP);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isIndividual() {
        return true;
    }

    @Override
    public boolean isNominal() {
        return this.nominalLevel != Integer.MAX_VALUE;
    }

    @Override
    public boolean isBlockable() {
        return this.nominalLevel == Integer.MAX_VALUE;
    }

    @Override
    public boolean isIndependent() {
        return true;
    }

    public void setNominalLevel(int n) {
        this.nominalLevel = n;
        if (this.nominalLevel != Integer.MAX_VALUE) {
            this.parent = null;
        }
    }

    @Override
    public int getNominalLevel() {
        return this.nominalLevel;
    }

    @Override
    public ATermAppl getTerm() {
        return this.name;
    }

    @Override
    public Node copyTo(ABox aBox) {
        return new Individual(this, aBox);
    }

    public List<ATermAppl> getTypes(int n) {
        return this.types[n];
    }

    @Override
    public boolean isDifferent(Node node) {
        if (PelletOptions.USE_UNIQUE_NAME_ASSUMPTION && this.isNamedIndividual() && node.isNamedIndividual()) {
            return !this.name.equals(node.name);
        }
        return this.differents.containsKey(node);
    }

    @Override
    public Set<Node> getDifferents() {
        return this.differents.keySet();
    }

    @Override
    public DependencySet getDifferenceDependency(Node node) {
        if (PelletOptions.USE_UNIQUE_NAME_ASSUMPTION && this.isNamedIndividual() && node.isNamedIndividual()) {
            return DependencySet.INDEPENDENT;
        }
        return (DependencySet)this.differents.get(node);
    }

    public void getObviousTypes(List<ATermAppl> list, List<ATermAppl> list2) {
        for (ATermAppl aTermAppl : this.getTypes(0)) {
            if (!this.getDepends((ATerm)aTermAppl).isIndependent()) continue;
            if (ATermUtils.isPrimitive(aTermAppl)) {
                list.add(aTermAppl);
                continue;
            }
            if (!ATermUtils.isNegatedPrimitive(aTermAppl)) continue;
            list2.add((ATermAppl)aTermAppl.getArgument(0));
        }
    }

    public boolean canApply(int n) {
        return this.applyNext[n] < this.types[n].size();
    }

    @Override
    public void addType(ATermAppl aTermAppl, DependencySet dependencySet) {
        this.addType(aTermAppl, dependencySet, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addType(ATermAppl aTermAppl, DependencySet dependencySet, boolean bl) {
        ATermAppl aTermAppl2;
        if (bl) {
            if (this.isPruned()) {
                throw new InternalReasonerException("Adding type to a pruned node " + this + " " + aTermAppl);
            }
            if (this.isMerged()) {
                return;
            }
        } else if (this.isMerged()) {
            this.modifiedAfterMerge = true;
        }
        if (this.depends.containsKey(aTermAppl)) {
            if (bl || !dependencySet.isIndependent()) return;
            this.depends.put(aTermAppl, dependencySet);
            return;
        }
        int n = this.abox.getBranch();
        int n2 = dependencySet.max();
        if (n == -1 && n2 != 0) {
            n = n2 + 1;
        }
        dependencySet = dependencySet.copy(n);
        this.depends.put(aTermAppl, dependencySet);
        this.abox.setChanged(true);
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
        }
        QueueElement queueElement = new QueueElement(this, aTermAppl);
        ATermAppl aTermAppl3 = ATermUtils.negate(aTermAppl);
        DependencySet dependencySet2 = (DependencySet)this.depends.get(aTermAppl3);
        if (dependencySet2 != null) {
            aTermAppl2 = ATermUtils.isNot(aTermAppl3) ? aTermAppl : aTermAppl3;
            dependencySet2 = dependencySet2.union(dependencySet, this.abox.doExplanation());
            dependencySet2 = dependencySet2.copy(this.abox.getBranch());
            this.abox.setClash(Clash.atomic(this, dependencySet2, aTermAppl2));
        }
        if (ATermUtils.isPrimitive(aTermAppl)) {
            this.setChanged(0);
            this.types[0].add(aTermAppl);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.ATOM);
            return;
        } else if (aTermAppl.getAFun().equals(ATermUtils.ANDFUN)) {
            aTermAppl2 = (ATermList)aTermAppl.getArgument(0);
            while (!aTermAppl2.isEmpty()) {
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl2.getFirst();
                this.addType(aTermAppl4, dependencySet, bl);
                aTermAppl2 = aTermAppl2.getNext();
            }
            return;
        } else if (aTermAppl.getAFun().equals(ATermUtils.ALLFUN)) {
            this.setChanged(3);
            this.types[3].add(aTermAppl);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.UNIVERSAL);
            return;
        } else if (aTermAppl.getAFun().equals(ATermUtils.MINFUN)) {
            if (this.isRedundantMin(aTermAppl)) return;
            this.types[4].add(aTermAppl);
            this.setChanged(4);
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.MIN_NUMBER);
            }
            this.checkMinClash(aTermAppl, dependencySet);
            return;
        } else if (aTermAppl.getAFun().equals(ATermUtils.NOTFUN)) {
            aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            if (ATermUtils.isAnd(aTermAppl2)) {
                this.setChanged(1);
                this.types[1].add(aTermAppl);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.DISJUNCTION);
                return;
            } else if (ATermUtils.isAllValues(aTermAppl2)) {
                this.setChanged(2);
                this.types[2].add(aTermAppl);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.EXISTENTIAL);
                return;
            } else if (ATermUtils.isMin(aTermAppl2)) {
                if (this.isRedundantMax(aTermAppl2)) return;
                this.types[5].add(aTermAppl);
                this.setChanged(5);
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().add(queueElement, NodeSelector.MAX_NUMBER);
                    this.abox.getCompletionQueue().add(queueElement, NodeSelector.CHOOSE);
                    this.abox.getCompletionQueue().add(queueElement, NodeSelector.GUESS);
                }
                this.checkMaxClash(aTermAppl, dependencySet);
                return;
            } else if (ATermUtils.isNominal(aTermAppl2)) {
                this.setChanged(0);
                this.types[0].add(aTermAppl);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.ATOM);
                return;
            } else if (ATermUtils.isSelf(aTermAppl2)) {
                EdgeList edgeList;
                ATermAppl aTermAppl5 = (ATermAppl)aTermAppl2.getArgument(0);
                Role role = this.abox.getRole((ATerm)aTermAppl5);
                if (role == null || (edgeList = this.outEdges.getEdges(role).getEdgesTo(this)).isEmpty()) return;
                this.abox.setClash(Clash.unexplained(this, edgeList.getDepends(this.abox.doExplanation())));
                return;
            } else {
                if (aTermAppl2.getArity() != 0) throw new InternalReasonerException("Invalid type " + aTermAppl + " for individual " + this.name);
                this.setChanged(0);
                this.types[0].add(aTermAppl);
                if (!PelletOptions.USE_COMPLETION_QUEUE) return;
                this.abox.getCompletionQueue().add(queueElement, NodeSelector.ATOM);
            }
            return;
        } else if (aTermAppl.getAFun().equals(ATermUtils.VALUEFUN)) {
            this.setChanged(6);
            this.types[6].add(aTermAppl);
            if (!PelletOptions.USE_COMPLETION_QUEUE) return;
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.NOMINAL);
            return;
        } else {
            if (!ATermUtils.isSelf(aTermAppl)) throw new InternalReasonerException("Warning: Adding invalid class constructor - " + aTermAppl);
            this.setChanged(0);
            this.types[0].add(aTermAppl);
        }
    }

    public boolean checkMinClash(ATermAppl aTermAppl, DependencySet dependencySet) {
        Role role = this.abox.getRole(aTermAppl.getArgument(0));
        if (role == null) {
            return false;
        }
        int n = ((ATermInt)aTermAppl.getArgument(1)).getInt();
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
        if (role.isFunctional() && n > 1) {
            this.abox.setClash(Clash.minMax(this, dependencySet.union(role.getExplainFunctional(), this.abox.doExplanation())));
            return true;
        }
        for (ATermAppl aTermAppl3 : this.types[5]) {
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl3.getArgument(0);
            Role role2 = this.abox.getRole(aTermAppl4.getArgument(0));
            if (role2 == null) {
                return false;
            }
            int n2 = ((ATermInt)aTermAppl4.getArgument(1)).getInt() - 1;
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl4.getArgument(2);
            if (n2 >= n || !aTermAppl2.equals(aTermAppl5) || !role.isSubRoleOf(role2)) continue;
            DependencySet dependencySet2 = this.getDepends((ATerm)aTermAppl3);
            DependencySet dependencySet3 = role2.getExplainSub((ATerm)role.getName());
            DependencySet dependencySet4 = dependencySet.union(dependencySet2, this.abox.doExplanation()).union(dependencySet3, this.abox.doExplanation());
            this.abox.setClash(Clash.minMax(this, dependencySet4));
            return true;
        }
        return false;
    }

    public boolean checkMaxClash(ATermAppl aTermAppl, DependencySet dependencySet) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        Role role = this.abox.getRole(aTermAppl2.getArgument(0));
        if (role == null) {
            return false;
        }
        int n = ((ATermInt)aTermAppl2.getArgument(1)).getInt() - 1;
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(2);
        for (ATermAppl aTermAppl4 : this.types[4]) {
            Role role2 = this.abox.getRole(aTermAppl4.getArgument(0));
            if (role2 == null) {
                return false;
            }
            int n2 = ((ATermInt)aTermAppl4.getArgument(1)).getInt();
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl4.getArgument(2);
            if (n >= n2 || !aTermAppl5.equals(aTermAppl3) || !role2.isSubRoleOf(role)) continue;
            DependencySet dependencySet2 = this.getDepends((ATerm)aTermAppl4);
            DependencySet dependencySet3 = role.getExplainSub((ATerm)role2.getName());
            DependencySet dependencySet4 = dependencySet2.union(dependencySet, this.abox.doExplanation()).union(dependencySet3, this.abox.doExplanation());
            this.abox.setClash(Clash.minMax(this, dependencySet4));
            return true;
        }
        return false;
    }

    public boolean isRedundantMin(ATermAppl aTermAppl) {
        Role role = this.abox.getRole(aTermAppl.getArgument(0));
        if (role == null) {
            return false;
        }
        int n = ((ATermInt)aTermAppl.getArgument(1)).getInt();
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
        for (ATermAppl aTermAppl3 : this.types[4]) {
            Role role2 = this.abox.getRole(aTermAppl3.getArgument(0));
            if (role2 == null) continue;
            int n2 = ((ATermInt)aTermAppl3.getArgument(1)).getInt() - 1;
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl3.getArgument(2);
            if (n > n2 || !role2.isSubRoleOf(role) || !aTermAppl2.equals(aTermAppl4) && !ATermUtils.isTop(aTermAppl2)) continue;
            return true;
        }
        return false;
    }

    public boolean isRedundantMax(ATermAppl aTermAppl) {
        Role role = this.abox.getRole(aTermAppl.getArgument(0));
        if (role == null) {
            return false;
        }
        int n = ((ATermInt)aTermAppl.getArgument(1)).getInt() - 1;
        if (n == 1 && role != null && role.isFunctional()) {
            return true;
        }
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
        for (ATermAppl aTermAppl3 : this.types[5]) {
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl3.getArgument(0);
            Role role2 = this.abox.getRole(aTermAppl4.getArgument(0));
            if (role2 == null) continue;
            int n2 = ((ATermInt)aTermAppl4.getArgument(1)).getInt() - 1;
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl4.getArgument(2);
            if (n < n2 || !role.isSubRoleOf(role2) || !aTermAppl2.equals(aTermAppl5) && !ATermUtils.isTop(aTermAppl5)) continue;
            return true;
        }
        return false;
    }

    public DependencySet hasMax1(Role role) {
        for (ATermAppl aTermAppl : this.types[5]) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            Role role2 = this.abox.getRole(aTermAppl2.getArgument(0));
            int n = ((ATermInt)aTermAppl2.getArgument(1)).getInt() - 1;
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(2);
            if (n != 1 || !role.isSubRoleOf(role2) || !ATermUtils.isTop(aTermAppl3)) continue;
            return this.getDepends((ATerm)aTermAppl).union(role.getExplainSub((ATerm)role2.getName()), this.abox.doExplanation());
        }
        return null;
    }

    public int getMaxCard(Role role) {
        int n = Integer.MAX_VALUE;
        for (ATermAppl aTermAppl : this.types[5]) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            Role role2 = this.abox.getRole(aTermAppl2.getArgument(0));
            int n2 = ((ATermInt)aTermAppl2.getArgument(1)).getInt() - 1;
            if (!role.isSubRoleOf(role2) || n2 >= n) continue;
            n = n2;
        }
        if (role.isFunctional() && n > 1) {
            n = 1;
        }
        return n;
    }

    public int getMinCard(Role role, ATermAppl aTermAppl) {
        int n = 0;
        for (ATermAppl aTermAppl2 : this.types[4]) {
            Role role2 = this.abox.getRole(aTermAppl2.getArgument(0));
            int n2 = ((ATermInt)aTermAppl2.getArgument(1)).getInt();
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(2);
            if (!role2.isSubRoleOf(role) || n >= n2 || !aTermAppl3.equals(aTermAppl) && !aTermAppl.equals(TermFactory.TOP)) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public boolean removeType(ATermAppl aTermAppl) {
        boolean bl = super.removeType(aTermAppl);
        if (ATermUtils.isPrimitive(aTermAppl) || ATermUtils.isSelf(aTermAppl)) {
            this.types[0].remove(aTermAppl);
        } else if (!aTermAppl.getAFun().equals(ATermUtils.ANDFUN)) {
            if (aTermAppl.getAFun().equals(ATermUtils.ALLFUN)) {
                this.types[3].remove(aTermAppl);
            } else if (aTermAppl.getAFun().equals(ATermUtils.MINFUN)) {
                this.types[4].remove(aTermAppl);
            } else if (aTermAppl.getAFun().equals(ATermUtils.NOTFUN)) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
                if (ATermUtils.isAnd(aTermAppl2)) {
                    this.types[1].remove(aTermAppl);
                } else if (ATermUtils.isAllValues(aTermAppl2)) {
                    this.types[2].remove(aTermAppl);
                } else if (ATermUtils.isMin(aTermAppl2)) {
                    this.types[5].remove(aTermAppl);
                } else if (ATermUtils.isNominal(aTermAppl2)) {
                    this.types[0].remove(aTermAppl);
                } else if (aTermAppl2.getArity() == 0) {
                    this.types[0].remove(aTermAppl);
                } else if (!ATermUtils.isSelf(aTermAppl2)) {
                    throw new InternalReasonerException("Invalid type " + aTermAppl + " for individual " + this.name);
                }
            } else if (aTermAppl.getAFun().equals(ATermUtils.VALUEFUN)) {
                this.types[6].remove(aTermAppl);
            } else {
                throw new RuntimeException("Invalid concept " + aTermAppl);
            }
        }
        return bl;
    }

    @Override
    public final boolean isLeaf() {
        return !this.isRoot() && this.outEdges.isEmpty();
    }

    @Override
    public final Individual getSame() {
        return (Individual)super.getSame();
    }

    public final Set<Node> getRSuccessors(Role role, ATermAppl aTermAppl) {
        HashSet<Node> hashSet = new HashSet<Node>();
        EdgeList edgeList = this.outEdges.getEdges(role);
        int n = edgeList.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = edgeList.edgeAt(i);
            Node node = edge.getNeighbor(this);
            if (!node.hasType((ATerm)aTermAppl)) continue;
            hashSet.add(node);
        }
        return hashSet;
    }

    public final EdgeList getRSuccessorEdges(Role role) {
        return this.outEdges.getEdges(role);
    }

    public final EdgeList getRPredecessorEdges(Role role) {
        return this.inEdges.getEdges(role);
    }

    public final Set<Node> getRNeighbors(Role role) {
        return this.getRNeighborEdges(role).getNeighbors(this);
    }

    public EdgeList getRNeighborEdges(Role role) {
        EdgeList edgeList = this.outEdges.getEdges(role);
        Role role2 = role.getInverse();
        if (role2 != null) {
            edgeList.addEdgeList(this.inEdges.getEdges(role2));
        }
        return edgeList;
    }

    public EdgeList getRNeighborEdges(Role role, Node node) {
        EdgeList edgeList = this.outEdges.getEdgesTo(role, node);
        Role role2 = role.getInverse();
        if (role2 != null) {
            edgeList.addEdgeList(this.inEdges.getEdgesFrom((Individual)node, role2));
        }
        return edgeList;
    }

    public EdgeList getEdgesTo(Node node) {
        return this.outEdges.getEdgesTo(node);
    }

    public EdgeList getEdgesTo(Node node, Role role) {
        return this.outEdges.getEdgesTo(node).getEdges(role);
    }

    public DependencySet hasDistinctRNeighborsForMax(Role role, int n, ATermAppl aTermAppl) {
        Object object;
        boolean bl = false;
        EdgeList edgeList = this.getRNeighborEdges(role);
        if (edgeList.size() >= n) {
            object = new ArrayList();
            block0: for (int i = 0; i < edgeList.size(); ++i) {
                Object object2 = edgeList.edgeAt(i).getNeighbor(this);
                if (!((Node)object2).hasType((ATerm)aTermAppl)) continue;
                boolean bl2 = false;
                for (int j = 0; j < object.size(); ++j) {
                    Node node;
                    int n2;
                    List list = (List)object.get(j);
                    for (n2 = 0; n2 < list.size() && ((Node)object2).isDifferent(node = (Node)list.get(n2)); ++n2) {
                    }
                    if (n2 != list.size()) continue;
                    bl2 = true;
                    list.add(object2);
                    if (list.size() < n) continue;
                    bl = true;
                    break block0;
                }
                if (bl2) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object2);
                object.add(arrayList);
                if (n != 1) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return null;
        }
        object = DependencySet.EMPTY;
        for (Object object2 : edgeList) {
            object = ((DependencySet)object).union(role.getExplainSubOrInv(object2.getRole()), this.abox.doExplanation());
            object = ((DependencySet)object).union(object2.getDepends(), this.abox.doExplanation());
            Node node = object2.getNeighbor(this);
            DependencySet dependencySet = node.getDepends((ATerm)aTermAppl);
            if (dependencySet == null) continue;
            object = ((DependencySet)object).union(dependencySet, this.abox.doExplanation());
        }
        return object;
    }

    public boolean hasDistinctRNeighborsForMin(Role role, int n, ATermAppl aTermAppl) {
        return this.hasDistinctRNeighborsForMin(role, n, aTermAppl, false);
    }

    public boolean hasDistinctRNeighborsForMin(Role role, int n, ATermAppl aTermAppl, boolean bl) {
        EdgeList edgeList = this.getRNeighborEdges(role);
        if (n == 1 && !bl && aTermAppl.equals(ATermUtils.TOP)) {
            return !edgeList.isEmpty();
        }
        if (edgeList.size() < n) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < edgeList.size(); ++i) {
            Node node = edgeList.edgeAt(i).getNeighbor(this);
            if (!node.hasType((ATerm)aTermAppl)) continue;
            if (bl) {
                if (node.isBlockable()) continue;
                if (n == 1) {
                    return true;
                }
            }
            boolean bl2 = false;
            for (int j = 0; j < arrayList.size(); ++j) {
                boolean bl3 = true;
                List list = (List)arrayList.get(j);
                for (int k = 0; k < list.size(); ++k) {
                    Node node2 = (Node)list.get(k);
                    if (node.isDifferent(node2)) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                bl2 = true;
                list.add(node);
                if (list.size() < n) continue;
                return true;
            }
            if (!bl2) {
                ArrayList<Node> arrayList2 = new ArrayList<Node>();
                arrayList2.add(node);
                arrayList.add(arrayList2);
            }
            if (n != 1 || arrayList.size() < 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasRNeighbor(Role role) {
        if (this.outEdges.hasEdge(role)) {
            return true;
        }
        Role role2 = role.getInverse();
        return role2 != null && this.inEdges.hasEdge(role2);
    }

    public boolean hasRSuccessor(Role role) {
        return this.outEdges.hasEdge(role);
    }

    @Override
    public boolean hasSuccessor(Node node) {
        return this.outEdges.hasEdgeTo(node);
    }

    public final boolean hasRSuccessor(Role role, Node node) {
        return this.outEdges.hasEdge(this, role, node);
    }

    public Bool hasDataPropertyValue(Role role, Object object) {
        Bool bool = Bool.FALSE;
        EdgeList edgeList = this.outEdges.getEdges(role);
        for (int i = 0; i < edgeList.size(); ++i) {
            Edge edge = edgeList.edgeAt(i);
            DependencySet dependencySet = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            Object object2 = literal.getValue();
            if (object != null && object2 == null) {
                try {
                    if (this.abox.dtReasoner.isSatisfiable(literal.getTypes(), object)) {
                        bool = Bool.UNKNOWN;
                        continue;
                    }
                    bool = Bool.FALSE;
                    continue;
                }
                catch (DatatypeReasonerException datatypeReasonerException) {
                    String string = "Unexpected datatype reasoner exception while checking property value: " + datatypeReasonerException.getMessage();
                    log.severe(string);
                    throw new InternalReasonerException(string);
                }
            }
            if (object != null && !object.equals(object2)) continue;
            if (dependencySet.isIndependent()) {
                return Bool.TRUE;
            }
            bool = Bool.UNKNOWN;
        }
        return bool;
    }

    public boolean hasRNeighbor(Role role, Node node) {
        if (this.hasRSuccessor(role, node)) {
            return true;
        }
        if (node instanceof Individual) {
            return ((Individual)node).hasRSuccessor(role.getInverse(), this);
        }
        return false;
    }

    @Override
    protected void addInEdge(Edge edge) {
        this.setChanged(3);
        this.setChanged(5);
        this.applyNext[5] = 0;
        this.inEdges.addEdge(edge);
    }

    protected void addOutEdge(Edge edge) {
        this.setChanged(3);
        this.setChanged(5);
        this.applyNext[5] = 0;
        if (edge.getRole().isBottom()) {
            this.abox.setClash(Clash.bottomProperty(edge.getFrom(), edge.getDepends(), edge.getRole().getName()));
        } else {
            this.outEdges.addEdge(edge);
        }
    }

    public Edge addEdge(Role role, Node node, DependencySet dependencySet) {
        if (this.abox.getBranch() > 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), node.getName());
        }
        if (role.isBottom()) {
            this.abox.setClash(Clash.bottomProperty(this, dependencySet, role.getName()));
            return null;
        }
        if (this.hasRSuccessor(role, node) || role.isTop()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("EDGE: " + this + " -> " + role + " -> " + node + ": " + dependencySet + " " + this.getRNeighborEdges(role).getEdgesTo(node));
            }
            return null;
        }
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding edge to a pruned node " + this + " " + role + " " + node);
        }
        if (this.isMerged()) {
            return null;
        }
        this.abox.setChanged(true);
        this.setChanged(3);
        this.setChanged(5);
        this.applyNext[5] = 0;
        dependencySet = dependencySet.copy(this.abox.getBranch());
        DefaultEdge defaultEdge = new DefaultEdge(role, this, node, dependencySet);
        this.outEdges.addEdge(defaultEdge);
        node.addInEdge(defaultEdge);
        return defaultEdge;
    }

    @Override
    public final EdgeList getOutEdges() {
        return this.outEdges;
    }

    public Individual getParent() {
        return this.parent;
    }

    @Override
    public void reset(boolean bl) {
        super.reset(bl);
        for (int i = 0; i < 7; ++i) {
            this.applyNext[i] = 0;
        }
        if (bl) {
            return;
        }
        this.outEdges.reset();
    }

    @Override
    protected void resetTypes() {
        Map.Entry entry;
        for (int i = 0; i < 7; ++i) {
            entry = this.types[i];
            int n = ((ArrayList)((Object)entry)).size();
            for (int j = 0; j < n; ++j) {
                ATermAppl aTermAppl = (ATermAppl)((ArrayList)((Object)entry)).get(j);
                if (((DependencySet)this.depends.get(aTermAppl)).getBranch() == DependencySet.NO_BRANCH) continue;
                Collections.swap(entry, j--, --n);
                this.depends.remove(aTermAppl);
            }
            if (n >= ((ArrayList)((Object)entry)).size()) continue;
            ((ArrayList)((Object)entry)).subList(n, ((ArrayList)((Object)entry)).size()).clear();
        }
        Iterator iterator = this.depends.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (((DependencySet)entry.getValue()).getBranch() == DependencySet.NO_BRANCH) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean restore(int n) {
        DependencySet dependencySet;
        int n2;
        Boolean bl = this.restorePruned(n);
        if (Boolean.FALSE.equals(bl)) {
            return bl;
        }
        boolean bl2 = Boolean.TRUE.equals(bl);
        bl2 |= super.restore(n);
        for (n2 = 0; n2 < 7; ++n2) {
            this.applyNext[n2] = 0;
        }
        n2 = 0;
        Iterator<Object> iterator = this.outEdges.iterator();
        while (iterator.hasNext()) {
            Edge object = iterator.next();
            dependencySet = object.getDepends();
            if (dependencySet.getBranch() <= n) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("RESTORE: " + this.name + " remove edge " + object + " " + dependencySet.max() + " " + n);
            }
            iterator.remove();
            bl2 = true;
            n2 = 1;
            if (!PelletOptions.USE_INCREMENTAL_CONSISTENCY) continue;
            this.abox.getIncrementalChangeTracker().addDeletedEdge(object);
        }
        if (n2 != 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.EXISTENTIAL);
            this.abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.MIN_NUMBER);
        }
        if (this.modifiedAfterMerge && bl2) {
            for (Map.Entry entry : this.depends.entrySet()) {
                dependencySet = (ATermAppl)entry.getKey();
                ATermAppl aTermAppl = ATermUtils.negate((ATermAppl)dependencySet);
                DependencySet dependencySet2 = (DependencySet)this.depends.get(aTermAppl);
                if (dependencySet2 == null) continue;
                DependencySet dependencySet3 = (DependencySet)entry.getValue();
                DependencySet dependencySet4 = ATermUtils.isNot(aTermAppl) ? dependencySet : aTermAppl;
                dependencySet3 = dependencySet3.union(dependencySet2, this.abox.doExplanation());
                this.abox.setClash(Clash.atomic(this, dependencySet3, (ATermAppl)dependencySet4));
            }
            this.modifiedAfterMerge = false;
        }
        return bl2;
    }

    public final boolean removeEdge(Edge edge) {
        boolean bl = this.outEdges.removeEdge(edge);
        if (!bl) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    @Override
    public void prune(DependencySet dependencySet) {
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
        }
        this.pruned = dependencySet;
        for (int i = 0; i < this.outEdges.size(); ++i) {
            Edge edge = this.outEdges.edgeAt(i);
            Node node = edge.getTo();
            if (node.isPruned()) continue;
            if (node.isNominal()) {
                node.removeInEdge(edge);
                continue;
            }
            node.prune(dependencySet);
        }
    }

    @Override
    public void unprune(int n) {
        super.unprune(n);
        boolean bl = false;
        for (int i = 0; i < this.outEdges.size(); ++i) {
            Edge edge = this.outEdges.edgeAt(i);
            DependencySet dependencySet = edge.getDepends();
            if (dependencySet.getBranch() > n) continue;
            Node node = edge.getTo();
            Role role = edge.getRole();
            if (node.inEdges.hasExactEdge(this, role, node)) continue;
            node.addInEdge(edge);
            if (PelletOptions.TRACK_BRANCH_EFFECTS) {
                this.abox.getBranchEffectTracker().add(dependencySet.getBranch(), node.name);
                this.abox.getBranchEffectTracker().add(dependencySet.getBranch(), this.name);
            }
            if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
            bl = true;
            if (!(node instanceof Individual)) continue;
            Individual individual = (Individual)node;
            individual.applyNext[5] = 0;
            QueueElement queueElement = new QueueElement(individual);
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.GUESS);
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.CHOOSE);
        }
        if (bl) {
            this.applyNext[5] = 0;
            QueueElement queueElement = new QueueElement(this);
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.GUESS);
            this.abox.getCompletionQueue().add(queueElement, NodeSelector.CHOOSE);
        }
    }

    public String debugString() {
        return this.name.getName() + " = " + this.types[0] + this.types[3] + this.types[2] + this.types[1] + this.types[4] + this.types[5] + this.types[6] + "; **" + this.outEdges + "**" + "; **" + this.inEdges + "**" + " --> " + this.depends + "";
    }

    @Override
    protected void updateNodeReferences() {
        super.updateNodeReferences();
        if (this.parent != null) {
            this.parent = this.abox.getIndividual((ATerm)this.parent.getName());
        }
        if (this.isPruned()) {
            EdgeList edgeList = this.outEdges;
            this.outEdges = new EdgeList(edgeList.size());
            for (int i = 0; i < edgeList.size(); ++i) {
                Edge edge = edgeList.edgeAt(i);
                Node node = this.abox.getNode((ATerm)edge.getTo().getName());
                DefaultEdge defaultEdge = new DefaultEdge(edge.getRole(), this, node, edge.getDepends());
                this.outEdges.addEdge(defaultEdge);
            }
        }
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isTop() {
        return false;
    }
}

