/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Core;
import com.clarkparsia.pellet.sparqldl.model.NotKnownQueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.UnionQueryAtom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.KBOperation;
import org.mindswap.pellet.utils.SizeEstimate;

public class QueryCost {
    private double staticCost;
    private double branchCount;
    private KnowledgeBase kb;
    private SizeEstimate estimate;

    public QueryCost(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.estimate = knowledgeBase.getSizeEstimate();
    }

    public double estimate(List<QueryAtom> list) {
        return this.estimate(list, new HashSet<ATermAppl>());
    }

    public double estimate(List<QueryAtom> list, Collection<ATermAppl> collection) {
        QueryAtom queryAtom;
        int n;
        double d = 1.0;
        double d2 = 1.0;
        this.branchCount = 1.0;
        this.staticCost = 1.0;
        int n2 = list.size();
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(collection);
        ArrayList<HashSet<ATermAppl>> arrayList = new ArrayList<HashSet<ATermAppl>>(n2);
        for (n = 0; n < n2; ++n) {
            queryAtom = list.get(n);
            arrayList.add(hashSet);
            hashSet = new HashSet<ATermAppl>(hashSet);
            hashSet.addAll(queryAtom.getArguments());
        }
        for (n = n2 - 1; n >= 0; --n) {
            queryAtom = list.get(n);
            this.estimate(queryAtom, (Collection<ATermAppl>)((Collection)arrayList.get(n)));
            d2 *= this.branchCount;
            d = this.staticCost + this.branchCount * d;
        }
        this.staticCost = d;
        this.branchCount = d2;
        return this.staticCost;
    }

    public double estimate(QueryAtom queryAtom) {
        return this.estimate(queryAtom, new HashSet<ATermAppl>());
    }

    public double estimate(QueryAtom queryAtom, Collection<ATermAppl> collection) {
        boolean bl = false;
        boolean bl2 = false;
        List<ATermAppl> list = queryAtom.getArguments();
        for (ATermAppl aTermAppl : list) {
            if (!this.isConstant(aTermAppl)) continue;
            collection.add(aTermAppl);
        }
        block0 : switch (queryAtom.getPredicate()) {
            case DirectType: {
                bl = true;
            }
            case Type: {
                ATermAppl aTermAppl;
                ATermAppl aTermAppl2 = list.get(0);
                aTermAppl = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = bl ? (double)this.estimate.getCost(KBOperation.IS_DIRECT_TYPE) : (double)this.estimate.getCost(KBOperation.IS_TYPE);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl)) {
                    this.staticCost = bl ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_INSTANCES) : (double)this.estimate.getCost(KBOperation.GET_INSTANCES);
                    this.branchCount = this.isConstant(aTermAppl) ? (double)this.estimate.size(aTermAppl) : this.estimate.avgInstancesPerClass(bl);
                    break;
                }
                if (collection.contains(aTermAppl2)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_TYPES);
                    this.branchCount = this.isConstant(aTermAppl2) ? (double)this.estimate.classesPerInstance(aTermAppl2, bl) : this.estimate.avgClassesPerInstance(bl);
                    break;
                }
                this.staticCost = (long)this.estimate.getClassCount() * (bl ? this.estimate.getCost(KBOperation.GET_DIRECT_INSTANCES) : this.estimate.getCost(KBOperation.GET_INSTANCES));
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgInstancesPerClass(bl);
                break;
            }
            case Annotation: 
            case PropertyValue: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.HAS_PROPERTY_VALUE);
                    this.branchCount = 1.0;
                    break;
                }
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl3 = list.get(1);
                ATermAppl aTermAppl4 = list.get(2);
                if (collection.contains(aTermAppl3)) {
                    if (collection.contains(aTermAppl)) {
                        this.staticCost = this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                        this.branchCount = this.isConstant(aTermAppl3) ? this.estimate.avg(aTermAppl3) : this.estimate.avgSubjectsPerProperty();
                        break;
                    }
                    if (collection.contains(aTermAppl4)) {
                        this.staticCost = this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                        if (this.isConstant(aTermAppl3)) {
                            if (this.kb.isObjectProperty((ATerm)aTermAppl3)) {
                                this.branchCount = this.estimate.avg(this.inv(aTermAppl3));
                                break;
                            }
                            this.branchCount = this.estimate.avgSubjectsPerProperty();
                            break;
                        }
                        this.branchCount = this.estimate.avgSubjectsPerProperty();
                        break;
                    }
                    this.staticCost = (double)this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE) + (this.isConstant(aTermAppl3) ? this.estimate.avg(aTermAppl3) : this.estimate.avgSubjectsPerProperty()) * (double)this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                    this.branchCount = this.isConstant(aTermAppl3) ? (double)this.estimate.size(aTermAppl3) : this.estimate.avgPairsPerProperty();
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl4)) {
                    this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE);
                    this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgSubjectsPerProperty();
                    break;
                }
                this.staticCost = (double)this.estimate.getPropertyCount() * ((double)this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE) + this.estimate.avgSubjectsPerProperty() * (double)this.estimate.getCost(KBOperation.GET_PROPERTY_VALUE));
                this.branchCount = this.estimate.avgPairsPerProperty() * (double)this.estimate.getPropertyCount();
                break;
            }
            case SameAs: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl5 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_SAME_AS);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl5)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_SAMES);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.sames(aTermAppl) : this.estimate.avgSamesPerInstance();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl5) ? this.estimate.sames(aTermAppl5) : this.estimate.avgSamesPerInstance();
                    break;
                }
                this.staticCost = (long)this.estimate.getInstanceCount() * this.estimate.getCost(KBOperation.GET_SAMES);
                this.branchCount = (double)this.estimate.getInstanceCount() * this.estimate.avgSamesPerInstance();
                break;
            }
            case DifferentFrom: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl6 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_DIFFERENT_FROM);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl6)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_DIFFERENTS);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.differents(aTermAppl) : this.estimate.avgDifferentsPerInstance();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl6) ? this.estimate.differents(aTermAppl6) : this.estimate.avgDifferentsPerInstance();
                    break;
                }
                this.staticCost = (long)this.estimate.getInstanceCount() * this.estimate.getCost(KBOperation.GET_DIFFERENTS);
                this.branchCount = (double)this.estimate.getInstanceCount() * this.estimate.avgDifferentsPerInstance();
                break;
            }
            case DirectSubClassOf: {
                bl = true;
            }
            case StrictSubClassOf: {
                bl2 = true;
            }
            case SubClassOf: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl7 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = bl2 ? (bl ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)(this.estimate.getCost(KBOperation.IS_SUBCLASS_OF) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES))) : (double)this.estimate.getCost(KBOperation.IS_SUBCLASS_OF);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl7)) {
                    if (bl2 && !bl) {
                        this.staticCost = this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                    } else {
                        double d = this.staticCost = bl ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES);
                    }
                    if (collection.contains(aTermAppl)) {
                        double d = this.branchCount = this.isConstant(aTermAppl) ? this.estimate.superClasses(aTermAppl, bl) : this.estimate.avgSuperClasses(bl);
                        if (!bl2) break;
                        this.branchCount -= this.isConstant(aTermAppl) ? this.estimate.equivClasses(aTermAppl) : this.estimate.avgEquivClasses();
                        this.branchCount = Math.max(this.branchCount, 0.0);
                        break;
                    }
                    double d = this.branchCount = this.isConstant(aTermAppl7) ? this.estimate.superClasses(aTermAppl7, bl) : this.estimate.avgSuperClasses(bl);
                    if (!bl2) break;
                    this.branchCount -= this.isConstant(aTermAppl7) ? this.estimate.equivClasses(aTermAppl7) : this.estimate.avgEquivClasses();
                    this.branchCount = Math.max(this.branchCount, 0.0);
                    break;
                }
                this.staticCost = bl2 && !bl ? (double)(this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES)) : (bl ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERCLASSES) : (double)this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERCLASSES));
                this.staticCost *= (double)this.estimate.getClassCount();
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgSubClasses(bl);
                if (!bl2) break;
                this.branchCount -= this.estimate.avgEquivClasses();
                this.branchCount = Math.max(this.branchCount, 0.0);
                break;
            }
            case EquivalentClass: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl8 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_EQUIVALENT_CLASS);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl8)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.equivClasses(aTermAppl) : this.estimate.avgEquivClasses();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl8) ? this.estimate.equivClasses(aTermAppl8) : this.estimate.avgEquivClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getClassCount() * this.estimate.getCost(KBOperation.GET_EQUIVALENT_CLASSES);
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgEquivClasses();
                break;
            }
            case DisjointWith: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl9 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_DISJOINT_WITH);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl9)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_DISJOINT_CLASSES);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.disjoints(aTermAppl) : this.estimate.avgDisjointClasses();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl9) ? this.estimate.disjoints(aTermAppl9) : this.estimate.avgDisjointClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getClassCount() * this.estimate.getCost(KBOperation.GET_DISJOINT_CLASSES);
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgDisjointClasses();
                break;
            }
            case ComplementOf: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl10 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_COMPLEMENT_OF);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl10)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_COMPLEMENT_CLASSES);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.complements(aTermAppl) : this.estimate.avgComplementClasses();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl10) ? this.estimate.complements(aTermAppl10) : this.estimate.avgComplementClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getClassCount() * this.estimate.getCost(KBOperation.GET_COMPLEMENT_CLASSES);
                this.branchCount = (double)this.estimate.getClassCount() * this.estimate.avgComplementClasses();
                break;
            }
            case DirectSubPropertyOf: {
                bl = true;
            }
            case StrictSubPropertyOf: {
                bl2 = true;
            }
            case SubPropertyOf: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl11 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = bl2 ? (bl ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)(this.estimate.getCost(KBOperation.IS_SUBPROPERTY_OF) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES))) : (double)this.estimate.getCost(KBOperation.IS_SUBPROPERTY_OF);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl11)) {
                    if (bl2 && !bl) {
                        this.staticCost = this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                    } else {
                        double d = this.staticCost = bl ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES);
                    }
                    if (collection.contains(aTermAppl)) {
                        double d = this.branchCount = this.isConstant(aTermAppl) ? this.estimate.superProperties(aTermAppl, bl) : this.estimate.avgSuperProperties(bl);
                        if (!bl2) break;
                        this.branchCount -= this.isConstant(aTermAppl) ? this.estimate.equivProperties(aTermAppl) : this.estimate.avgEquivProperties();
                        this.branchCount = Math.max(this.branchCount, 0.0);
                        break;
                    }
                    double d = this.branchCount = this.isConstant(aTermAppl11) ? this.estimate.superProperties(aTermAppl11, bl) : this.estimate.avgSuperProperties(bl);
                    if (!bl2) break;
                    this.branchCount -= this.isConstant(aTermAppl11) ? this.estimate.equivProperties(aTermAppl11) : this.estimate.avgEquivProperties();
                    this.branchCount = Math.max(this.branchCount, 0.0);
                    break;
                }
                this.staticCost = bl2 && !bl ? (double)(this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES) + this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES)) : (bl ? (double)this.estimate.getCost(KBOperation.GET_DIRECT_SUB_OR_SUPERPROPERTIES) : (double)this.estimate.getCost(KBOperation.GET_SUB_OR_SUPERPROPERTIES));
                this.staticCost *= (double)this.estimate.getPropertyCount();
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgSubProperties(bl);
                if (!bl2) break;
                this.branchCount -= this.estimate.avgEquivProperties();
                this.branchCount = Math.max(this.branchCount, 0.0);
                break;
            }
            case EquivalentProperty: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl12 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_EQUIVALENT_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl12)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.equivProperties(aTermAppl) : this.estimate.avgEquivProperties();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl12) ? this.estimate.equivProperties(aTermAppl12) : this.estimate.avgEquivProperties();
                    break;
                }
                this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_EQUIVALENT_PROPERTIES);
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgEquivProperties();
                break;
            }
            case Domain: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl13 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_DOMAIN);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl13)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_DOMAINS);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.equivProperties(aTermAppl) : this.estimate.avgEquivProperties();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl13) ? this.estimate.equivClasses(aTermAppl13) : this.estimate.avgEquivClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_DOMAINS);
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgEquivProperties();
                break;
            }
            case Range: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl14 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_RANGE);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl14)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_RANGES);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.equivProperties(aTermAppl) : this.estimate.avgEquivProperties();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl14) ? this.estimate.equivClasses(aTermAppl14) : this.estimate.avgEquivClasses();
                    break;
                }
                this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_RANGES);
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgEquivProperties();
                break;
            }
            case InverseOf: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl15 = list.get(1);
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_INVERSE_OF);
                    this.branchCount = 1.0;
                    break;
                }
                if (collection.contains(aTermAppl) || collection.contains(aTermAppl15)) {
                    this.staticCost = this.estimate.getCost(KBOperation.GET_INVERSES);
                    if (collection.contains(aTermAppl)) {
                        this.branchCount = this.isConstant(aTermAppl) ? this.estimate.inverses(aTermAppl) : this.estimate.avgInverseProperties();
                        break;
                    }
                    this.branchCount = this.isConstant(aTermAppl15) ? this.estimate.inverses(aTermAppl15) : this.estimate.avgInverseProperties();
                    break;
                }
                this.staticCost = (long)this.estimate.getPropertyCount() * this.estimate.getCost(KBOperation.GET_INVERSES);
                this.branchCount = (double)this.estimate.getPropertyCount() * this.estimate.avgInverseProperties();
                break;
            }
            case ObjectProperty: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_OBJECT_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_OBJECT_PROPERTIES);
                this.branchCount = this.estimate.getObjectPropertyCount();
                break;
            }
            case DatatypeProperty: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_DATATYPE_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_DATATYPE_PROPERTIES);
                this.branchCount = this.estimate.getDataPropertyCount();
                break;
            }
            case Functional: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_FUNCTIONAL_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_FUNCTIONAL_PROPERTIES);
                this.branchCount = this.estimate.getFunctionalPropertyCount();
                break;
            }
            case InverseFunctional: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_INVERSE_FUNCTIONAL_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_INVERSE_FUNCTIONAL_PROPERTIES);
                this.branchCount = this.estimate.getInverseFunctionalPropertyCount();
                break;
            }
            case Transitive: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_TRANSITIVE_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_TRANSITIVE_PROPERTIES);
                this.branchCount = this.estimate.getTransitivePropertyCount();
                break;
            }
            case Symmetric: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_SYMMETRIC_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_SYMMETRIC_PROPERTIES);
                this.branchCount = this.estimate.getSymmetricPropertyCount();
                break;
            }
            case Asymmetric: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_ASYMMETRIC_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_ASYMMETRIC_PROPERTIES);
                this.branchCount = this.estimate.getSymmetricPropertyCount();
                break;
            }
            case Reflexive: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_REFLEXIVE_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_REFLEXIVE_PROPERTIES);
                this.branchCount = this.estimate.getSymmetricPropertyCount();
                break;
            }
            case Irreflexive: {
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_IRREFLEXIVE_PROPERTY);
                    this.branchCount = 1.0;
                    break;
                }
                this.staticCost = this.estimate.getCost(KBOperation.GET_IRREFLEXIVE_PROPERTIES);
                this.branchCount = this.estimate.getSymmetricPropertyCount();
                break;
            }
            case NotKnown: {
                this.estimate(((NotKnownQueryAtom)queryAtom).getAtoms(), collection);
                break;
            }
            case Union: {
                double d = 1.0;
                double d2 = 1.0;
                for (List<QueryAtom> list2 : ((UnionQueryAtom)queryAtom).getUnion()) {
                    this.estimate(list2, collection);
                    d2 += this.branchCount;
                    d += this.staticCost;
                }
                this.staticCost = d;
                this.branchCount = d2;
                break;
            }
            case UndistVarCore: {
                double d;
                if (collection.containsAll(list)) {
                    this.staticCost = this.estimate.getCost(KBOperation.IS_TYPE);
                    this.branchCount = 1.0;
                    break;
                }
                Core core = (Core)queryAtom;
                int n = core.getDistVars().size();
                this.branchCount = d = Math.pow(this.estimate.avgInstancesPerClass(false), n);
                switch (QueryEngine.getStrategy(queryAtom)) {
                    case ALLFAST: 
                    case SIMPLE: {
                        this.staticCost = (double)((long)n * this.estimate.getCost(KBOperation.GET_INSTANCES)) + d * (double)this.estimate.getCost(KBOperation.IS_TYPE);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Not yet implemented.");
            }
            case Datatype: {
                this.staticCost = collection.containsAll(list) ? 1.0 : 2.147483647E9;
                this.branchCount = 1.0;
                break;
            }
            default: {
                throw new UnsupportedFeatureException("Unknown atom type " + (Object)((Object)queryAtom.getPredicate()) + ".");
            }
        }
        return this.staticCost;
    }

    public double getBranchCount() {
        return this.branchCount;
    }

    public double getStaticCost() {
        return this.staticCost;
    }

    private ATermAppl inv(ATermAppl aTermAppl) {
        return this.kb.getRBox().getRole((ATerm)aTermAppl).getInverse().getName();
    }

    private boolean isConstant(ATermAppl aTermAppl) {
        return !ATermUtils.isVar(aTermAppl);
    }
}

