/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import com.clarkparsia.pellet.rules.rete.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;

public class Interpreter {
    private Set<AlphaNode> dirtyAlphas;
    private List<Pair<Integer, Collection<AlphaNode>>> dirtyHistory;
    private Set<Fact> inferredFacts;
    private Set<Fact> matchingFacts;
    public Compiler rete;

    public Interpreter(ABox aBox) {
        this.rete = new Compiler(this, aBox);
        this.dirtyAlphas = new HashSet<AlphaNode>();
        this.dirtyHistory = new ArrayList<Pair<Integer, Collection<AlphaNode>>>();
        this.inferredFacts = new HashSet<Fact>();
        this.matchingFacts = new HashSet<Fact>();
    }

    public boolean addFact(Fact fact) {
        return this.addFact(fact, true);
    }

    private boolean addFact(Fact fact, boolean bl) {
        if (this.knowFact(fact)) {
            return false;
        }
        if (!bl) {
            fact = new Fact(this.copyDS(fact.getDependencySet()), fact.getElements());
            this.inferredFacts.add(fact);
        }
        boolean bl2 = false;
        for (AlphaNode alphaNode : this.rete.alphaIndex.match(fact)) {
            alphaNode.add(fact);
            bl2 = true;
            this.dirtyAlphas.add(alphaNode);
        }
        if (bl2) {
            this.matchingFacts.add(fact);
        }
        return bl2;
    }

    private DependencySet copyDS(DependencySet dependencySet) {
        dependencySet = dependencySet.copy(this.rete.abox.getBranch());
        return dependencySet;
    }

    public boolean isDirty() {
        return !this.dirtyAlphas.isEmpty();
    }

    private boolean knowFact(Fact fact) {
        return this.matchingFacts.contains(fact) || this.inferredFacts != null && this.inferredFacts.contains(fact);
    }

    private void processBetaNodes(List<BetaNode> list) {
        while (!list.isEmpty()) {
            List<Fact> list2;
            BetaNode betaNode = list.remove(0);
            if (!betaNode.isDirty() || (list2 = betaNode.join()) == null || list2.size() <= 0) continue;
            if (betaNode.rule != null) {
                List<TermTuple> list3 = betaNode.rule.rhs;
                if (list3.isEmpty()) {
                    list3 = Collections.singletonList(new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[0]));
                }
                for (TermTuple termTuple : list3) {
                    Set<Fact> set = betaNode.matchingFacts(termTuple, list2);
                    for (Fact fact : set) {
                        this.addFact(fact, false);
                    }
                }
                continue;
            }
            for (BetaNode betaNode2 : betaNode.getBetas()) {
                betaNode2.markDirty();
                list.add(betaNode2);
            }
        }
    }

    public boolean removeMentions(ATermAppl aTermAppl) {
        boolean bl = false;
        Iterator<Fact> iterator = this.matchingFacts.iterator();
        block0: while (iterator.hasNext()) {
            Fact fact = iterator.next();
            for (ATermAppl aTermAppl2 : fact.getElements()) {
                if (!aTermAppl2.equals(aTermAppl)) continue;
                iterator.remove();
                bl = true;
                for (AlphaNode alphaNode : this.rete.alphaIndex.match(fact)) {
                    if (!alphaNode.remove(fact)) {
                        throw new InternalReasonerException("Could not remove fact");
                    }
                    this.dirtyAlphas.add(alphaNode);
                }
                continue block0;
            }
        }
        return bl;
    }

    public void reset() {
        this.rete.alphaIndex.reset();
        this.dirtyAlphas.clear();
        this.dirtyHistory.clear();
        this.inferredFacts.clear();
        this.matchingFacts.clear();
    }

    public boolean restore(int n) {
        Object object;
        boolean bl = false;
        Iterator<Object> iterator = this.dirtyHistory.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if ((Integer)((Pair)object).first <= n) break;
            for (AlphaNode alphaNode : (Collection)((Pair)object).second) {
                alphaNode.markDirty();
                this.dirtyAlphas.add(alphaNode);
                bl = true;
            }
            iterator.remove();
        }
        iterator = this.matchingFacts.iterator();
        while (iterator.hasNext()) {
            object = (Fact)iterator.next();
            if (((Tuple)object).getDependencySet().getBranch() <= n) continue;
            iterator.remove();
            for (AlphaNode alphaNode : this.rete.alphaIndex.match((Fact)object)) {
                if (!alphaNode.remove((Fact)object)) {
                    throw new InternalReasonerException("Couldn't remove fact: " + object);
                }
                this.dirtyAlphas.add(alphaNode);
                bl = true;
            }
        }
        iterator = this.inferredFacts.iterator();
        while (iterator.hasNext()) {
            object = (Fact)iterator.next();
            if (((Tuple)object).getDependencySet().getBranch() <= n) continue;
            iterator.remove();
        }
        return bl;
    }

    public Set<Fact> run() {
        ArrayList<AlphaNode> arrayList = new ArrayList<AlphaNode>(this.dirtyAlphas);
        this.dirtyHistory.add(0, new Pair<Integer, ArrayList<AlphaNode>>(this.rete.abox.getBranch(), arrayList));
        ArrayList<Fact> arrayList2 = new ArrayList<Fact>(this.inferredFacts);
        while (this.isDirty()) {
            ArrayList<BetaNode> arrayList3 = new ArrayList<BetaNode>();
            for (AlphaNode alphaNode : this.dirtyAlphas) {
                arrayList3.addAll(alphaNode.getBetas());
            }
            this.dirtyAlphas.clear();
            this.processBetaNodes(arrayList3);
        }
        return SetUtils.difference(this.inferredFacts, arrayList2);
    }
}

