/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.el.Trigger;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

class ConceptInfo {
    public static final Logger logger = Logger.getLogger(ConceptInfo.class.getName());
    private final ATermAppl concept;
    private final Set<Trigger> triggers;
    private final MultiValueMap<ATermAppl, ConceptInfo> successors;
    private final MultiValueMap<ATermAppl, ConceptInfo> predecessors;
    private final Set<ConceptInfo> superClasses;

    public ConceptInfo(ATermAppl aTermAppl, boolean bl, boolean bl2) {
        this.concept = aTermAppl;
        this.superClasses = CollectionUtils.makeSet();
        this.successors = bl ? new MultiValueMap() : null;
        this.predecessors = new MultiValueMap();
        this.triggers = bl2 ? null : new HashSet();
    }

    public boolean addSuccessor(ATermAppl aTermAppl, ConceptInfo conceptInfo) {
        if (conceptInfo.predecessors.add(aTermAppl, this)) {
            if (this.successors != null) {
                this.successors.add(aTermAppl, conceptInfo);
            }
            return true;
        }
        return false;
    }

    public boolean addSuperClass(ConceptInfo conceptInfo) {
        return this.superClasses.add(conceptInfo);
    }

    public boolean addTrigger(Trigger trigger) {
        return this.triggers.add(trigger);
    }

    public boolean equals(Object object) {
        return object instanceof ConceptInfo && ((ConceptInfo)object).concept == this.concept;
    }

    public ATermAppl getConcept() {
        return this.concept;
    }

    public MultiValueMap<ATermAppl, ConceptInfo> getSuccessors() {
        return this.successors;
    }

    public MultiValueMap<ATermAppl, ConceptInfo> getPredecessors() {
        return this.predecessors;
    }

    public Set<ConceptInfo> getSuperClasses() {
        return this.superClasses;
    }

    public Set<Trigger> getTriggers() {
        return this.triggers;
    }

    public boolean hasSuccessor(ATermAppl aTermAppl, ConceptInfo conceptInfo) {
        return conceptInfo.predecessors.contains(aTermAppl, this);
    }

    public int hashCode() {
        return this.concept.hashCode();
    }

    public boolean hasSuperClass(ConceptInfo conceptInfo) {
        return this.superClasses.contains(conceptInfo);
    }

    public String toString() {
        return ATermUtils.toString(this.concept);
    }
}

