/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDUnsignedByte
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedByte instance;
    private static final short MAX_VALUE;

    public static XSDUnsignedByte getInstance() {
        return instance;
    }

    private XSDUnsignedByte() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedByte"), 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            short s = DatatypeConverter.parseShort(string);
            if (s < 0) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            if (s > MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return s;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    static {
        MAX_VALUE = (short)255;
        instance = new XSDUnsignedByte();
    }
}

