/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.Bool;

public class Taxonomy<T> {
    public static final Logger log = Logger.getLogger(Taxonomy.class.getName());
    private static final boolean SUB = true;
    private static final boolean SUPER = false;
    public static final boolean TOP_DOWN = true;
    protected TaxonomyNode<T> bottomNode;
    protected Map<T, TaxonomyNode<T>> nodes = CollectionUtils.makeMap();
    protected TaxonomyNode<T> topNode;
    protected short depth = 0;
    protected int totalBranching = 0;

    public Taxonomy() {
        this(null, null, null);
    }

    public Taxonomy(Collection<T> collection, T t, T t2) {
        if (t == null) {
            this.topNode = new TaxonomyNode<Object>((Object)null, true);
        } else {
            this.topNode = new TaxonomyNode<T>(t, false);
            this.nodes.put(t, this.topNode);
        }
        if (t2 == null) {
            this.bottomNode = new TaxonomyNode<Object>((Object)null, true);
        } else {
            this.bottomNode = new TaxonomyNode<T>(t2, false);
            this.nodes.put(t2, this.bottomNode);
        }
        if (collection == null || collection.isEmpty()) {
            this.topNode.addSub(this.bottomNode);
        } else {
            for (T t3 : collection) {
                this.addNode(t3, false);
            }
        }
    }

    public void addEquivalentNode(T t, TaxonomyNode<T> taxonomyNode) {
        taxonomyNode.addEquivalent(t);
        this.nodes.put(t, taxonomyNode);
    }

    public void addEquivalents(T t, Collection<T> collection) {
        assert (this.nodes.keySet().contains(t)) : "Element " + t.toString() + " not in taxonomy";
        TaxonomyNode<T> taxonomyNode = this.nodes.get(t);
        for (T t2 : collection) {
            assert (!this.nodes.keySet().contains(t2)) : "Element " + t2.toString() + " alread in taxonomy";
            taxonomyNode.addEquivalent(t2);
            this.nodes.put(t2, taxonomyNode);
        }
    }

    public TaxonomyNode<T> addNode(Collection<T> collection, Collection<T> collection2, Collection<T> collection3, boolean bl) {
        Object object2;
        assert (!collection.isEmpty()) : "Taxonomy nodes must have at least one element";
        assert (this.nodes.keySet().containsAll(collection2)) : "At least one super element not in taxonomy";
        assert (this.nodes.keySet().containsAll(collection3)) : "At least one sub element not in taxonomy";
        TaxonomyNode<T> taxonomyNode = new TaxonomyNode<T>(collection, bl);
        for (Object object2 : collection) {
            this.nodes.put(object2, taxonomyNode);
        }
        short s = 1;
        if (collection2.isEmpty()) {
            if (this.topNode.isHidden()) {
                this.topNode.addSub(taxonomyNode);
                if (this.topNode.getSubs().size() == 2) {
                    this.topNode.removeSub(this.bottomNode);
                }
            } else {
                taxonomyNode.addSupers(Collections.singleton(this.topNode));
            }
            ++this.totalBranching;
        } else {
            object2 = new HashSet();
            for (T t : collection2) {
                TaxonomyNode<T> taxonomyNode2 = this.nodes.get(t);
                if (taxonomyNode2.depth >= s) {
                    s = (short)(taxonomyNode2.depth + 1);
                }
                object2.add(taxonomyNode2);
            }
            taxonomyNode.depth = s;
            if (s > this.depth) {
                this.depth = s;
            }
            taxonomyNode.addSupers((Collection<TaxonomyNode<T>>)object2);
            this.totalBranching += object2.size();
        }
        if (collection3.isEmpty()) {
            if (this.bottomNode.isHidden()) {
                this.bottomNode.addSupers(Collections.singleton(taxonomyNode));
                this.bottomNode.getSupers().removeAll(taxonomyNode.getSupers());
            } else {
                taxonomyNode.addSub(this.bottomNode);
            }
            ++this.totalBranching;
        } else {
            object2 = new HashSet();
            for (T t : collection3) {
                object2.add(this.nodes.get(t));
            }
            taxonomyNode.addSubs((Collection<TaxonomyNode<T>>)object2);
            this.totalBranching += object2.size();
        }
        taxonomyNode.removeMultiplePaths();
        return taxonomyNode;
    }

    public TaxonomyNode<T> addNode(T t, boolean bl) {
        TaxonomyNode<T> taxonomyNode = new TaxonomyNode<T>(t, bl);
        this.topNode.addSub(taxonomyNode);
        taxonomyNode.addSub(this.bottomNode);
        this.nodes.put(t, taxonomyNode);
        return taxonomyNode;
    }

    public void addSuper(Collection<T> collection, T t) {
        assert (this.nodes.keySet().containsAll(collection)) : "At least one sub element not in taxonomy";
        assert (this.nodes.keySet().contains(t)) : "Super element " + t.toString() + " not in taxonomy";
        HashSet hashSet = new HashSet();
        for (Object object : collection) {
            hashSet.add(this.nodes.get(object));
        }
        TaxonomyNode<T> taxonomyNode = this.nodes.get(t);
        for (TaxonomyNode taxonomyNode2 : hashSet) {
            if (taxonomyNode2.getSupers().size() != 1 || !taxonomyNode2.getSupers().contains(this.topNode)) continue;
            this.topNode.removeSub(taxonomyNode2);
        }
        if (taxonomyNode.getSubs().size() == 1 && taxonomyNode.getSubs().contains(this.bottomNode)) {
            taxonomyNode.removeSub(this.bottomNode);
        }
        taxonomyNode.addSubs(hashSet);
    }

    public void addSuper(T t, T t2) {
        TaxonomyNode<T> taxonomyNode;
        assert (this.nodes.keySet().contains(t)) : "Sub element " + t.toString() + " not in taxonomy";
        assert (this.nodes.keySet().contains(t2)) : "Super element " + t2.toString() + " not in taxonomy";
        TaxonomyNode<T> taxonomyNode2 = this.nodes.get(t);
        if (taxonomyNode2.equals(taxonomyNode = this.nodes.get(t2))) {
            throw new InternalReasonerException("Equivalent elements cannot have sub/super relationship");
        }
        if (taxonomyNode2.getSupers().size() == 1 && taxonomyNode2.getSupers().iterator().next() == this.topNode) {
            this.topNode.removeSub(taxonomyNode2);
        }
        if (taxonomyNode.getSubs().size() == 1 && taxonomyNode.getSubs().iterator().next() == this.bottomNode) {
            taxonomyNode.removeSub(this.bottomNode);
        }
        taxonomyNode.addSub(taxonomyNode2);
    }

    public void addSupers(T t, Collection<T> collection) {
        assert (this.nodes.keySet().contains(t)) : "Sub element " + t.toString() + " not in taxonomy";
        assert (this.nodes.keySet().containsAll(collection)) : "At least one super element not in taxonomy";
        TaxonomyNode taxonomyNode = this.nodes.get(t);
        HashSet hashSet = new HashSet();
        for (T object : collection) {
            hashSet.add(this.nodes.get(object));
        }
        if (taxonomyNode.getSupers().size() == 1 && taxonomyNode.getSupers().contains(this.topNode)) {
            this.topNode.removeSub(taxonomyNode);
        }
        for (TaxonomyNode taxonomyNode2 : hashSet) {
            if (taxonomyNode2.getSubs().size() != 1 || !taxonomyNode2.getSubs().contains(this.bottomNode)) continue;
            taxonomyNode2.removeSub(this.bottomNode);
        }
        taxonomyNode.addSupers(hashSet);
    }

    public void assertValid() {
        assert (this.topNode.getSupers().isEmpty()) : "Top node in the taxonomy has parents";
        assert (this.bottomNode.getSubs().isEmpty()) : "Bottom node in the taxonomy has children";
    }

    public List<T> computeLCA(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        T t = list.get(0);
        ArrayList<T> arrayList = new ArrayList<T>(this.getFlattenedSupers(t, false));
        for (int i = 1; i < list.size() && arrayList.size() > 0; ++i) {
            t = list.get(i);
            arrayList.retainAll(this.getFlattenedSupers(t, false));
        }
        HashSet hashSet = new HashSet();
        for (Object e : arrayList) {
            if (hashSet.contains(e)) continue;
            Set set = this.getFlattenedSupers(e, false);
            hashSet.addAll(set);
        }
        arrayList.removeAll(hashSet);
        return arrayList;
    }

    public boolean contains(T t) {
        return this.nodes.containsKey(t);
    }

    public Iterator<Map.Entry<Set<T>, Object>> datumEquivalentsPair(Object object) {
        return new DatumEquivalentsPairIterator(this, object);
    }

    public Iterator<Object> depthFirstDatumOnly(T t, Object object) {
        return new DepthFirstDatumOnlyIterator<T>(this, t, object);
    }

    public Set<T> getAllEquivalents(T t) {
        TaxonomyNode<T> taxonomyNode = this.nodes.get(t);
        if (taxonomyNode == null) {
            return new HashSet();
        }
        HashSet<T> hashSet = new HashSet<T>(taxonomyNode.getEquivalents());
        return hashSet;
    }

    public TaxonomyNode<T> getBottom() {
        return this.bottomNode;
    }

    public Set<T> getClasses() {
        return this.nodes.keySet();
    }

    public Object getDatum(T t, Object object) {
        TaxonomyNode<T> taxonomyNode = this.nodes.get(t);
        return taxonomyNode == null ? null : taxonomyNode.getDatum(object);
    }

    public Set<T> getEquivalents(T t) {
        Set<T> set = this.getAllEquivalents(t);
        set.remove(t);
        return set;
    }

    public Set<T> getFlattenedSubs(T t, boolean bl) {
        return this.getFlattenedSubSupers(t, bl, true);
    }

    private Set<T> getFlattenedSubSupers(T t, boolean bl, boolean bl2) {
        TaxonomyNode taxonomyNode = this.nodes.get(t);
        HashSet hashSet = new HashSet();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(bl2 ? taxonomyNode.getSubs() : taxonomyNode.getSupers());
        for (int i = 0; i < arrayList.size(); ++i) {
            taxonomyNode = (TaxonomyNode)arrayList.get(i);
            if (taxonomyNode.isHidden()) continue;
            Set set = taxonomyNode.getEquivalents();
            hashSet.addAll(set);
            if (bl) continue;
            arrayList.addAll(bl2 ? taxonomyNode.getSubs() : taxonomyNode.getSupers());
        }
        return hashSet;
    }

    public Set<T> getFlattenedSupers(T t, boolean bl) {
        return this.getFlattenedSubSupers(t, bl, false);
    }

    public TaxonomyNode<T> getNode(T t) {
        return this.nodes.get(t);
    }

    public Collection<TaxonomyNode<T>> getNodes() {
        return this.nodes.values();
    }

    public Set<Set<T>> getSubs(T t) {
        return this.getSubs(t, false);
    }

    public Set<Set<T>> getSubs(T t, boolean bl) {
        return this.getSubSupers(t, bl, true);
    }

    private Set<Set<T>> getSubSupers(T t, boolean bl, boolean bl2) {
        TaxonomyNode taxonomyNode = this.nodes.get(t);
        if (taxonomyNode == null) {
            return Collections.emptySet();
        }
        HashSet<Set<T>> hashSet = new HashSet<Set<T>>();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(bl2 ? taxonomyNode.getSubs() : taxonomyNode.getSupers());
        for (int i = 0; i < arrayList.size(); ++i) {
            taxonomyNode = (TaxonomyNode)arrayList.get(i);
            if (taxonomyNode.isHidden()) continue;
            HashSet hashSet2 = new HashSet(taxonomyNode.getEquivalents());
            if (!hashSet2.isEmpty()) {
                hashSet.add(hashSet2);
            }
            if (bl) continue;
            arrayList.addAll(bl2 ? taxonomyNode.getSubs() : taxonomyNode.getSupers());
        }
        return hashSet;
    }

    public Set<Set<T>> getSupers(T t) {
        return this.getSupers(t, false);
    }

    public Set<Set<T>> getSupers(T t, boolean bl) {
        return this.getSubSupers(t, bl, false);
    }

    public TaxonomyNode<T> getTop() {
        return this.topNode;
    }

    public Bool isEquivalent(T t, T t2) {
        TaxonomyNode<T> taxonomyNode = this.nodes.get(t);
        TaxonomyNode<T> taxonomyNode2 = this.nodes.get(t2);
        if (taxonomyNode == null || taxonomyNode2 == null) {
            return Bool.UNKNOWN;
        }
        if (taxonomyNode.equals(taxonomyNode2)) {
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    public Bool isSubNodeOf(T t, T t2) {
        TaxonomyNode<T> taxonomyNode = this.nodes.get(t);
        TaxonomyNode<T> taxonomyNode2 = this.nodes.get(t2);
        if (taxonomyNode == null || taxonomyNode2 == null) {
            return Bool.UNKNOWN;
        }
        if (taxonomyNode.equals(taxonomyNode2)) {
            return Bool.TRUE;
        }
        if (taxonomyNode.isHidden()) {
            if (taxonomyNode2.isHidden()) {
                return Bool.UNKNOWN;
            }
            return this.getFlattenedSupers(t, false).contains(t2) ? Bool.TRUE : Bool.FALSE;
        }
        return this.getFlattenedSubs(t2, false).contains(t) ? Bool.TRUE : Bool.FALSE;
    }

    public void merge(TaxonomyNode<T> taxonomyNode, TaxonomyNode<T> taxonomyNode2) {
        ArrayList<TaxonomyNode<T>> arrayList = new ArrayList<TaxonomyNode<T>>(2);
        arrayList.add(taxonomyNode);
        arrayList.add(taxonomyNode2);
        TaxonomyNode<T> taxonomyNode3 = this.mergeNodes(arrayList);
        this.removeCycles(taxonomyNode3);
    }

    private TaxonomyNode<T> mergeNodes(List<TaxonomyNode<T>> list) {
        assert (list.size() > 1) : "Attempt to merge less than two nodes";
        if (log.isLoggable(Level.FINER)) {
            log.finer("Merge " + list);
        }
        TaxonomyNode<T> taxonomyNode = null;
        taxonomyNode = list.contains(this.topNode) ? this.topNode : (list.contains(this.bottomNode) ? this.bottomNode : list.get(0));
        HashSet<TaxonomyNode<T>> hashSet = new HashSet<TaxonomyNode<T>>();
        hashSet.add(taxonomyNode);
        for (TaxonomyNode<T> taxonomyNode2 : list) {
            if (hashSet.contains(taxonomyNode2)) continue;
            hashSet.add(taxonomyNode2);
            for (TaxonomyNode<T> taxonomyNode3 : taxonomyNode2.getSubs()) {
                if (taxonomyNode3 == this.bottomNode || list.contains(taxonomyNode3)) continue;
                if (taxonomyNode.getSubs().size() == 1 && taxonomyNode.getSubs().iterator().next() == this.bottomNode) {
                    taxonomyNode.removeSub(this.bottomNode);
                }
                taxonomyNode.addSub(taxonomyNode3);
            }
            for (TaxonomyNode<T> taxonomyNode3 : taxonomyNode2.getSupers()) {
                if (taxonomyNode3 == this.topNode || list.contains(taxonomyNode3)) continue;
                if (taxonomyNode.getSupers().size() == 1 && taxonomyNode.getSupers().iterator().next() == this.topNode) {
                    this.topNode.removeSub(taxonomyNode);
                }
                taxonomyNode3.addSub(taxonomyNode);
            }
            taxonomyNode2.disconnect();
            for (TaxonomyNode<T> taxonomyNode3 : taxonomyNode2.getEquivalents()) {
                this.addEquivalentNode(taxonomyNode3, taxonomyNode);
            }
        }
        taxonomyNode.clearData();
        if (taxonomyNode != this.topNode && taxonomyNode.getSupers().isEmpty()) {
            this.topNode.addSub(taxonomyNode);
        }
        if (taxonomyNode != this.bottomNode && taxonomyNode.getSubs().isEmpty()) {
            taxonomyNode.addSub(this.bottomNode);
        }
        return taxonomyNode;
    }

    public Object putDatum(T t, Object object, Object object2) {
        TaxonomyNode<T> taxonomyNode = this.nodes.get(t);
        if (taxonomyNode == null) {
            throw new RuntimeException(t + " is an unknown class!");
        }
        return taxonomyNode.putDatum(object, object2);
    }

    public void remove(T t) {
        assert (this.nodes.containsKey(t)) : "Element not contained in taxonomy";
        TaxonomyNode<T> taxonomyNode = this.nodes.remove(t);
        if (taxonomyNode.getEquivalents().size() == 1) {
            Collection<TaxonomyNode<T>> collection = taxonomyNode.getSubs();
            Collection<TaxonomyNode<T>> collection2 = taxonomyNode.getSupers();
            taxonomyNode.disconnect();
            for (TaxonomyNode<T> taxonomyNode2 : collection2) {
                taxonomyNode2.addSubs(collection);
            }
        } else {
            taxonomyNode.removeEquivalent(t);
        }
    }

    public void removeCycles(TaxonomyNode<T> taxonomyNode) {
        if (!this.nodes.get(taxonomyNode.getName()).equals(taxonomyNode)) {
            throw new InternalReasonerException("This node does not exist in the taxonomy: " + taxonomyNode.getName());
        }
        this.removeCycles(taxonomyNode, new ArrayList<TaxonomyNode<T>>());
    }

    private boolean removeCycles(TaxonomyNode<T> taxonomyNode, List<TaxonomyNode<T>> list) {
        if (list.contains(taxonomyNode)) {
            this.mergeNodes(list);
            return true;
        }
        list.add(taxonomyNode);
        ArrayList<TaxonomyNode<T>> arrayList = new ArrayList<TaxonomyNode<T>>(taxonomyNode.getSupers());
        int n = 0;
        while (n < arrayList.size()) {
            TaxonomyNode taxonomyNode2 = (TaxonomyNode)arrayList.get(n);
            this.removeCycles(taxonomyNode2, list);
            if (n >= arrayList.size() || !((TaxonomyNode)arrayList.get(n)).equals(taxonomyNode2)) continue;
            ++n;
        }
        list.remove(list.size() - 1);
        return false;
    }

    public Object removeDatum(T t, Object object) {
        return this.getNode(t).removeDatum(object);
    }

    public void resetSupers(T t, Collection<T> collection) {
        assert (this.nodes.keySet().contains(t)) : "Element " + t.toString() + " not in taxonomy";
        assert (this.nodes.keySet().containsAll(collection)) : "Supers not all contained in taxonomy";
        TaxonomyNode<T> taxonomyNode = this.nodes.get(t);
        ArrayList<TaxonomyNode<T>> arrayList = new ArrayList<TaxonomyNode<T>>(taxonomyNode.getSupers());
        for (TaxonomyNode object : arrayList) {
            object.removeSub(taxonomyNode);
        }
        if (collection.isEmpty()) {
            this.topNode.addSub(taxonomyNode);
        } else {
            HashSet hashSet = new HashSet();
            for (T t2 : collection) {
                TaxonomyNode<T> taxonomyNode2 = this.nodes.get(t2);
                if (!hashSet.add(taxonomyNode2)) continue;
                taxonomyNode2.addSub(taxonomyNode);
            }
        }
    }

    public List<T> topologocialSort(boolean bl) {
        return this.topologocialSort(bl, null);
    }

    public List<T> topologocialSort(boolean bl, Comparator<? super T> comparator) {
        HashMap hashMap = new HashMap();
        AbstractMap abstractMap = comparator == null ? new HashMap() : new TreeMap(comparator);
        HashSet<TaxonomyNode<T>> hashSet = new HashSet<TaxonomyNode<T>>();
        ArrayList arrayList = new ArrayList();
        log.fine("Topological sort...");
        for (TaxonomyNode<T> taxonomyNode : this.nodes.values()) {
            if (taxonomyNode.isHidden()) continue;
            hashSet.add(taxonomyNode);
            int n = taxonomyNode.getSupers().size();
            if (n == 0) {
                abstractMap.put(taxonomyNode.getName(), taxonomyNode);
                hashMap.put(taxonomyNode, 0);
                continue;
            }
            hashMap.put(taxonomyNode, n);
        }
        int n = hashSet.size();
        for (int i = 0; i < n; ++i) {
            if (abstractMap.isEmpty()) {
                throw new InternalReasonerException("Cycle detected in the taxonomy!");
            }
            TaxonomyNode taxonomyNode = (TaxonomyNode)abstractMap.values().iterator().next();
            int n2 = (Integer)hashMap.get(taxonomyNode);
            if (n2 != 0) {
                throw new InternalReasonerException("Cycle detected in the taxonomy " + taxonomyNode + " " + n2 + " " + arrayList.size() + " " + this.nodes.size());
            }
            abstractMap.remove(taxonomyNode.getName());
            hashSet.remove(taxonomyNode);
            if (bl) {
                arrayList.addAll(taxonomyNode.getEquivalents());
            } else {
                arrayList.add(taxonomyNode.getName());
            }
            for (TaxonomyNode taxonomyNode2 : taxonomyNode.getSubs()) {
                int n3 = (Integer)hashMap.get(taxonomyNode2);
                if (n3 == 1) {
                    abstractMap.put(taxonomyNode2.getName(), taxonomyNode2);
                    hashMap.put(taxonomyNode2, 0);
                    continue;
                }
                hashMap.put(taxonomyNode2, n3 - 1);
            }
        }
        if (!hashSet.isEmpty()) {
            throw new InternalReasonerException("Failed to sort elements: " + hashSet);
        }
        log.fine("done");
        return arrayList;
    }

    private class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public SimpleImmutableEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    private class DepthFirstDatumOnlyIterator<U>
    implements Iterator<Object> {
        private Object key;
        private List<TaxonomyNode<U>> pending;
        private Set<TaxonomyNode<U>> visited;

        public DepthFirstDatumOnlyIterator(Taxonomy<U> taxonomy2, U u, Object object) {
            this.key = object;
            this.visited = new HashSet<TaxonomyNode<U>>();
            this.pending = new ArrayList<TaxonomyNode<U>>();
            TaxonomyNode<U> taxonomyNode = taxonomy2.getNode(u);
            if (taxonomyNode != null) {
                this.pending.add(taxonomyNode);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.pending.isEmpty();
        }

        @Override
        public Object next() {
            if (this.pending.isEmpty()) {
                throw new NoSuchElementException();
            }
            TaxonomyNode<U> taxonomyNode = this.pending.remove(this.pending.size() - 1);
            this.visited.add(taxonomyNode);
            for (TaxonomyNode<U> taxonomyNode2 : taxonomyNode.getSubs()) {
                if (this.visited.contains(taxonomyNode2)) continue;
                this.pending.add(taxonomyNode2);
            }
            return taxonomyNode.getDatum(this.key);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class DatumEquivalentsPairIterator<U>
    implements Iterator<Map.Entry<Set<U>, Object>> {
        private Iterator<TaxonomyNode<U>> i;
        private Object key;

        public DatumEquivalentsPairIterator(Taxonomy<U> taxonomy2, Object object) {
            this.key = object;
            this.i = taxonomy2.getNodes().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Map.Entry<Set<U>, Object> next() {
            TaxonomyNode<U> taxonomyNode = this.i.next();
            return new SimpleImmutableEntry<Set<U>, Object>(Collections.unmodifiableSet(taxonomyNode.getEquivalents()), taxonomyNode.getDatum(this.key));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

