/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.incremental;

import aterm.ATermAppl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.DisjunctionBranch;
import org.mindswap.pellet.tableau.completion.incremental.BranchAddDependency;
import org.mindswap.pellet.tableau.completion.incremental.BranchDependency;
import org.mindswap.pellet.tableau.completion.incremental.ClashDependency;
import org.mindswap.pellet.tableau.completion.incremental.DependencyEntry;

public class DependencyIndex {
    public static final Logger log = Logger.getLogger(DependencyIndex.class.getName());
    private Map<ATermAppl, DependencyEntry> dependencies = new HashMap<ATermAppl, DependencyEntry>();
    private Map<Branch, Set<BranchDependency>> branchIndex = new HashMap<Branch, Set<BranchDependency>>();
    private Set<ClashDependency> clashIndex = new HashSet<ClashDependency>();
    private KnowledgeBase kb;

    public DependencyIndex(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    public DependencyIndex(KnowledgeBase knowledgeBase, DependencyIndex dependencyIndex) {
        this(knowledgeBase);
        for (ATermAppl aTermAppl : dependencyIndex.getDependencies().keySet()) {
            DependencyEntry dependencyEntry = dependencyIndex.getDependencies(aTermAppl).copy();
            this.dependencies.put(aTermAppl, dependencyEntry);
        }
    }

    public DependencyEntry getDependencies(ATermAppl aTermAppl) {
        return this.dependencies.get(aTermAppl);
    }

    protected Map<ATermAppl, DependencyEntry> getDependencies() {
        return this.dependencies;
    }

    public void addTypeDependency(ATermAppl aTermAppl, ATermAppl aTermAppl2, DependencySet dependencySet) {
        for (ATermAppl aTermAppl3 : dependencySet.getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(aTermAppl3)) continue;
            if (!this.dependencies.containsKey(aTermAppl3)) {
                this.dependencies.put(aTermAppl3, new DependencyEntry());
            }
            this.dependencies.get(aTermAppl3).addTypeDependency(aTermAppl, aTermAppl2);
        }
    }

    public void addMergeDependency(ATermAppl aTermAppl, ATermAppl aTermAppl2, DependencySet dependencySet) {
        for (ATermAppl aTermAppl3 : dependencySet.getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(aTermAppl3)) continue;
            if (!this.dependencies.containsKey(aTermAppl3)) {
                this.dependencies.put(aTermAppl3, new DependencyEntry());
            }
            this.dependencies.get(aTermAppl3).addMergeDependency(aTermAppl, aTermAppl2);
        }
    }

    public void addEdgeDependency(Edge edge, DependencySet dependencySet) {
        for (ATermAppl aTermAppl : dependencySet.getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(aTermAppl)) continue;
            if (!this.dependencies.containsKey(aTermAppl)) {
                this.dependencies.put(aTermAppl, new DependencyEntry());
            }
            this.dependencies.get(aTermAppl).addEdgeDependency(edge);
        }
    }

    public void addBranchAddDependency(Branch branch) {
        for (ATermAppl aTermAppl : branch.getTermDepends().getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(aTermAppl)) continue;
            if (!this.dependencies.containsKey(aTermAppl)) {
                this.dependencies.put(aTermAppl, new DependencyEntry());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DependencyIndex- Adding branch add dependency for assertion: " + aTermAppl + " -  Branch id [" + branch.getBranch() + "]   ,  Branch [" + branch + "]");
            }
            BranchDependency branchDependency = this.dependencies.get(aTermAppl).addBranchAddDependency(aTermAppl, branch.getBranch(), branch);
            if (!this.branchIndex.containsKey(branch)) {
                HashSet<BranchDependency> hashSet = new HashSet<BranchDependency>();
                hashSet.add(branchDependency);
                this.branchIndex.put(branch, hashSet);
                continue;
            }
            this.branchIndex.get(branch).add(branchDependency);
        }
    }

    public void addCloseBranchDependency(Branch branch, DependencySet dependencySet) {
        for (ATermAppl aTermAppl : dependencySet.getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(aTermAppl)) continue;
            if (!this.dependencies.containsKey(aTermAppl)) {
                this.dependencies.put(aTermAppl, new DependencyEntry());
            }
            ATermAppl aTermAppl2 = null;
            if (branch instanceof DisjunctionBranch) {
                aTermAppl2 = ((DisjunctionBranch)branch).getDisjunct(branch.getTryNext());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DependencyIndex- Adding branch remove ds dependency for assertion: " + aTermAppl + " -  Branch id [" + branch.getBranch() + "]   ,  Branch [" + branch + "]   on label [" + aTermAppl2 + "]  ,    tryNext [" + branch.getTryNext() + "]");
            }
            BranchDependency branchDependency = this.dependencies.get(aTermAppl).addCloseBranchDependency(aTermAppl, branch);
            if (!this.branchIndex.containsKey(branch)) {
                HashSet<BranchDependency> hashSet = new HashSet<BranchDependency>();
                hashSet.add(branchDependency);
                this.branchIndex.put(branch, hashSet);
                continue;
            }
            this.branchIndex.get(branch).add(branchDependency);
        }
    }

    public void removeDependencies(ATermAppl aTermAppl) {
        this.dependencies.remove(aTermAppl);
    }

    public void removeBranchDependencies(Branch branch) {
        Set<BranchDependency> set = this.branchIndex.get(branch);
        if (set == null) {
            return;
        }
        for (BranchDependency branchDependency : set) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("DependencyIndex: RESTORE causing remove of branch index for assertion: " + branchDependency.getAssertion() + " branch dep.: " + branchDependency);
            }
            if (!(branchDependency instanceof BranchAddDependency)) continue;
            this.dependencies.get(branchDependency.getAssertion()).getBranchAdds().remove(branchDependency);
        }
    }

    public void setClashDependencies(Clash clash) {
        for (ClashDependency clashDependency : this.clashIndex) {
            if (!this.dependencies.containsKey(clashDependency.getAssertion())) continue;
            this.dependencies.get(clashDependency.getAssertion()).setClash(null);
        }
        this.clashIndex.clear();
        if (clash == null) {
            return;
        }
        for (ATermAppl aTermAppl : clash.getDepends().getExplain()) {
            if (!this.kb.getSyntacticAssertions().contains(aTermAppl)) continue;
            if (!this.dependencies.containsKey(aTermAppl)) {
                this.dependencies.put(aTermAppl, new DependencyEntry());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("  DependencyIndex- Adding clash dependency: Axiom [" + aTermAppl + "]   ,  Clash [" + clash + "]");
            }
            ClashDependency clashDependency = new ClashDependency(aTermAppl, clash);
            this.dependencies.get(aTermAppl).setClash(clashDependency);
            this.clashIndex.add(clashDependency);
        }
    }
}

