/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

public class FSMBuilder {
    public static Logger log = Logger.getLogger(FSMBuilder.class.getName());
    private RBox rbox;

    public FSMBuilder(RBox rBox) {
        this.rbox = rBox;
    }

    public boolean build(Role role) {
        return this.build(role, new HashSet<Role>()) != null;
    }

    private TransitionGraph<Role> build(Role role, Set<Role> set) {
        if (!set.add(role)) {
            return null;
        }
        TransitionGraph<Role> transitionGraph = role.getFSM();
        if (transitionGraph == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Building NFA for " + role);
            }
            if ((transitionGraph = this.buildNondeterministicFSM(role, set)) == null) {
                log.warning("Cycle detected in the complex subproperty chain involving " + role);
                role.setForceSimple(true);
                this.rbox.ignoreTransitivity(role);
                return null;
            }
            assert (transitionGraph.isConnected());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Determinize " + role + ": " + transitionGraph.size() + "\n" + transitionGraph);
            }
            transitionGraph.determinize();
            assert (transitionGraph.isConnected());
            assert (transitionGraph.isDeterministic());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Minimize NFA for " + role + ": " + transitionGraph.size() + "\n" + transitionGraph);
            }
            transitionGraph.minimize();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Minimized NFA for " + role + ": " + transitionGraph.size() + "\n" + transitionGraph);
            }
            assert (transitionGraph.isConnected());
            transitionGraph.renumber();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Renumbered " + role + ": " + transitionGraph.size() + "\n" + transitionGraph);
            }
            assert (transitionGraph.isConnected());
            this.setFSM(role, transitionGraph);
            this.setFSM(role.getInverse(), this.mirror(transitionGraph).determinize().renumber());
        }
        set.remove(role);
        return transitionGraph;
    }

    private void setFSM(Role role, TransitionGraph<Role> transitionGraph) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("NFA for " + role + ":\n" + transitionGraph);
        }
        role.setFSM(transitionGraph);
        Set<Role> set = role.getEquivalentProperties();
        set.remove(role);
        for (Role role2 : set) {
            role2.setFSM(transitionGraph);
        }
    }

    private TransitionGraph<Role> buildNondeterministicFSM(Role role, Set<Role> set) {
        TransitionGraph<Role> transitionGraph = new TransitionGraph<Role>();
        State state = transitionGraph.newState();
        State state2 = transitionGraph.newState();
        transitionGraph.setInitialState(state);
        transitionGraph.addFinalState(state2);
        transitionGraph.addTransition(state, role, state2);
        if (role.isBuiltin()) {
            return transitionGraph;
        }
        for (Role object2 : role.getProperSubRoles()) {
            if (object2.isBottom() || object2.getInverse().isBottom()) continue;
            transitionGraph.addTransition(state, object2, state2);
        }
        for (ATermList aTermList : role.getSubRoleChains()) {
            if (this.addRoleChainTransition(transitionGraph, role, aTermList)) continue;
            return null;
        }
        HashSet<Role> hashSet = new HashSet<Role>(transitionGraph.getAlpahabet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Role role2 = (Role)iterator.next();
            for (Pair<State<Role>, State<Role>> pair : transitionGraph.findTransitions(role2)) {
                if (role.isEquivalent(role2)) {
                    if (transitionGraph.isInitial((State)pair.first) || transitionGraph.isFinal((State)pair.second) || transitionGraph.isFinal((State)pair.first) && transitionGraph.isInitial((State)pair.second)) continue;
                    return null;
                }
                TransitionGraph<Role> transitionGraph2 = this.build(role2, set);
                if (transitionGraph2 == null) {
                    return null;
                }
                transitionGraph.insert(transitionGraph2, (State)pair.first, (State)pair.second);
            }
        }
        return transitionGraph;
    }

    private boolean addRoleChainTransition(TransitionGraph<Role> transitionGraph, Role role, ATermList aTermList) {
        Role role2 = this.rbox.getRole(aTermList.getFirst());
        Role role3 = this.rbox.getRole(aTermList.getLast());
        boolean bl = role.isEquivalent(role2);
        boolean bl2 = role.isEquivalent(role3);
        int n = aTermList.getLength();
        if (bl) {
            if (bl2 && n != 2) {
                return false;
            }
            this.addRoleChainTransition(transitionGraph, transitionGraph.getFinalState(), transitionGraph.getFinalState(), aTermList.getNext(), n - 1);
        } else if (bl2) {
            this.addRoleChainTransition(transitionGraph, transitionGraph.getInitialState(), transitionGraph.getInitialState(), aTermList, n - 1);
        } else {
            this.addRoleChainTransition(transitionGraph, transitionGraph.getInitialState(), transitionGraph.getFinalState(), aTermList, n);
        }
        return true;
    }

    private void addRoleChainTransition(TransitionGraph<Role> transitionGraph, State<Role> state, State<Role> state2, ATermList aTermList, int n) {
        State<Role> state3 = state;
        int n2 = 0;
        while (n2 < n) {
            Role role = this.rbox.getRole(aTermList.getFirst());
            State<Role> state4 = n2 == n - 1 ? state2 : transitionGraph.newState();
            transitionGraph.addTransition(state3, role, state4);
            state3 = state4;
            ++n2;
            aTermList = aTermList.getNext();
        }
    }

    private TransitionGraph<Role> mirror(TransitionGraph<Role> transitionGraph) {
        HashMap<State<Role>, State<Role>> hashMap = new HashMap<State<Role>, State<Role>>();
        TransitionGraph<Role> transitionGraph2 = new TransitionGraph<Role>();
        State<Role> state = transitionGraph.getInitialState();
        State<Role> state2 = this.copyState(state, transitionGraph2, hashMap);
        transitionGraph2.addFinalState(state2);
        Set<State<Role>> set = transitionGraph.getFinalStates();
        State state3 = null;
        if (set.size() == 1) {
            State<Role> state4 = set.iterator().next();
            state3 = (State)hashMap.get(state4);
        } else {
            state3 = transitionGraph2.newState();
            for (State<Role> state5 : set) {
                transitionGraph2.addTransition(state3, (State)hashMap.get(state5));
            }
        }
        transitionGraph2.setInitialState(state3);
        return transitionGraph2;
    }

    private State<Role> copyState(State<Role> state, TransitionGraph<Role> transitionGraph, Map<State<Role>, State<Role>> map) {
        State<Role> state2 = map.get(state);
        if (state2 == null) {
            state2 = transitionGraph.newState();
            map.put(state, state2);
            for (Transition<Role> transition : state.getTransitions()) {
                State<Role> state3 = transition.getTo();
                State<Role> state4 = this.copyState(state3, transitionGraph, map);
                if (transition.isEpsilon()) {
                    transitionGraph.addTransition(state4, state2);
                    continue;
                }
                transitionGraph.addTransition(state4, transition.getName().getInverse(), state2);
            }
        }
        return state2;
    }
}

