/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DiscreteInterval;
import com.clarkparsia.pellet.datatypes.EmptyRestrictedDatatype;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class RestrictedRealDatatype
implements RestrictedDatatype<Number> {
    private static final Logger log = Logger.getLogger(RestrictedRealDatatype.class.getCanonicalName());
    private final Datatype<? extends Number> datatype;
    private final RestrictedDatatype<Number> empty;
    private final boolean enumerable;
    private final boolean finite;
    private final List<IntegerInterval> intIntervals;
    private final List<ContinuousRealInterval> decimalIntervals;
    private final List<ContinuousRealInterval> rationalIntervals;

    public RestrictedRealDatatype(Datatype<? extends Number> datatype, IntegerInterval integerInterval, ContinuousRealInterval continuousRealInterval, ContinuousRealInterval continuousRealInterval2) {
        this.datatype = datatype;
        this.empty = new EmptyRestrictedDatatype<Number>(datatype);
        this.intIntervals = integerInterval == null ? Collections.emptyList() : Collections.singletonList(integerInterval);
        this.decimalIntervals = continuousRealInterval == null ? Collections.emptyList() : Collections.singletonList(continuousRealInterval);
        this.rationalIntervals = continuousRealInterval2 == null ? Collections.emptyList() : Collections.singletonList(continuousRealInterval2);
        this.finite = !(integerInterval != null && !integerInterval.isFinite() || continuousRealInterval != null && !continuousRealInterval.isPoint() || continuousRealInterval2 != null && !continuousRealInterval2.isPoint());
        this.enumerable = this.finite || continuousRealInterval == null && continuousRealInterval2 == null;
    }

    private RestrictedRealDatatype(RestrictedRealDatatype restrictedRealDatatype, List<IntegerInterval> list, List<ContinuousRealInterval> list2, List<ContinuousRealInterval> list3) {
        boolean bl;
        this.datatype = restrictedRealDatatype.datatype;
        this.empty = restrictedRealDatatype.empty;
        this.intIntervals = list;
        this.decimalIntervals = list2;
        this.rationalIntervals = list3;
        if (restrictedRealDatatype.enumerable) {
            this.enumerable = true;
        } else {
            bl = true;
            block0: for (List list4 : new List[]{list2, list3}) {
                if (!bl) continue;
                Iterator iterator = list4.iterator();
                while (iterator.hasNext()) {
                    ContinuousRealInterval continuousRealInterval = (ContinuousRealInterval)iterator.next();
                    if (continuousRealInterval.isPoint()) continue;
                    bl = false;
                    continue block0;
                }
            }
            this.enumerable = bl;
        }
        if (restrictedRealDatatype.finite) {
            this.finite = true;
        } else if (this.enumerable) {
            bl = true;
            for (IntegerInterval integerInterval : list) {
                if (integerInterval.isFinite()) continue;
                bl = false;
                break;
            }
            this.finite = bl;
        } else {
            this.finite = false;
        }
    }

    @Override
    public RestrictedDatatype<Number> applyConstrainingFacet(ATermAppl aTermAppl, Object object) {
        boolean bl;
        Number number;
        boolean bl2;
        Number number2;
        Facet facet = Facet.Registry.get(aTermAppl);
        if (facet == null) {
            String string = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), aTermAppl, object);
            log.severe(string);
            throw new IllegalArgumentException(string);
        }
        Number number3 = null;
        if (object instanceof Number && !OWLRealUtils.acceptable((number3 = (Number)object).getClass())) {
            number3 = null;
        }
        if (number3 == null) {
            String string = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), facet, object);
            log.severe(string);
            throw new IllegalArgumentException(string);
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(facet)) {
            number2 = null;
            bl2 = false;
            number = number3;
            bl = false;
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(facet)) {
            number2 = null;
            bl2 = false;
            number = number3;
            bl = true;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(facet)) {
            number2 = number3;
            bl2 = false;
            number = null;
            bl = false;
        } else if (Facet.XSD.MIN_INCLUSIVE.equals(facet)) {
            number2 = number3;
            bl2 = true;
            number = null;
            bl = false;
        } else {
            throw new IllegalStateException();
        }
        ContinuousRealInterval continuousRealInterval = new ContinuousRealInterval(number2, number, bl2, bl);
        IntegerInterval integerInterval = RestrictedRealDatatype.asIntegerInterval(continuousRealInterval);
        boolean bl3 = false;
        ArrayList<IntegerInterval> arrayList = new ArrayList<IntegerInterval>();
        for (IntegerInterval object22 : this.intIntervals) {
            IntegerInterval integerInterval2 = object22.intersection(integerInterval);
            if (integerInterval2 != null) {
                arrayList.add(integerInterval2);
                if (object22.equals(integerInterval2)) continue;
                bl3 = true;
                continue;
            }
            bl3 = true;
        }
        ArrayList arrayList2 = new ArrayList();
        for (ContinuousRealInterval continuousRealInterval2 : this.decimalIntervals) {
            ContinuousRealInterval continuousRealInterval3 = continuousRealInterval2.intersection(continuousRealInterval);
            if (continuousRealInterval3 != null) {
                arrayList2.add(continuousRealInterval3);
                if (continuousRealInterval2.equals(continuousRealInterval3)) continue;
                bl3 = true;
                continue;
            }
            bl3 = true;
        }
        ArrayList<ContinuousRealInterval> arrayList3 = new ArrayList<ContinuousRealInterval>();
        for (ContinuousRealInterval continuousRealInterval3 : this.rationalIntervals) {
            ContinuousRealInterval continuousRealInterval4 = continuousRealInterval3.intersection(continuousRealInterval);
            if (continuousRealInterval4 != null) {
                arrayList3.add(continuousRealInterval4);
                if (continuousRealInterval3.equals(continuousRealInterval4)) continue;
                bl3 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl3) {
            if (arrayList.isEmpty() && arrayList2.isEmpty() && arrayList3.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, arrayList, arrayList2, arrayList3);
        }
        return this;
    }

    private static IntegerInterval asIntegerInterval(ContinuousRealInterval continuousRealInterval) {
        Number number;
        Number number2 = continuousRealInterval.boundLower() ? (Number)(OWLRealUtils.isInteger(number = continuousRealInterval.getLower()) ? (Number)(continuousRealInterval.inclusiveLower() ? (Number)number : (Number)OWLRealUtils.integerIncrement(number)) : (Number)OWLRealUtils.roundCeiling(number)) : (Number)null;
        Number number3 = continuousRealInterval.boundUpper() ? (Number)(OWLRealUtils.isInteger(number = continuousRealInterval.getUpper()) ? (Number)(continuousRealInterval.inclusiveUpper() ? (Number)number : (Number)OWLRealUtils.integerDecrement(number)) : (Number)OWLRealUtils.roundFloor(number)) : (Number)null;
        if (number2 != null && number3 != null && OWLRealUtils.compare(number2, number3) > 0) {
            return null;
        }
        return new IntegerInterval(number2, number3);
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (OWLRealUtils.acceptable(number.getClass())) {
                if (OWLRealUtils.isInteger(number)) {
                    for (IntegerInterval integerInterval : this.intIntervals) {
                        if (!integerInterval.contains(number)) continue;
                        return true;
                    }
                } else if (OWLRealUtils.isDecimal(number)) {
                    for (ContinuousRealInterval continuousRealInterval : this.decimalIntervals) {
                        if (!continuousRealInterval.contains(number)) continue;
                        return true;
                    }
                } else if (OWLRealUtils.isRational(number)) {
                    for (ContinuousRealInterval continuousRealInterval : this.rationalIntervals) {
                        if (!continuousRealInterval.contains(number)) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (!this.finite || n <= 0) {
            return true;
        }
        Number number = 0;
        for (IntegerInterval object : this.intIntervals) {
            number = OWLRealUtils.integerSum(number, object.size());
            if (OWLRealUtils.compare(n, number) > 0) continue;
            return true;
        }
        for (ContinuousRealInterval continuousRealInterval : this.decimalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower())) continue;
            number = OWLRealUtils.integerIncrement(number);
            if (OWLRealUtils.compare(n, number) > 0) continue;
            return true;
        }
        for (ContinuousRealInterval continuousRealInterval : this.rationalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower()) || OWLRealUtils.isRational(continuousRealInterval.getLower())) continue;
            number = OWLRealUtils.integerIncrement(number);
            if (OWLRealUtils.compare(n, number) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<Number> exclude(Collection<?> collection) {
        boolean bl = false;
        ArrayList<IntegerInterval> arrayList = new ArrayList<IntegerInterval>(this.intIntervals);
        ArrayList<ContinuousRealInterval> arrayList2 = new ArrayList<ContinuousRealInterval>(this.decimalIntervals);
        ArrayList<ContinuousRealInterval> arrayList3 = new ArrayList<ContinuousRealInterval>(this.rationalIntervals);
        block0: for (Object obj : collection) {
            Object object;
            Object object2;
            Object object3;
            ArrayList<ContinuousRealInterval> arrayList4;
            Number number;
            if (!(obj instanceof Number) || !OWLRealUtils.acceptable((number = (Number)obj).getClass())) continue;
            if (OWLRealUtils.isInteger(number)) {
                arrayList4 = arrayList.iterator();
                while (arrayList4.hasNext()) {
                    object3 = (IntegerInterval)arrayList4.next();
                    if (!((DiscreteInterval)object3).contains(number)) continue;
                    bl = true;
                    arrayList4.remove();
                    object2 = (IntegerInterval)((DiscreteInterval)object3).less(number);
                    if (object2 != null) {
                        arrayList.add((IntegerInterval)object2);
                    }
                    if ((object = (IntegerInterval)((DiscreteInterval)object3).greater(number)) == null) continue block0;
                    arrayList.add((IntegerInterval)object);
                    continue block0;
                }
                continue;
            }
            if (OWLRealUtils.isDecimal(number)) {
                arrayList4 = arrayList2;
            } else if (OWLRealUtils.isRational(number)) {
                arrayList4 = arrayList3;
            } else {
                throw new IllegalStateException();
            }
            object3 = arrayList4.iterator();
            while (object3.hasNext()) {
                ContinuousRealInterval continuousRealInterval;
                object2 = (ContinuousRealInterval)object3.next();
                if (!((ContinuousRealInterval)object2).contains(number)) continue;
                bl = true;
                object3.remove();
                object = ((ContinuousRealInterval)object2).less(number);
                if (object != null) {
                    arrayList4.add((ContinuousRealInterval)object);
                }
                if ((continuousRealInterval = ((ContinuousRealInterval)object2).greater(number)) == null) continue block0;
                arrayList4.add(continuousRealInterval);
                continue block0;
            }
        }
        if (bl) {
            if (arrayList.isEmpty() && arrayList2.isEmpty() && arrayList3.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, arrayList, arrayList2, arrayList3);
        }
        return this;
    }

    @Override
    public Datatype<? extends Number> getDatatype() {
        return this.datatype;
    }

    @Override
    public Number getValue(int n) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RestrictedDatatype<Number> intersect(RestrictedDatatype<?> restrictedDatatype, boolean bl) {
        if (restrictedDatatype instanceof RestrictedRealDatatype) {
            List<ContinuousRealInterval> object2;
            Object object3;
            List<IntegerInterval> object6;
            RestrictedRealDatatype restrictedRealDatatype = (RestrictedRealDatatype)restrictedDatatype;
            ArrayList<IntegerInterval> arrayList = new ArrayList<IntegerInterval>();
            ArrayList<ContinuousRealInterval> arrayList2 = new ArrayList<ContinuousRealInterval>();
            ArrayList<ContinuousRealInterval> arrayList3 = new ArrayList<ContinuousRealInterval>();
            if (bl) {
                object6 = Collections.singletonList(IntegerInterval.allIntegers());
                for (IntegerInterval object52 : restrictedRealDatatype.intIntervals) {
                    ArrayList<IntegerInterval> arrayList4 = new ArrayList<IntegerInterval>(2 * object6.size());
                    for (Object object3 : object6) {
                        arrayList4.addAll(((DiscreteInterval)object3).remove(object52));
                    }
                    object6 = arrayList4;
                }
            } else {
                object6 = restrictedRealDatatype.intIntervals;
            }
            for (IntegerInterval integerInterval : this.intIntervals) {
                for (IntegerInterval integerInterval2 : object6) {
                    object3 = integerInterval.intersection(integerInterval2);
                    if (object3 == null) continue;
                    arrayList.add((IntegerInterval)object3);
                }
            }
            if (bl) {
                object2 = Collections.singletonList(ContinuousRealInterval.allReals());
                for (ContinuousRealInterval continuousRealInterval : restrictedRealDatatype.decimalIntervals) {
                    ArrayList<ContinuousRealInterval> arrayList5 = new ArrayList<ContinuousRealInterval>(2 * object2.size());
                    for (Object object4 : object2) {
                        arrayList5.addAll(((ContinuousRealInterval)object4).remove(continuousRealInterval));
                    }
                    object2 = arrayList5;
                }
            } else {
                object2 = restrictedRealDatatype.decimalIntervals;
            }
            for (ContinuousRealInterval continuousRealInterval : this.decimalIntervals) {
                for (Object object3 : object2) {
                    Object object4;
                    object4 = continuousRealInterval.intersection((ContinuousRealInterval)object3);
                    if (object4 == null) continue;
                    arrayList2.add((ContinuousRealInterval)object4);
                }
            }
            if (bl) {
                List<ContinuousRealInterval> list = Collections.singletonList(ContinuousRealInterval.allReals());
                for (ContinuousRealInterval continuousRealInterval : restrictedRealDatatype.rationalIntervals) {
                    void var9_16;
                    object3 = new ArrayList(2 * var9_16.size());
                    for (ContinuousRealInterval continuousRealInterval2 : var9_16) {
                        object3.addAll(continuousRealInterval2.remove(continuousRealInterval));
                    }
                    Object object5 = object3;
                }
            } else {
                List<ContinuousRealInterval> list = restrictedRealDatatype.rationalIntervals;
            }
            for (ContinuousRealInterval continuousRealInterval : this.rationalIntervals) {
                void var9_19;
                for (Object object4 : var9_19) {
                    ContinuousRealInterval continuousRealInterval2;
                    continuousRealInterval2 = continuousRealInterval.intersection((ContinuousRealInterval)object4);
                    if (continuousRealInterval2 == null) continue;
                    arrayList3.add(continuousRealInterval2);
                }
            }
            if (arrayList.equals(this.intIntervals) && arrayList2.equals(this.decimalIntervals) && arrayList3.equals(this.rationalIntervals)) {
                return this;
            }
            if (arrayList.isEmpty() && arrayList2.isEmpty() && arrayList3.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, arrayList, arrayList2, arrayList3);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return this.enumerable;
    }

    @Override
    public boolean isFinite() {
        return this.finite;
    }

    @Override
    public int size() {
        if (!this.finite) {
            throw new IllegalStateException();
        }
        Number number = 0;
        for (IntegerInterval object : this.intIntervals) {
            number = OWLRealUtils.integerSum(number, object.size());
            if (OWLRealUtils.compare(Integer.MAX_VALUE, number) > 0) continue;
            return Integer.MAX_VALUE;
        }
        for (ContinuousRealInterval continuousRealInterval : this.decimalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower())) continue;
            number = OWLRealUtils.integerIncrement(number);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, number) > 0) continue;
            return Integer.MAX_VALUE;
        }
        for (ContinuousRealInterval continuousRealInterval : this.rationalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower()) || OWLRealUtils.isRational(continuousRealInterval.getLower())) continue;
            number = OWLRealUtils.integerIncrement(number);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, number) > 0) continue;
            return Integer.MAX_VALUE;
        }
        return number.intValue();
    }

    @Override
    public RestrictedDatatype<Number> union(RestrictedDatatype<?> restrictedDatatype) {
        if (restrictedDatatype instanceof RestrictedRealDatatype) {
            Object object;
            HashSet<IntegerInterval> hashSet;
            ArrayList arrayList;
            RestrictedRealDatatype restrictedRealDatatype = (RestrictedRealDatatype)restrictedDatatype;
            ArrayList<IntegerInterval> arrayList2 = new ArrayList<IntegerInterval>(this.intIntervals);
            ArrayList<ContinuousRealInterval> arrayList3 = new ArrayList<ContinuousRealInterval>(this.decimalIntervals);
            ArrayList<ContinuousRealInterval> arrayList4 = new ArrayList<ContinuousRealInterval>(this.rationalIntervals);
            for (IntegerInterval object2 : restrictedRealDatatype.intIntervals) {
                arrayList = new ArrayList();
                hashSet = arrayList2.iterator();
                while (hashSet.hasNext()) {
                    object = (IntegerInterval)hashSet.next();
                    if (!object2.canUnionWith(object)) continue;
                    hashSet.remove();
                    arrayList.add(object);
                }
                if (arrayList.isEmpty()) {
                    arrayList2.add(object2);
                    continue;
                }
                hashSet = new HashSet();
                for (IntegerInterval integerInterval : arrayList) {
                    hashSet.addAll(object2.union(integerInterval));
                }
                arrayList2.addAll((Collection<IntegerInterval>)hashSet);
            }
            for (ContinuousRealInterval continuousRealInterval : restrictedRealDatatype.decimalIntervals) {
                arrayList = new ArrayList();
                hashSet = arrayList3.iterator();
                while (hashSet.hasNext()) {
                    object = (ContinuousRealInterval)hashSet.next();
                    if (!continuousRealInterval.canUnionWith((ContinuousRealInterval)object)) continue;
                    hashSet.remove();
                    arrayList.add(object);
                }
                if (arrayList.isEmpty()) {
                    arrayList3.add(continuousRealInterval);
                    continue;
                }
                hashSet = new HashSet();
                for (ContinuousRealInterval continuousRealInterval2 : arrayList) {
                    hashSet.addAll(continuousRealInterval.union(continuousRealInterval2));
                }
                arrayList3.addAll(hashSet);
            }
            for (ContinuousRealInterval continuousRealInterval : restrictedRealDatatype.rationalIntervals) {
                arrayList = new ArrayList();
                hashSet = arrayList4.iterator();
                while (hashSet.hasNext()) {
                    object = (ContinuousRealInterval)hashSet.next();
                    if (!continuousRealInterval.canUnionWith((ContinuousRealInterval)object)) continue;
                    hashSet.remove();
                    arrayList.add(object);
                }
                if (arrayList.isEmpty()) {
                    arrayList4.add(continuousRealInterval);
                    continue;
                }
                hashSet = new HashSet<IntegerInterval>();
                for (ContinuousRealInterval continuousRealInterval3 : arrayList) {
                    hashSet.addAll(continuousRealInterval.union(continuousRealInterval3));
                }
                arrayList4.addAll(hashSet);
            }
            if (arrayList2.equals(this.intIntervals) && arrayList3.equals(this.decimalIntervals) && arrayList4.equals(this.rationalIntervals)) {
                return this;
            }
            return new RestrictedRealDatatype(this, arrayList2, arrayList3, arrayList4);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Number> valueIterator() {
        if (!this.enumerable) {
            throw new IllegalStateException();
        }
        return new Iterator<Number>(){
            final Iterator<IntegerInterval> intit;
            final Iterator<ContinuousRealInterval> decit;
            final Iterator<ContinuousRealInterval> ratit;
            private Iterator<Number> nit;
            private boolean intOk;
            private boolean decOk;
            private Number next;
            {
                this.intit = RestrictedRealDatatype.this.intIntervals.iterator();
                this.decit = RestrictedRealDatatype.this.decimalIntervals.iterator();
                this.ratit = RestrictedRealDatatype.this.rationalIntervals.iterator();
                this.nit = null;
                this.intOk = true;
                this.decOk = true;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.nit != null && this.nit.hasNext()) {
                        this.next = this.nit.next();
                        if (!this.intOk && OWLRealUtils.isInteger(this.next)) {
                            this.next = null;
                        }
                        if (this.decOk || !OWLRealUtils.isDecimal(this.next)) continue;
                        this.next = null;
                        continue;
                    }
                    if (this.intit.hasNext()) {
                        this.nit = this.intit.next().valueIterator();
                        continue;
                    }
                    this.intOk = false;
                    if (this.decit.hasNext()) {
                        this.nit = this.decit.next().valueIterator();
                        continue;
                    }
                    this.decOk = false;
                    if (this.ratit.hasNext()) {
                        this.nit = this.ratit.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Number next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Number number = this.next;
                this.next = null;
                return number;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return String.format("{%s,%s,%s,%s}", this.datatype, this.intIntervals, this.decimalIntervals, this.rationalIntervals);
    }
}

