/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.mindswap.pellet.utils.ATermUtils;

public class InfiniteNamedDatatype
implements Datatype<ATermAppl> {
    private static final Map<ATermAppl, WeakReference<InfiniteNamedDatatype>> cache = new WeakHashMap<ATermAppl, WeakReference<InfiniteNamedDatatype>>();
    private final ATermAppl name;
    private final RestrictedDatatype<ATermAppl> range;

    public static InfiniteNamedDatatype get(ATermAppl aTermAppl) {
        InfiniteNamedDatatype infiniteNamedDatatype;
        WeakReference<InfiniteNamedDatatype> weakReference = cache.get(aTermAppl);
        InfiniteNamedDatatype infiniteNamedDatatype2 = infiniteNamedDatatype = weakReference == null ? null : (InfiniteNamedDatatype)weakReference.get();
        if (infiniteNamedDatatype == null) {
            infiniteNamedDatatype = new InfiniteNamedDatatype(aTermAppl);
            cache.put(aTermAppl, new WeakReference<InfiniteNamedDatatype>(infiniteNamedDatatype));
        }
        return infiniteNamedDatatype;
    }

    private InfiniteNamedDatatype(ATermAppl aTermAppl) {
        if (aTermAppl == null) {
            throw new NullPointerException();
        }
        if (aTermAppl.getArity() != 0) {
            throw new IllegalArgumentException();
        }
        this.name = aTermAppl;
        this.range = new RestrictedDatatype<ATermAppl>(){

            @Override
            public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl aTermAppl, Object object) throws InvalidConstrainingFacetException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(Object object) {
                ATermAppl aTermAppl;
                if (object instanceof ATermAppl && ATermUtils.isLiteral(aTermAppl = (ATermAppl)object)) {
                    ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
                    return InfiniteNamedDatatype.this.name.equals(aTermAppl2);
                }
                return false;
            }

            @Override
            public boolean containsAtLeast(int n) {
                return true;
            }

            @Override
            public RestrictedDatatype<ATermAppl> exclude(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Datatype<? extends ATermAppl> getDatatype() {
                return InfiniteNamedDatatype.this;
            }

            @Override
            public ATermAppl getValue(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> restrictedDatatype, boolean bl) {
                if (restrictedDatatype == this) {
                    return this;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean isEnumerable() {
                return false;
            }

            @Override
            public boolean isFinite() {
                return false;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> restrictedDatatype) {
                if (restrictedDatatype == this) {
                    return this;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public Iterator<ATermAppl> valueIterator() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.range;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InfiniteNamedDatatype infiniteNamedDatatype = (InfiniteNamedDatatype)object;
        return !(this.name == null ? infiniteNamedDatatype.name != null : !this.name.equals(infiniteNamedDatatype.name));
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!this.name.equals(aTermAppl.getArgument(2))) {
            throw new IllegalArgumentException();
        }
        return aTermAppl;
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        ATermAppl aTermAppl;
        if (object instanceof ATermAppl && ATermUtils.isLiteral(aTermAppl = (ATermAppl)object) && this.name.equals(aTermAppl.getArgument(2))) {
            return aTermAppl;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public ATermAppl getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!this.name.equals(aTermAppl.getArgument(2))) {
            throw new IllegalArgumentException();
        }
        return aTermAppl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.name.getName();
    }
}

