/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import pellet.PelletCmdException;

public class PelletExceptionFormatter {
    private boolean verbose = false;

    public String formatException(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        if (!this.verbose) {
            if (throwable2 instanceof FileNotFoundException) {
                return this.format((FileNotFoundException)throwable2);
            }
            if (throwable2 instanceof PelletCmdException) {
                return this.format((PelletCmdException)throwable2);
            }
            return this.formatGeneric(throwable2);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable2.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    private String format(FileNotFoundException fileNotFoundException) {
        return "ERROR: Cannot open " + fileNotFoundException.getMessage();
    }

    private String format(PelletCmdException pelletCmdException) {
        return "ERROR: " + pelletCmdException.getMessage();
    }

    private String formatGeneric(Throwable throwable) {
        int n;
        String string = throwable.getMessage();
        if (string != null && (n = string.indexOf(10, 0)) != -1) {
            string = string.substring(0, n);
        }
        return string + "\nUse -v for detail.";
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }
}

