/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.util.OWLUtil;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class GCIPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new SimpleLintFormat();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return "GCI axiom, or equivalence classes axiom with two or more complex concepts";
    }

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        int n = 0;
        for (OWLClassExpression oWLClassExpression : oWLEquivalentClassesAxiom.getClassExpressions()) {
            if (!OWLUtil.isComplex(oWLClassExpression)) continue;
            ++n;
        }
        if (n > 1) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom((OWLClassAxiom)oWLEquivalentClassesAxiom);
            this.setLint(lint);
        }
    }

    public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        if (OWLUtil.isComplex(oWLSubClassOfAxiom.getSubClass())) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom((OWLClassAxiom)oWLSubClassOfAxiom);
            this.setLint(lint);
        }
    }
}

