/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.uri;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.uri.RestrictedURIDatatype;
import java.net.URI;
import java.net.URISyntaxException;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDAnyURI
extends AbstractBaseDatatype<ATermAppl> {
    private static final XSDAnyURI instance;
    static final ATermAppl NAME;
    private final RestrictedDatatype<ATermAppl> dataRange = new RestrictedURIDatatype(this);

    public static XSDAnyURI getInstance() {
        return instance;
    }

    private XSDAnyURI() {
        super(NAME);
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        return this.getValue(aTermAppl);
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public ATermAppl getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl).trim();
        try {
            return ATermUtils.makeTypedLiteral(new URI(string).normalize().toString(), NAME);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidLiteralException(NAME, string);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        NAME = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#anyURI");
        instance = new XSDAnyURI();
    }
}

