/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import org.mindswap.pellet.utils.ATermUtils;

class NamedDatatype<T>
implements Datatype<T> {
    private final ATermAppl name;
    private final RestrictedDatatype<T> range;

    NamedDatatype(ATermAppl aTermAppl, RestrictedDatatype<T> restrictedDatatype) {
        if (aTermAppl == null) {
            throw new NullPointerException();
        }
        if (aTermAppl.getArity() != 0) {
            throw new IllegalArgumentException();
        }
        this.name = aTermAppl;
        this.range = restrictedDatatype;
    }

    @Override
    public RestrictedDatatype<T> asDataRange() {
        return this.range;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NamedDatatype namedDatatype = (NamedDatatype)object;
        return !(this.name == null ? namedDatatype.name != null : !this.name.equals(namedDatatype.name));
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        return this.range.getDatatype().getCanonicalRepresentation(aTermAppl);
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        ATermAppl aTermAppl;
        if (object instanceof ATermAppl && ATermUtils.isLiteral(aTermAppl = (ATermAppl)object) && this.name.equals(aTermAppl.getArgument(2))) {
            return aTermAppl;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this.range.getDatatype().getPrimitiveDatatype();
    }

    @Override
    public T getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        T t = this.range.getDatatype().getValue(aTermAppl);
        if (!this.range.contains(t)) {
            throw new InvalidLiteralException(this.name, aTermAppl.getArgument(0).toString());
        }
        return t;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return this.name.getName();
    }
}

