/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.HashMap;
import java.util.Map;

public class ReasonerRegistry {
    protected static ReasonerRegistry theRegistry;
    protected Map<String, ReasonerFactory> reasonerFactories = new HashMap<String, ReasonerFactory>();
    protected Model allDescriptions = ModelFactory.createDefaultModel();
    protected static Reasoner theRDFSReasoner;
    protected static Reasoner theRDFSSimpleReasoner;
    protected static Reasoner theTRANSITIVEReasoner;
    protected static Reasoner theOWLReasoner;
    protected static Reasoner theOWLMicroReasoner;
    protected static Reasoner theOWLMiniReasoner;

    private ReasonerRegistry() {
        this.register(TransitiveReasonerFactory.theInstance());
        this.register(RDFSRuleReasonerFactory.theInstance());
        this.register(OWLFBRuleReasonerFactory.theInstance());
        this.register(GenericRuleReasonerFactory.theInstance());
        this.register(OWLMicroReasonerFactory.theInstance());
        this.register(OWLMiniReasonerFactory.theInstance());
    }

    public static ReasonerRegistry theRegistry() {
        if (theRegistry == null) {
            theRegistry = new ReasonerRegistry();
        }
        return theRegistry;
    }

    public void register(ReasonerFactory factory) {
        this.reasonerFactories.put(factory.getURI(), factory);
        Model description = factory.getCapabilities();
        if (description != null) {
            this.allDescriptions.add(description);
        }
        this.allDescriptions.createResource(factory.getURI()).addProperty(RDF.type, ReasonerVocabulary.ReasonerClass);
    }

    public void register(String reasonerUri, ReasonerFactory factory) {
        this.reasonerFactories.put(reasonerUri, factory);
        this.allDescriptions.createResource(reasonerUri).addProperty(RDF.type, ReasonerVocabulary.ReasonerClass);
    }

    public Model getAllDescriptions() {
        return this.allDescriptions;
    }

    public Resource getDescription(String uri) {
        Resource reasonerURI = this.allDescriptions.getResource(uri);
        if (this.allDescriptions.contains(reasonerURI, RDF.type, ReasonerVocabulary.ReasonerClass)) {
            return reasonerURI;
        }
        return null;
    }

    public ReasonerFactory getFactory(String uri) {
        return this.reasonerFactories.get(uri);
    }

    public Reasoner create(String uri, Resource configuration) throws ReasonerException {
        ReasonerFactory factory = this.getFactory(uri);
        if (factory != null) {
            return factory.create(configuration);
        }
        throw new ReasonerException("Attempted to instantiate an unknown reasoner: " + uri);
    }

    public static Node makeDirect(Node node) {
        return Node.createURI(ReasonerRegistry.makeDirect(node.getURI()));
    }

    public static String makeDirect(String uri) {
        return "urn:x-hp-direct-predicate:" + uri.replace(':', '_');
    }

    public static Reasoner getRDFSReasoner() {
        if (theRDFSReasoner == null) {
            theRDFSReasoner = RDFSRuleReasonerFactory.theInstance().create(null);
        }
        return theRDFSReasoner;
    }

    public static Reasoner getRDFSSimpleReasoner() {
        if (theRDFSSimpleReasoner == null) {
            theRDFSSimpleReasoner = RDFSRuleReasonerFactory.theInstance().create(null);
            theRDFSSimpleReasoner.setParameter(ReasonerVocabulary.PROPsetRDFSLevel, "simple");
        }
        return theRDFSSimpleReasoner;
    }

    public static Reasoner getTransitiveReasoner() {
        if (theTRANSITIVEReasoner == null) {
            theTRANSITIVEReasoner = TransitiveReasonerFactory.theInstance().create(null);
        }
        return theTRANSITIVEReasoner;
    }

    public static Reasoner getOWLReasoner() {
        if (theOWLReasoner == null) {
            theOWLReasoner = OWLFBRuleReasonerFactory.theInstance().create(null);
        }
        return theOWLReasoner;
    }

    public static Reasoner getOWLMicroReasoner() {
        if (theOWLMicroReasoner == null) {
            theOWLMicroReasoner = OWLMicroReasonerFactory.theInstance().create(null);
        }
        return theOWLMicroReasoner;
    }

    public static Reasoner getOWLMiniReasoner() {
        if (theOWLMiniReasoner == null) {
            theOWLMiniReasoner = OWLMiniReasonerFactory.theInstance().create(null);
        }
        return theOWLMiniReasoner;
    }

    static {
        theRDFSReasoner = null;
        theRDFSSimpleReasoner = null;
    }
}

