/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class AbstractDerivedIntegerType
extends AbstractBaseDatatype<Number> {
    private static final XSDDecimal XSD_DECIMAL = XSDDecimal.getInstance();
    private final RestrictedDatatype<Number> dataRange;

    public AbstractDerivedIntegerType(ATermAppl aTermAppl, Number number, Number number2) {
        super(aTermAppl);
        if (number != null && !OWLRealUtils.isInteger(number)) {
            throw new IllegalArgumentException();
        }
        if (number2 != null && !OWLRealUtils.isInteger(number2)) {
            throw new IllegalArgumentException();
        }
        if (number != null && number2 != null && OWLRealUtils.compare(number, number2) > 0) {
            throw new IllegalArgumentException();
        }
        IntegerInterval integerInterval = new IntegerInterval(number == null ? (Number)null : (Number)OWLRealUtils.getCanonicalObject(number), number2 == null ? (Number)null : (Number)OWLRealUtils.getCanonicalObject(number2));
        this.dataRange = new RestrictedRealDatatype(this, integerInterval, null, null);
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    protected abstract Number fromLexicalForm(String var1) throws InvalidLiteralException;

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        this.fromLexicalForm(string);
        return XSD_DECIMAL.getCanonicalRepresentation(ATermUtils.makeTypedLiteral(string, XSD_DECIMAL.getName()));
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDecimal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        return OWLRealUtils.getCanonicalObject(this.fromLexicalForm(string));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

