/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io.manchester;

import com.clarkparsia.owlapi.explanation.io.manchester.BlockWriter;
import com.clarkparsia.owlapi.explanation.io.manchester.DescriptionSorter;
import com.clarkparsia.owlapi.explanation.io.manchester.Keyword;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class ManchesterSyntaxObjectRenderer
implements OWLObjectVisitor {
    private boolean wrapLines = true;
    private boolean smartIndent = true;
    protected BlockWriter writer;

    public ManchesterSyntaxObjectRenderer(BlockWriter blockWriter) {
        this.writer = blockWriter;
    }

    public boolean isSmartIndent() {
        return this.smartIndent;
    }

    public boolean isWrapLines() {
        return this.wrapLines;
    }

    public void setSmartIndent(boolean bl) {
        this.smartIndent = bl;
    }

    public void setWrapLines(boolean bl) {
        this.wrapLines = bl;
    }

    protected String shortForm(IRI iRI) {
        String string = iRI.getFragment();
        if (string != null) {
            return string;
        }
        String string2 = iRI.toString();
        int n = string2.lastIndexOf(47);
        if (n != -1) {
            return string2.substring(n + 1, string2.length());
        }
        return string2;
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)oWLAsymmetricObjectPropertyAxiom, Keyword.ASYMMETRIC_PROPERTY);
    }

    public void visit(OWLClass oWLClass) {
        this.write(oWLClass.getIRI());
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        this.writeKeywordInfix(Keyword.TYPE, (OWLObject)oWLClassAssertionAxiom.getIndividual(), (OWLObject)oWLClassAssertionAxiom.getClassExpression());
    }

    public void visit(OWLAnnotation oWLAnnotation) {
        this.write(Keyword.ANNOTATION);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)oWLAnnotation.getProperty());
        this.write(" ");
        this.write((OWLObject)oWLAnnotation.getValue());
        this.write(")");
    }

    public void visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?, ?>)oWLDataAllValuesFrom, Keyword.ONLY);
    }

    public void visit(OWLDataComplementOf oWLDataComplementOf) {
        this.writeKeywordPrefix(Keyword.NOT, (OWLObject)oWLDataComplementOf.getDataRange());
    }

    public void visit(OWLDataExactCardinality oWLDataExactCardinality) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)oWLDataExactCardinality, Keyword.EXACTLY);
    }

    public void visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)oWLDataMaxCardinality, Keyword.MAX);
    }

    public void visit(OWLDataMinCardinality oWLDataMinCardinality) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)oWLDataMinCardinality, Keyword.MIN);
    }

    public void visit(OWLDataOneOf oWLDataOneOf) {
        this.writeEnumeration(oWLDataOneOf.getValues());
    }

    public void visit(OWLDataProperty oWLDataProperty) {
        this.write(oWLDataProperty.getIRI());
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        this.write((OWLObject)oWLDataPropertyAssertionAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)oWLDataPropertyAssertionAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)oWLDataPropertyAssertionAxiom.getObject());
    }

    public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, (OWLObject)oWLDataPropertyDomainAxiom.getProperty(), (OWLObject)oWLDataPropertyDomainAxiom.getDomain());
    }

    public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, (OWLObject)oWLDataPropertyRangeAxiom.getProperty(), (OWLObject)oWLDataPropertyRangeAxiom.getRange());
    }

    public void visit(OWLFacetRestriction oWLFacetRestriction) {
        this.write(oWLFacetRestriction.getFacet().getSymbolicForm());
        this.writeSpace();
        this.write((OWLObject)oWLFacetRestriction.getFacetValue());
    }

    public void visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
        this.write((OWLObject)oWLDatatypeRestriction.getDatatype());
        this.write("[");
        boolean bl = true;
        for (OWLFacetRestriction oWLFacetRestriction : oWLDatatypeRestriction.getFacetRestrictions()) {
            if (bl) {
                bl = false;
            } else {
                this.write(",");
                this.writeSpace();
            }
            this.write((OWLObject)oWLFacetRestriction);
        }
        this.write("]");
    }

    public void visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?, ?>)oWLDataSomeValuesFrom, Keyword.SOME);
    }

    public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)oWLSubDataPropertyOfAxiom.getSubProperty(), (OWLObject)oWLSubDataPropertyOfAxiom.getSuperProperty());
    }

    public void visit(OWLDatatype oWLDatatype) {
        this.write(oWLDatatype.getIRI());
    }

    public void visit(OWLDataHasValue oWLDataHasValue) {
        this.writeRestriction(oWLDataHasValue.getProperty(), Keyword.VALUE, oWLDataHasValue.getValue());
    }

    public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        this.writeKeywordPrefix(Keyword.DECLARATION, (OWLObject)oWLDeclarationAxiom.getEntity());
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        this.writeNaryAxiom(oWLDifferentIndividualsAxiom.getIndividuals(), Keyword.DIFFERENT_INDIVIDUAL, Keyword.DIFFERENT_INDIVIDUALS);
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        this.writeNaryAxiom(oWLDisjointClassesAxiom.getClassExpressions(), Keyword.DISJOINT_CLASS, Keyword.DISJOINT_CLASSES);
    }

    public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        this.writeNaryAxiom(oWLDisjointDataPropertiesAxiom.getProperties(), Keyword.DISJOINT_PROPERTY, Keyword.DISJOINT_PROPERTIES);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        this.writeNaryAxiom(oWLDisjointObjectPropertiesAxiom.getProperties(), Keyword.DISJOINT_PROPERTY, Keyword.DISJOINT_PROPERTIES);
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        this.write((OWLObject)oWLDisjointUnionAxiom.getOWLClass());
        this.writeSpace();
        this.write(Keyword.DISJOINT_UNION);
        this.writeSpace();
        this.writeNaryKeyword(Keyword.OR, oWLDisjointUnionAxiom.getClassExpressions());
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        this.writeNaryAxiom(oWLEquivalentClassesAxiom.getClassExpressions(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_CLASSES);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        this.writeNaryAxiom(oWLEquivalentDataPropertiesAxiom.getProperties(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_PROPERTIES);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        this.writeNaryAxiom(oWLEquivalentObjectPropertiesAxiom.getProperties(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_PROPERTIES);
    }

    public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)oWLFunctionalDataPropertyAxiom, Keyword.FUNCTIONAL);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)oWLFunctionalObjectPropertyAxiom, Keyword.FUNCTIONAL);
    }

    public void visit(OWLAnonymousIndividual oWLAnonymousIndividual) {
        this.write(oWLAnonymousIndividual.getID().getID());
    }

    public void visit(OWLNamedIndividual oWLNamedIndividual) {
        this.write(oWLNamedIndividual.getIRI());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)oWLInverseFunctionalObjectPropertyAxiom, Keyword.INVERSE_FUNCTIONAL);
    }

    public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        this.writeKeywordInfix(Keyword.INVERSE_OF, (OWLObject)oWLInverseObjectPropertiesAxiom.getFirstProperty(), (OWLObject)oWLInverseObjectPropertiesAxiom.getSecondProperty());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)oWLIrreflexiveObjectPropertyAxiom, Keyword.IRREFLEXIVE);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        this.write(Keyword.NOT_RELATIONSHIP);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)oWLNegativeDataPropertyAssertionAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)oWLNegativeDataPropertyAssertionAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)oWLNegativeDataPropertyAssertionAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        this.write(Keyword.NOT_RELATIONSHIP);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)oWLNegativeObjectPropertyAssertionAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)oWLNegativeObjectPropertyAssertionAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)oWLNegativeObjectPropertyAssertionAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?, ?>)oWLObjectAllValuesFrom, Keyword.ONLY);
    }

    public void visit(OWLObjectComplementOf oWLObjectComplementOf) {
        this.writeKeywordPrefix(Keyword.NOT, (OWLObject)oWLObjectComplementOf.getOperand());
    }

    public void visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)oWLObjectExactCardinality, Keyword.EXACTLY);
    }

    public void visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
        this.writeNaryKeyword(Keyword.AND, oWLObjectIntersectionOf.getOperands());
    }

    public void visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)oWLObjectMaxCardinality, Keyword.MAX);
    }

    public void visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?, ?>)oWLObjectMinCardinality, Keyword.MIN);
    }

    public void visit(OWLObjectOneOf oWLObjectOneOf) {
        this.writeEnumeration(oWLObjectOneOf.getIndividuals());
    }

    public void visit(OWLObjectProperty oWLObjectProperty) {
        this.write(oWLObjectProperty.getIRI());
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        this.write((OWLObject)oWLObjectPropertyAssertionAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)oWLObjectPropertyAssertionAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)oWLObjectPropertyAssertionAxiom.getObject());
    }

    public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        this.writeCollection(oWLSubPropertyChainOfAxiom.getPropertyChain(), " o", false);
        this.writeSpace();
        this.write(Keyword.SUB_PROPERTY_OF);
        this.writeSpace();
        this.write((OWLObject)oWLSubPropertyChainOfAxiom.getSuperProperty());
    }

    public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, (OWLObject)oWLObjectPropertyDomainAxiom.getProperty(), (OWLObject)oWLObjectPropertyDomainAxiom.getDomain());
    }

    public void visit(OWLObjectInverseOf oWLObjectInverseOf) {
        this.writeKeywordPrefix(Keyword.INVERSE, (OWLObject)oWLObjectInverseOf.getInverse());
    }

    public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, (OWLObject)oWLObjectPropertyRangeAxiom.getProperty(), (OWLObject)oWLObjectPropertyRangeAxiom.getRange());
    }

    public void visit(OWLObjectHasSelf oWLObjectHasSelf) {
        this.writeRestriction(oWLObjectHasSelf.getProperty(), Keyword.SELF, new Object[0]);
    }

    public void visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?, ?>)oWLObjectSomeValuesFrom, Keyword.SOME);
    }

    public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)oWLSubObjectPropertyOfAxiom.getSubProperty(), (OWLObject)oWLSubObjectPropertyOfAxiom.getSuperProperty());
    }

    public void visit(OWLObjectUnionOf oWLObjectUnionOf) {
        this.writeNaryKeyword(Keyword.OR, oWLObjectUnionOf.getOperands());
    }

    public void visit(OWLObjectHasValue oWLObjectHasValue) {
        this.writeRestriction(oWLObjectHasValue.getProperty(), Keyword.VALUE, oWLObjectHasValue.getValue());
    }

    public void visit(OWLOntology oWLOntology) {
        this.write(oWLOntology.getOntologyID().getOntologyIRI());
    }

    public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)oWLReflexiveObjectPropertyAxiom, Keyword.REFLEXIVE_PROPERTY);
    }

    public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        this.writeNaryAxiom(oWLSameIndividualAxiom.getIndividuals(), Keyword.SAME_INDIVIDUAL, Keyword.SAME_INDIVIDUALS);
    }

    public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        this.writeKeywordInfix(Keyword.SUB_CLASS_OF, (OWLObject)oWLSubClassOfAxiom.getSubClass(), (OWLObject)oWLSubClassOfAxiom.getSuperClass());
    }

    public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)oWLSymmetricObjectPropertyAxiom, Keyword.SYMMETRIC);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)oWLTransitiveObjectPropertyAxiom, Keyword.TRANSITIVE);
    }

    public void visit(OWLLiteral oWLLiteral) {
        if (oWLLiteral.isRDFPlainLiteral()) {
            this.write("\"");
            this.write(oWLLiteral.getLiteral());
            this.write("\"");
            if (oWLLiteral.getLang() != null && !oWLLiteral.getLang().equals("")) {
                this.write("@");
                this.write(oWLLiteral.getLang());
            }
        } else if (oWLLiteral.getDatatype().getIRI().equals((Object)XSDVocabulary.INTEGER.getIRI()) || oWLLiteral.getDatatype().getIRI().equals((Object)XSDVocabulary.DECIMAL.getIRI())) {
            this.write(oWLLiteral.getLiteral());
        } else if (oWLLiteral.getDatatype().getIRI().equals((Object)XSDVocabulary.FLOAT.getIRI())) {
            this.write(oWLLiteral.getLiteral());
            this.write("f");
        } else {
            this.write("\"");
            this.write(oWLLiteral.getLiteral());
            this.write("\"");
            this.write("^^");
            this.write((OWLObject)oWLLiteral.getDatatype());
        }
    }

    public void visit(SWRLLiteralArgument sWRLLiteralArgument) {
        this.write((OWLObject)sWRLLiteralArgument.getLiteral());
    }

    public void visit(SWRLIndividualArgument sWRLIndividualArgument) {
        this.write((OWLObject)sWRLIndividualArgument.getIndividual());
    }

    public void visit(SWRLVariable sWRLVariable) {
        this.write("?");
        this.write(sWRLVariable.getIRI());
    }

    public void visit(SWRLBuiltInAtom sWRLBuiltInAtom) {
        this.write(sWRLBuiltInAtom.getPredicate());
        this.write("(");
        for (SWRLArgument sWRLArgument : sWRLBuiltInAtom.getArguments()) {
            this.write((OWLObject)sWRLArgument);
            this.write(" ");
        }
        this.write(")");
    }

    public void visit(SWRLClassAtom sWRLClassAtom) {
        this.write((OWLObject)sWRLClassAtom.getPredicate());
        this.write("(");
        this.write((OWLObject)sWRLClassAtom.getArgument());
        this.write(")");
    }

    public void visit(SWRLDataRangeAtom sWRLDataRangeAtom) {
        this.write((OWLObject)sWRLDataRangeAtom.getPredicate());
        this.write("(");
        this.write((OWLObject)sWRLDataRangeAtom.getArgument());
        this.write(")");
    }

    public void visit(SWRLDataPropertyAtom sWRLDataPropertyAtom) {
        this.write((OWLObject)sWRLDataPropertyAtom.getPredicate());
        this.write("(");
        this.write((OWLObject)sWRLDataPropertyAtom.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)sWRLDataPropertyAtom.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom) {
        this.write("differentFrom");
        this.write("(");
        this.write((OWLObject)sWRLDifferentIndividualsAtom.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)sWRLDifferentIndividualsAtom.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLObjectPropertyAtom sWRLObjectPropertyAtom) {
        this.write((OWLObject)sWRLObjectPropertyAtom.getPredicate());
        this.write("(");
        this.write((OWLObject)sWRLObjectPropertyAtom.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)sWRLObjectPropertyAtom.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLRule sWRLRule) {
        this.write("Rule");
        this.write("(");
        boolean bl = true;
        for (SWRLAtom sWRLAtom : sWRLRule.getBody()) {
            if (bl) {
                bl = false;
            } else {
                this.write(", ");
            }
            this.write((OWLObject)sWRLAtom);
        }
        this.write(" -> ");
        bl = true;
        for (SWRLAtom sWRLAtom : sWRLRule.getHead()) {
            if (bl) {
                bl = false;
            } else {
                this.write(", ");
            }
            this.write((OWLObject)sWRLAtom);
        }
        this.write(")");
    }

    public void visit(SWRLSameIndividualAtom sWRLSameIndividualAtom) {
        this.write("sameAs");
        this.write("(");
        this.write((OWLObject)sWRLSameIndividualAtom.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)sWRLSameIndividualAtom.getSecondArgument());
        this.write(")");
    }

    protected void writeNaryKeyword(Keyword keyword, Set<? extends OWLObject> set) {
        set = DescriptionSorter.toSortedSet(set);
        Iterator<? extends OWLObject> iterator = set.iterator();
        if (this.smartIndent) {
            this.writer.startBlock();
        }
        this.write(iterator.next());
        while (iterator.hasNext()) {
            if (this.wrapLines) {
                this.writeNewLine();
            } else {
                this.writeSpace();
            }
            if (keyword != null) {
                this.write(keyword);
                this.writeSpace();
            }
            this.write(iterator.next());
        }
        if (this.smartIndent) {
            this.writer.endBlock();
        }
    }

    protected void writeCardinalityRestriction(OWLCardinalityRestriction<?, ?, ?> oWLCardinalityRestriction, Keyword keyword) {
        if (oWLCardinalityRestriction.isQualified()) {
            this.writeRestriction(oWLCardinalityRestriction.getProperty(), keyword, oWLCardinalityRestriction.getCardinality(), oWLCardinalityRestriction.getFiller());
        } else {
            this.writeRestriction(oWLCardinalityRestriction.getProperty(), keyword, oWLCardinalityRestriction.getCardinality());
        }
    }

    protected void writeNaryAxiom(Set<? extends OWLObject> set, Keyword keyword, Keyword keyword2) {
        Set<? extends OWLObject> set2 = DescriptionSorter.toSortedSet(set);
        Iterator<? extends OWLObject> iterator = set2.iterator();
        if (set.size() == 2) {
            this.writeKeywordInfix(keyword, iterator.next(), iterator.next());
        } else {
            this.write(keyword2);
            this.write("(");
            this.writeNaryKeyword(null, set);
            this.write(")");
        }
    }

    protected void writeQuantifiedRestriction(OWLQuantifiedRestriction<?, ?, ?> oWLQuantifiedRestriction, Keyword keyword) {
        this.writeRestriction(oWLQuantifiedRestriction.getProperty(), keyword, oWLQuantifiedRestriction.getFiller());
    }

    protected void writeRestriction(OWLPropertyExpression<?, ?> oWLPropertyExpression, Keyword keyword, Object ... objectArray) {
        this.write((OWLObject)oWLPropertyExpression);
        this.writeSpace();
        this.write(keyword);
        for (Object object : objectArray) {
            this.writeSpace();
            if (object instanceof OWLObject) {
                this.write((OWLObject)object);
                continue;
            }
            this.write(object.toString());
        }
    }

    protected void writeUnaryPropertyAxiom(OWLUnaryPropertyAxiom<?> oWLUnaryPropertyAxiom, Keyword keyword) {
        this.writeKeywordPrefix(keyword, (OWLObject)oWLUnaryPropertyAxiom.getProperty());
    }

    protected void writeKeywordPrefix(Keyword keyword, OWLObject oWLObject) {
        this.write(keyword);
        this.writeSpace();
        this.write(oWLObject);
    }

    protected void writeKeywordPrefix(Keyword keyword, OWLObject oWLObject, OWLObject oWLObject2) {
        this.write(keyword);
        this.writeSpace();
        this.write("(");
        this.write(oWLObject);
        this.writeSpace();
        this.write(oWLObject2);
        this.write(")");
    }

    protected void writeKeywordInfix(Keyword keyword, OWLObject oWLObject, OWLObject oWLObject2) {
        this.write(oWLObject);
        this.writeSpace();
        this.write(keyword);
        this.writeSpace();
        this.write(oWLObject2);
    }

    protected void writeEnumeration(Set<? extends OWLObject> set) {
        this.write(Keyword.OPEN_BRACE);
        this.writeCollection(set, ",", true);
        this.write(Keyword.CLOSE_BRACE);
    }

    protected void writeCollection(Collection<? extends OWLObject> collection, String string, boolean bl) {
        if (bl) {
            collection = DescriptionSorter.toSortedSet(collection);
        }
        boolean bl2 = true;
        for (OWLObject oWLObject : collection) {
            if (bl2) {
                bl2 = false;
            } else {
                this.write(string);
                this.writeSpace();
            }
            this.write(oWLObject);
        }
    }

    protected void write(OWLObject oWLObject) {
        oWLObject.accept((OWLObjectVisitor)this);
    }

    protected void write(Keyword keyword) {
        this.write(keyword.getLabel());
    }

    protected void write(String string) {
        this.writer.print(string);
    }

    protected void write(IRI iRI) {
        this.write(this.shortForm(iRI));
    }

    protected void writeNewLine() {
        this.writer.println();
    }

    protected void writeSpace() {
        this.write(" ");
    }

    public void visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        this.write((OWLObject)oWLHasKeyAxiom.getClassExpression());
        this.writeSpace();
        this.write(Keyword.HAS_KEY);
        if (!oWLHasKeyAxiom.getObjectPropertyExpressions().isEmpty()) {
            this.writeCollection(oWLHasKeyAxiom.getObjectPropertyExpressions(), "", true);
            this.writeSpace();
        }
        this.writeCollection(oWLHasKeyAxiom.getDataPropertyExpressions(), "", true);
    }

    public void visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        this.writeKeywordInfix(Keyword.EQUIVALENT_TO, (OWLObject)oWLDatatypeDefinitionAxiom.getDatatype(), (OWLObject)oWLDatatypeDefinitionAxiom.getDataRange());
    }

    public void visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        this.write((OWLObject)oWLAnnotationAssertionAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)oWLAnnotationAssertionAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)oWLAnnotationAssertionAxiom.getValue());
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)oWLSubAnnotationPropertyOfAxiom.getSubProperty(), (OWLObject)oWLSubAnnotationPropertyOfAxiom.getSuperProperty());
    }

    public void visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, (OWLObject)oWLAnnotationPropertyDomainAxiom.getProperty(), (OWLObject)oWLAnnotationPropertyDomainAxiom.getDomain());
    }

    public void visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, (OWLObject)oWLAnnotationPropertyRangeAxiom.getProperty(), (OWLObject)oWLAnnotationPropertyRangeAxiom.getRange());
    }

    public void visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
        this.writeNaryKeyword(Keyword.AND, oWLDataIntersectionOf.getOperands());
    }

    public void visit(OWLDataUnionOf oWLDataUnionOf) {
        this.writeNaryKeyword(Keyword.OR, oWLDataUnionOf.getOperands());
    }

    public void visit(OWLAnnotationProperty oWLAnnotationProperty) {
        this.write(oWLAnnotationProperty.getIRI());
    }

    public void visit(IRI iRI) {
        this.write(iRI);
    }
}

