/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver.stats;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.StatsMatcher;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemWriter;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollector;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollectorNodeId;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;

public class Stats {
    static Item ZERO = Item.createNode((Node)NodeFactory.intToNode((int)0));

    public static void write(String filename, StatsCollector stats) {
        Stats.write(filename, stats.getPredicates(), stats.getCount());
    }

    public static void write(OutputStream output, StatsCollector stats) {
        Stats.write(output, stats.getPredicates(), stats.getCount());
    }

    public static void write(DatasetGraphTDB dsg, StatsCollectorNodeId statsById) {
        long statsTotal = statsById.getCount();
        Map<Node, Integer> stats = statsById.asNodeStats(dsg.getTripleTable().getNodeTupleTable().getNodeTable());
        Item item = Stats.format(stats, statsTotal);
        String filename = dsg.getLocation().getPath("stats.opt");
        Stats.write(filename, stats, statsTotal);
    }

    private static void write(String filename, Map<Node, Integer> stats, long statsTotal) {
        try {
            FileOutputStream statsOut = new FileOutputStream(filename);
            Stats.write(statsOut, stats, statsTotal);
            ((OutputStream)statsOut).close();
        }
        catch (IOException ex) {
            Log.warn(Stats.class, (String)"Problem when writing stats file", (Throwable)ex);
        }
    }

    private static void write(OutputStream output, Map<Node, Integer> stats, long statsTotal) {
        Item item = Stats.format(stats, statsTotal);
        ItemWriter.write((OutputStream)output, (Item)item);
    }

    public static StatsCollector gather(Graph graph) {
        StatsCollector stats = new StatsCollector();
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            stats.record(null, t.getSubject(), t.getPredicate(), t.getObject());
        }
        return stats;
    }

    public static StatsCollector gatherTDB(GraphTDB graph) {
        long count = 0L;
        HashMap predicateIds = new HashMap(1000);
        TupleIndex index = graph.getNodeTupleTable().getTupleTable().getIndex(0);
        if (!index.getName().equals("SPO") && !index.getName().equals("GSPO")) {
            Log.warn(StatsCollector.class, (String)("May not be the right index: " + index.getName() + " mapping=" + index.getColumnMap().getLabel()));
        }
        boolean quads = index.getTupleLength() == 4;
        Iterator<Tuple<NodeId>> iter = graph.getNodeTupleTable().findAll();
        StatsCollectorNodeId collector = new StatsCollectorNodeId();
        while (iter.hasNext()) {
            Tuple<NodeId> tuple = iter.next();
            ++count;
            if (quads) {
                collector.record(tuple.get(0), tuple.get(1), tuple.get(2), tuple.get(3));
                continue;
            }
            collector.record(null, tuple.get(0), tuple.get(1), tuple.get(2));
        }
        Map<Node, Integer> predicates = collector.asNodeStats(graph.getNodeTupleTable().getNodeTable());
        return new StatsCollector(count, predicates);
    }

    private static Item statsOutput(NodeTable nodeTable, Map<NodeId, Integer> predicateIds, long total) {
        HashMap<Node, Integer> predicates = new HashMap<Node, Integer>(1000);
        for (NodeId p : predicateIds.keySet()) {
            Node n = nodeTable.getNodeForNodeId(p);
            if (n.getURI().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
            predicates.put(n, predicateIds.get(p));
        }
        return Stats.format(predicates, total);
    }

    public static Item format(StatsCollector stats) {
        return Stats.format(stats.getPredicates(), stats.getCount());
    }

    private static Item format(Map<Node, Integer> predicates, long count) {
        Item stats = Item.createList();
        ItemList statsList = stats.getList();
        statsList.add("stats");
        Item meta = Item.createTagged((String)"meta");
        Item.addPair((ItemList)meta.getList(), (String)"timestamp", (Node)NodeFactory.nowAsDateTime());
        Item.addPair((ItemList)meta.getList(), (String)"run@", (String)Utils.nowAsString());
        if (count >= 0L) {
            Item.addPair((ItemList)meta.getList(), (String)"count", (Node)NodeFactory.intToNode((int)((int)count)));
        }
        statsList.add(meta);
        for (Map.Entry<Node, Integer> entry : predicates.entrySet()) {
            Node node = entry.getKey();
            if (node.getURI().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
            Item.addPair((ItemList)statsList, (Node)node, (Node)NodeFactory.intToNode((int)entry.getValue()));
        }
        Item.addPair((ItemList)statsList, (Item)StatsMatcher.OTHER, (Item)ZERO);
        return stats;
    }
}

