/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.AbstractDefinitionOrder;

public class JGraphBasedDefinitionOrder
extends AbstractDefinitionOrder {
    private Map<ATermAppl, Set<ATermAppl>> equivalents;
    private DirectedGraph<ATermAppl, DefaultEdge> graph;

    public JGraphBasedDefinitionOrder(KnowledgeBase knowledgeBase, Comparator<ATerm> comparator) {
        super(knowledgeBase, comparator);
    }

    private Set<ATermAppl> createSet() {
        return this.comparator != null ? new TreeSet(this.comparator) : CollectionUtils.makeIdentitySet();
    }

    private Queue<ATermAppl> createQueue() {
        return (Queue)((Object)(this.comparator != null ? new PriorityQueue(10, this.comparator) : new LinkedList()));
    }

    private boolean addEquivalent(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Set<ATermAppl> set = this.equivalents.get(aTermAppl);
        if (set == null) {
            set = this.createSet();
            this.equivalents.put(aTermAppl, set);
        }
        return set.add(aTermAppl2);
    }

    private Set<ATermAppl> getAllEquivalents(ATermAppl aTermAppl) {
        Set<ATermAppl> set = this.equivalents.get(aTermAppl);
        if (set != null) {
            set.add(aTermAppl);
        } else {
            set = Collections.singleton(aTermAppl);
        }
        return set;
    }

    private Set<ATermAppl> getEquivalents(ATermAppl aTermAppl) {
        Set<ATermAppl> set = this.equivalents.get(aTermAppl);
        return set != null ? set : Collections.emptySet();
    }

    @Override
    protected void initialize() {
        this.equivalents = CollectionUtils.makeIdentityMap();
        this.graph = new DefaultDirectedGraph(DefaultEdge.class);
        this.graph.addVertex((Object)TermFactory.TOP);
        for (ATermAppl aTermAppl : this.kb.getClasses()) {
            this.graph.addVertex((Object)aTermAppl);
        }
    }

    @Override
    protected void addUses(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (aTermAppl.equals(TermFactory.TOP)) {
            this.addEquivalent(TermFactory.TOP, aTermAppl2);
        } else if (!aTermAppl.equals(aTermAppl2)) {
            this.graph.addEdge((Object)aTermAppl, (Object)aTermAppl2);
        }
    }

    @Override
    protected Set<ATermAppl> computeCycles() {
        Set<ATermAppl> set = CollectionUtils.makeIdentitySet();
        set.addAll(this.getEquivalents(TermFactory.TOP));
        StrongConnectivityInspector strongConnectivityInspector = new StrongConnectivityInspector(this.graph);
        List list = strongConnectivityInspector.stronglyConnectedSets();
        for (Set set2 : list) {
            if (set2.size() == 1) continue;
            set.addAll(set2);
            this.collapseCycle(set2);
        }
        return set;
    }

    private void collapseCycle(Set<ATermAppl> set) {
        Iterator<ATermAppl> iterator = set.iterator();
        ATermAppl aTermAppl = iterator.next();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl2;
            ATermAppl aTermAppl3 = iterator.next();
            this.addEquivalent(aTermAppl, aTermAppl3);
            for (DefaultEdge defaultEdge : this.graph.incomingEdgesOf((Object)aTermAppl3)) {
                aTermAppl2 = (ATermAppl)this.graph.getEdgeSource((Object)defaultEdge);
                if (aTermAppl2.equals(aTermAppl)) continue;
                this.graph.addEdge((Object)aTermAppl2, (Object)aTermAppl);
            }
            for (DefaultEdge defaultEdge : this.graph.outgoingEdgesOf((Object)aTermAppl3)) {
                aTermAppl2 = (ATermAppl)this.graph.getEdgeTarget((Object)defaultEdge);
                if (aTermAppl2.equals(aTermAppl)) continue;
                this.graph.addEdge((Object)aTermAppl, (Object)aTermAppl2);
            }
            this.graph.removeVertex((Object)aTermAppl3);
        }
    }

    @Override
    protected List<ATermAppl> computeDefinitionOrder() {
        List<ATermAppl> list = CollectionUtils.makeList();
        list.add(TermFactory.TOP);
        list.addAll(this.getEquivalents(TermFactory.TOP));
        this.graph.removeVertex((Object)TermFactory.TOP);
        this.destructiveTopologocialSort(list);
        list.add(TermFactory.BOTTOM);
        return list;
    }

    public void destructiveTopologocialSort(List<ATermAppl> list) {
        Queue<ATermAppl> queue = this.createQueue();
        for (Object object : this.graph.vertexSet()) {
            if (this.graph.outDegreeOf(object) != 0) continue;
            queue.add((ATermAppl)object);
        }
        while (!queue.isEmpty()) {
            ATermAppl aTermAppl = queue.remove();
            assert (this.graph.outDegreeOf((Object)aTermAppl) == 0);
            list.addAll(this.getAllEquivalents(aTermAppl));
            for (DefaultEdge defaultEdge : this.graph.incomingEdgesOf((Object)aTermAppl)) {
                ATermAppl aTermAppl2 = (ATermAppl)this.graph.getEdgeSource((Object)defaultEdge);
                if (this.graph.outDegreeOf((Object)aTermAppl2) != 1) continue;
                queue.add(aTermAppl2);
            }
            this.graph.removeVertex((Object)aTermAppl);
        }
        assert (this.graph.vertexSet().isEmpty()) : "Failed to sort elements: " + this.graph.vertexSet();
    }
}

