/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.renderer;

import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.obo.renderer.OBOExceptionHandler;
import org.coode.owlapi.obo.renderer.OBORelationship;
import org.coode.owlapi.obo.renderer.OBOStorageException;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class OBORelationshipGenerator
extends OWLClassExpressionVisitorAdapter {
    private Set<OBORelationship> relationships = new HashSet<OBORelationship>();
    private OBOExceptionHandler eHandler;
    private OWLClass cls;

    public OBORelationshipGenerator(OBOExceptionHandler eHandler) {
        this.eHandler = eHandler;
    }

    public void setClass(OWLClass cls) {
        this.cls = cls;
        this.clear();
    }

    public void clear() {
        this.relationships.clear();
    }

    public Set<OBORelationship> getOBORelationships() {
        return new HashSet<OBORelationship>(this.relationships);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom desc) {
        this.getRelationship(desc);
    }

    @Override
    public void visit(OWLObjectMinCardinality desc) {
        OBORelationship rel = this.getRelationship(desc);
        if (rel != null) {
            rel.setMinCardinality(desc.getCardinality());
        }
    }

    @Override
    public void visit(OWLObjectExactCardinality desc) {
        OBORelationship rel = this.getRelationship(desc);
        if (rel != null) {
            rel.setCardinality(desc.getCardinality());
        }
    }

    @Override
    public void visit(OWLObjectMaxCardinality desc) {
        OBORelationship rel = this.getRelationship(desc);
        if (rel != null) {
            rel.setMaxCardinality(desc.getCardinality());
        }
    }

    private OBORelationship getRelationship(OWLObjectCardinalityRestriction desc) {
        if (desc.isAnonymous() && !((OWLClassExpression)desc.getFiller()).isAnonymous()) {
            OWLObjectProperty p = ((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty();
            OWLClass f = ((OWLClassExpression)desc.getFiller()).asOWLClass();
            for (OBORelationship rel : this.relationships) {
                if (!rel.getProperty().equals(p) || !rel.getFiller().equals(f)) continue;
                return rel;
            }
            OBORelationship newRel = new OBORelationship(p, f);
            this.relationships.add(newRel);
            return newRel;
        }
        this.eHandler.addException(new OBOStorageException(this.cls, desc, "Anonymous filler of some restriction cannot be converted to OBO"));
        return null;
    }

    private OBORelationship getRelationship(OWLQuantifiedObjectRestriction desc) {
        if (desc.isAnonymous() && !((OWLClassExpression)desc.getFiller()).isAnonymous()) {
            OWLObjectProperty p = ((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty();
            OWLClass f = ((OWLClassExpression)desc.getFiller()).asOWLClass();
            for (OBORelationship rel : this.relationships) {
                if (!rel.getProperty().equals(p) || !rel.getFiller().equals(f)) continue;
                return rel;
            }
            OBORelationship newRel = new OBORelationship(p, f);
            this.relationships.add(newRel);
            return newRel;
        }
        this.eHandler.addException(new OBOStorageException(this.cls, desc, "Anonymous filler of some restriction cannot be converted to OBO"));
        return null;
    }
}

