/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public abstract class AbstractIntSet
implements IntSet {
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    @Override
    public void addAll(IntSet intSet) {
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            this.add(intIterator.next());
        }
    }

    protected void added(int n, int n2) {
        if (n < this.min) {
            this.min = n;
        }
        if (n2 > this.max) {
            this.max = n2;
        }
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.max;
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.min;
    }

    protected void removed(int n, int n2) {
        if (this.isEmpty() || n == this.min || n2 == this.max) {
            this.min = Integer.MAX_VALUE;
            this.max = Integer.MIN_VALUE;
            IntIterator intIterator = this.iterator();
            while (intIterator.hasNext()) {
                int n3 = intIterator.next();
                if (n3 < this.min) {
                    this.min = n3;
                }
                if (n3 <= this.max) continue;
                this.max = n3;
            }
        }
    }

    @Override
    public IntSet union(IntSet intSet) {
        IntSet intSet2 = this.copy();
        intSet2.addAll(intSet);
        return intSet2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append(String.valueOf(intIterator.next()));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

