/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.impl.RuleAbsorber;
import org.mindswap.pellet.tbox.impl.TBoxBase;
import org.mindswap.pellet.tbox.impl.TBoxExpImpl;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;

public class TgBox
extends TBoxBase {
    public static final Logger log = Logger.getLogger(TgBox.class.getName());
    private Set<ATermAppl> explanation;
    private List<Unfolding> UC = null;

    public TgBox(TBoxExpImpl tBoxExpImpl) {
        super(tBoxExpImpl);
    }

    public void internalize() {
        this.UC = new ArrayList<Unfolding>();
        for (TermDefinition termDefinition : this.termhash.values()) {
            Set<Object> set;
            ATermAppl aTermAppl;
            ATermAppl aTermAppl2;
            ATermAppl aTermAppl3;
            ATermAppl aTermAppl4;
            ATermAppl aTermAppl5;
            for (ATermAppl aTermAppl6 : termDefinition.getSubClassAxioms()) {
                aTermAppl5 = (ATermAppl)aTermAppl6.getArgument(0);
                aTermAppl4 = (ATermAppl)aTermAppl6.getArgument(1);
                aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl5);
                aTermAppl2 = ATermUtils.makeOr(aTermAppl3, aTermAppl4);
                aTermAppl = ATermUtils.normalize(aTermAppl2);
                set = PelletOptions.USE_TRACING ? this.tbox.getAxiomExplanation(aTermAppl6) : Collections.emptySet();
                this.UC.add(Unfolding.create(aTermAppl, set));
            }
            for (ATermAppl aTermAppl6 : termDefinition.getEqClassAxioms()) {
                aTermAppl5 = (ATermAppl)aTermAppl6.getArgument(0);
                aTermAppl4 = (ATermAppl)aTermAppl6.getArgument(1);
                aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl5);
                aTermAppl2 = ATermUtils.makeNot((ATerm)aTermAppl4);
                aTermAppl = ATermUtils.makeOr(aTermAppl3, aTermAppl4);
                set = ATermUtils.makeOr(aTermAppl2, aTermAppl5);
                Set<Object> set2 = PelletOptions.USE_TRACING ? this.tbox.getAxiomExplanation(aTermAppl6) : Collections.emptySet();
                this.UC.add(Unfolding.create(ATermUtils.normalize(aTermAppl), set2));
                this.UC.add(Unfolding.create(ATermUtils.normalize(set), set2));
            }
        }
    }

    public void absorb() {
        log.fine("Absorption started");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Tg.size was " + this.termhash.size() + " Tu.size was " + this.tbox.Tu.size());
        }
        Collection collection = this.termhash.values();
        this.termhash = new HashMap();
        for (TermDefinition termDefinition : collection) {
            ATermAppl aTermAppl;
            ATermAppl aTermAppl2;
            this.kb.timers.checkTimer("preprocessing");
            for (ATermAppl aTermAppl3 : termDefinition.getSubClassAxioms()) {
                aTermAppl2 = (ATermAppl)aTermAppl3.getArgument(0);
                aTermAppl = (ATermAppl)aTermAppl3.getArgument(1);
                this.absorbSubClass(aTermAppl2, aTermAppl, this.tbox.getAxiomExplanation(aTermAppl3));
            }
            for (ATermAppl aTermAppl3 : termDefinition.getEqClassAxioms()) {
                aTermAppl2 = (ATermAppl)aTermAppl3.getArgument(0);
                aTermAppl = (ATermAppl)aTermAppl3.getArgument(1);
                this.absorbSubClass(aTermAppl2, aTermAppl, this.tbox.getAxiomExplanation(aTermAppl3));
                this.absorbSubClass(aTermAppl, aTermAppl2, this.tbox.getAxiomExplanation(aTermAppl3));
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Tg.size is " + this.termhash.size() + " Tu.size is " + this.tbox.Tu.size());
        }
        log.fine("Absorption finished");
    }

    private void absorbSubClass(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Absorb: subClassOf(" + ATermUtils.toString(aTermAppl) + ", " + ATermUtils.toString(aTermAppl2) + ")");
        }
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        hashSet.add(ATermUtils.nnf(aTermAppl));
        hashSet.add(ATermUtils.nnf(ATermUtils.makeNot((ATerm)aTermAppl2)));
        this.explanation = new HashSet<ATermAppl>();
        this.explanation.addAll(set);
        this.absorbTerm(hashSet);
    }

    private boolean absorbTerm(Set<ATermAppl> set) {
        RuleAbsorber ruleAbsorber = new RuleAbsorber(this.tbox);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Absorbing term " + set);
        }
        while (true) {
            log.finer("Absorb rule");
            if (PelletOptions.USE_RULE_ABSORPTION && ruleAbsorber.absorbRule(set, this.explanation)) {
                return true;
            }
            log.finer("Absorb nominal");
            if (!PelletOptions.USE_PSEUDO_NOMINALS && (PelletOptions.USE_NOMINAL_ABSORPTION || PelletOptions.USE_HASVALUE_ABSORPTION) && this.absorbNominal(set)) {
                return true;
            }
            log.finer("Absorb II");
            if (this.absorbII(set)) {
                log.finer("Absorbed");
                return true;
            }
            log.finer("Absorb III");
            if (this.absorbIII(set)) {
                log.finer("Absorb III");
                continue;
            }
            log.finer("Absorb V");
            if (!this.absorbV(set)) break;
            log.finer("Absorb V");
        }
        log.finer("Absorb VI");
        if (this.absorbVI(set)) {
            log.finer("Recursed on OR");
            return true;
        }
        log.finer("Absorb role");
        if (PelletOptions.USE_ROLE_ABSORPTION && this.absorbRole(set)) {
            log.finer("Absorbed w/ Role");
            return true;
        }
        log.finer("Absorb VII");
        this.absorbVII(set);
        log.finer("Finished absorbTerm");
        return false;
    }

    private boolean absorbNominal(Set<ATermAppl> set) {
        Iterator<ATermAppl> iterator = set.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl;
            ATermAppl aTermAppl2 = iterator.next();
            if (PelletOptions.USE_NOMINAL_ABSORPTION && (ATermUtils.isOneOf(aTermAppl2) || ATermUtils.isNominal(aTermAppl2))) {
                iterator.remove();
                aTermAppl = null;
                aTermAppl = ATermUtils.isNominal(aTermAppl2) ? ATermUtils.makeList((ATerm)aTermAppl2) : (ATermList)aTermAppl2.getArgument(0);
                ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
                this.absorbOneOf((ATermList)aTermAppl, aTermAppl3, this.explanation);
                return true;
            }
            if (!PelletOptions.USE_HASVALUE_ABSORPTION || !ATermUtils.isHasValue(aTermAppl2) || !this.kb.isObjectProperty((ATerm)(aTermAppl = (ATermAppl)aTermAppl2.getArgument(0)))) continue;
            iterator.remove();
            ATermAppl aTermAppl4 = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl2.getArgument(1);
            ATermAppl aTermAppl6 = (ATermAppl)aTermAppl5.getArgument(0);
            ATermAppl aTermAppl7 = this.kb.getProperty((ATerm)aTermAppl).getInverse().getName();
            ATermAppl aTermAppl8 = ATermUtils.makeAllValues((ATerm)aTermAppl7, (ATerm)aTermAppl4);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Absorb into " + aTermAppl6 + " with inverse of " + aTermAppl + " for " + aTermAppl4);
            }
            this.tbox.getAbsorbedAxioms().addAll(this.explanation);
            this.kb.addIndividual(aTermAppl6);
            this.kb.addType(aTermAppl6, aTermAppl8, new DependencySet(this.explanation));
            return true;
        }
        return false;
    }

    void absorbOneOf(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        this.absorbOneOf((ATermList)aTermAppl.getArgument(0), aTermAppl2, set);
    }

    private void absorbOneOf(ATermList aTermList, ATermAppl aTermAppl, Set<ATermAppl> set) {
        if (PelletOptions.USE_PSEUDO_NOMINALS) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Ignoring axiom involving nominals: " + set);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Absorb nominals: " + ATermUtils.toString(aTermAppl) + " " + aTermList);
        }
        this.tbox.getAbsorbedAxioms().addAll(set);
        DependencySet dependencySet = new DependencySet(set);
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(0);
            this.kb.addIndividual(aTermAppl3);
            this.kb.addType(aTermAppl3, aTermAppl, dependencySet);
            aTermList = aTermList.getNext();
        }
    }

    private boolean absorbRole(Set<ATermAppl> set) {
        Iterator<ATermAppl> iterator = set.iterator();
        while (iterator.hasNext()) {
            int n;
            ATermAppl aTermAppl;
            ATermAppl aTermAppl2;
            ATermAppl aTermAppl3 = iterator.next();
            if (ATermUtils.isSomeValues(aTermAppl3)) {
                aTermAppl2 = (ATermAppl)aTermAppl3.getArgument(0);
                if (this.kb.getRole((ATerm)aTermAppl2).hasComplexSubRole()) continue;
                aTermAppl = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
                this.kb.addDomain((ATerm)aTermAppl2, aTermAppl, this.explanation);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Absorb domain: " + ATermUtils.toString(aTermAppl2) + " " + ATermUtils.toString(aTermAppl));
                }
                this.tbox.getAbsorbedAxioms().addAll(this.explanation);
                return true;
            }
            if (!ATermUtils.isMin(aTermAppl3)) continue;
            aTermAppl2 = (ATermAppl)aTermAppl3.getArgument(0);
            aTermAppl = (ATermAppl)aTermAppl3.getArgument(2);
            if (this.kb.getRole((ATerm)aTermAppl2).hasComplexSubRole() || !ATermUtils.isTop(aTermAppl) || (n = ((ATermInt)aTermAppl3.getArgument(1)).getInt()) != 1) continue;
            iterator.remove();
            ATermAppl aTermAppl4 = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
            this.kb.addDomain((ATerm)aTermAppl2, aTermAppl4, this.explanation);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Absorb domain: " + ATermUtils.toString(aTermAppl2) + " " + ATermUtils.toString(aTermAppl4));
            }
            this.tbox.getAbsorbedAxioms().addAll(this.explanation);
            return true;
        }
        return false;
    }

    private boolean absorbII(Set<ATermAppl> set) {
        for (ATermAppl aTermAppl : set) {
            boolean bl;
            TermDefinition termDefinition = this.tbox.Tu.getTD((ATerm)aTermAppl);
            if (termDefinition != null) {
                bl = termDefinition.getEqClassAxioms().isEmpty();
            } else {
                boolean bl2 = bl = aTermAppl.getArity() == 0 && set.size() > 1;
            }
            if (!bl) continue;
            set.remove(aTermAppl);
            ATermList aTermList = ATermUtils.makeList(set);
            ATermAppl aTermAppl2 = ATermUtils.makeAnd(aTermList);
            aTermAppl2 = ATermUtils.makeNot((ATerm)aTermAppl2);
            ATermAppl aTermAppl3 = ATermUtils.makeSub((ATerm)aTermAppl, (ATerm)ATermUtils.nnf(aTermAppl2));
            this.tbox.Tu.addDef(aTermAppl3);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Absorb named: " + ATermUtils.toString(aTermAppl3));
            }
            this.tbox.addAxiomExplanation(aTermAppl3, this.explanation);
            return true;
        }
        return false;
    }

    private boolean absorbIII(Set<ATermAppl> set) {
        for (ATermAppl aTermAppl : set) {
            List<ATermAppl> list;
            ATermAppl aTermAppl2 = null;
            TermDefinition termDefinition = this.tbox.Tu.getTD((ATerm)aTermAppl);
            if (termDefinition == null && ATermUtils.isNegatedPrimitive(aTermAppl)) {
                aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
                termDefinition = this.tbox.Tu.getTD((ATerm)aTermAppl2);
            }
            if (termDefinition == null || ATermUtils.isTop(termDefinition.getName()) || (list = termDefinition.getEqClassAxioms()).isEmpty()) continue;
            ATermAppl aTermAppl3 = list.get(0);
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl3.getArgument(1);
            set.remove(aTermAppl);
            if (aTermAppl2 == null) {
                set.add(aTermAppl4);
            } else {
                set.add(ATermUtils.negate(aTermAppl4));
            }
            this.explanation.addAll(this.tbox.getAxiomExplanation(aTermAppl3));
            return true;
        }
        return false;
    }

    private boolean absorbV(Set<ATermAppl> set) {
        for (ATermAppl aTermAppl : set) {
            ATermAppl aTermAppl2 = ATermUtils.nnf(aTermAppl);
            if (!aTermAppl2.getAFun().equals(ATermUtils.ANDFUN)) continue;
            set.remove(aTermAppl);
            ATermList aTermList = (ATermList)aTermAppl2.getArgument(0);
            while (!aTermList.isEmpty()) {
                set.add((ATermAppl)aTermList.getFirst());
                aTermList = aTermList.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbVI(Set<ATermAppl> set) {
        for (ATermAppl aTermAppl : set) {
            ATermAppl aTermAppl2 = ATermUtils.nnf(aTermAppl);
            if (!aTermAppl2.getAFun().equals(ATermUtils.ORFUN)) continue;
            set.remove(aTermAppl);
            ATermList aTermList = (ATermList)aTermAppl2.getArgument(0);
            while (!aTermList.isEmpty()) {
                HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(set);
                hashSet.add((ATermAppl)aTermList.getFirst());
                this.absorbTerm(hashSet);
                aTermList = aTermList.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbVII(Set<ATermAppl> set) {
        ATermList aTermList = ATermUtils.makeList(set);
        ATermAppl aTermAppl = ATermUtils.nnf((ATermAppl)aTermList.getFirst());
        ATermAppl aTermAppl2 = (aTermList = aTermList.getNext()).isEmpty() ? ATermUtils.makeNot((ATerm)aTermAppl) : ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(aTermList));
        aTermAppl2 = ATermUtils.nnf(aTermAppl2);
        ATermAppl aTermAppl3 = ATermUtils.makeSub((ATerm)aTermAppl, (ATerm)aTermAppl2);
        if (log.isLoggable(Level.FINE)) {
            log.fine("GCI: " + aTermAppl3 + "\nexplanation: " + this.explanation);
        }
        this.addDef(aTermAppl3);
        this.tbox.addAxiomExplanation(aTermAppl3, this.explanation);
        return true;
    }

    public List<Unfolding> getUC() {
        return this.UC;
    }

    @Override
    public int size() {
        return this.UC == null ? 0 : this.UC.size();
    }

    public void print(Appendable appendable) {
        try {
            appendable.append("Tg: [\n");
            if (this.UC != null) {
                for (Unfolding unfolding : this.UC) {
                    appendable.append(ATermUtils.toString(unfolding.getResult()));
                    appendable.append(", ");
                }
                appendable.append("\n");
            }
            appendable.append("]");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void print() {
        this.print(System.out);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.print(stringBuilder);
        return stringBuilder.toString();
    }
}

