/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.ATerm;
import aterm.ParseError;
import aterm.pure.PureFactory;
import java.io.IOException;
import java.io.Reader;

class ATermReader {
    private static final int INITIAL_TABLE_SIZE = 2048;
    private static final int TABLE_INCREMENT = 4096;
    private Reader reader;
    private int last_char;
    private int pos;
    private int nr_terms;
    private ATerm[] table;

    public ATermReader(Reader reader) {
        this.reader = reader;
        this.last_char = -1;
        this.pos = 0;
    }

    public void initializeSharing() {
        this.table = new ATerm[2048];
        this.nr_terms = 0;
    }

    public void storeNextTerm(ATerm t, int size) {
        if (this.table == null) {
            return;
        }
        if (size <= PureFactory.abbrevSize(this.nr_terms)) {
            return;
        }
        if (this.nr_terms == this.table.length) {
            ATerm[] new_table = new ATerm[this.table.length + 4096];
            System.arraycopy(this.table, 0, new_table, 0, this.table.length);
            this.table = new_table;
        }
        this.table[this.nr_terms++] = t;
    }

    public ATerm getTerm(int index) {
        if (index < 0 || index >= this.nr_terms) {
            throw new RuntimeException("illegal index");
        }
        return this.table[index];
    }

    public int read() throws IOException {
        this.last_char = this.reader.read();
        ++this.pos;
        return this.last_char;
    }

    public int readSkippingWS() throws IOException {
        do {
            this.last_char = this.reader.read();
            ++this.pos;
        } while (Character.isWhitespace((char)this.last_char));
        return this.last_char;
    }

    public int skipWS() throws IOException {
        while (Character.isWhitespace((char)this.last_char)) {
            this.last_char = this.reader.read();
            ++this.pos;
        }
        return this.last_char;
    }

    public int readOct() throws IOException {
        int val = Character.digit((char)this.last_char, 8);
        if ((val += Character.digit((char)this.read(), 8)) < 0) {
            throw new ParseError("octal must have 3 octdigits.");
        }
        if ((val += Character.digit((char)this.read(), 8)) < 0) {
            throw new ParseError("octal must have 3 octdigits");
        }
        return val;
    }

    public int getLastChar() {
        return this.last_char;
    }

    public int getPosition() {
        return this.pos;
    }
}

