/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.progress;

import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ProgressMonitor;

public abstract class AbstractProgressMonitor
implements ProgressMonitor {
    protected String progressTitle = "";
    protected String progressMessage = "";
    protected int progress = 0;
    protected int progressLength = 0;
    protected int progressPercent = -1;
    protected Timer timer = new Timer();
    protected boolean cancelled = false;

    public AbstractProgressMonitor() {
    }

    public AbstractProgressMonitor(int n) {
        this.setProgressLength(n);
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public int getProgressLength() {
        return this.progressLength;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    @Override
    public int getProgressPercent() {
        return this.progressPercent;
    }

    public String getProgressTitle() {
        return this.progressTitle;
    }

    @Override
    public void incrementProgress() {
        this.setProgress(this.progress + 1);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    protected void resetProgress() {
        this.progress = 0;
        this.progressPercent = -1;
    }

    @Override
    public void setProgress(int n) {
        this.progress = n;
        this.updateProgress();
    }

    @Override
    public void setProgressLength(int n) {
        this.progressLength = n;
        this.resetProgress();
    }

    @Override
    public void setProgressMessage(String string) {
        this.progressMessage = string;
    }

    @Override
    public void setProgressTitle(String string) {
        this.progressTitle = string;
    }

    @Override
    public void taskFinished() {
        this.timer.stop();
    }

    @Override
    public void taskStarted() {
        this.resetProgress();
        this.timer.start();
    }

    protected abstract void updateProgress();
}

