/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.blocking;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.blocking.Block1;
import org.mindswap.pellet.tableau.blocking.Block2;
import org.mindswap.pellet.tableau.blocking.Block3;
import org.mindswap.pellet.tableau.blocking.Block4;
import org.mindswap.pellet.tableau.blocking.Block5;
import org.mindswap.pellet.tableau.blocking.Block6;
import org.mindswap.pellet.tableau.blocking.BlockingCondition;
import org.mindswap.pellet.tableau.blocking.BlockingContext;
import org.mindswap.pellet.utils.Timer;

public abstract class Blocking {
    public static final Logger log = Logger.getLogger(Blocking.class.getName());
    protected static final BlockingCondition block1 = new Block1();
    protected static final BlockingCondition block2 = new Block2();
    protected static final BlockingCondition block3 = new Block3();
    protected static final BlockingCondition block4 = new Block4();
    protected static final BlockingCondition block5 = new Block5();
    protected static final BlockingCondition block6 = new Block6();

    protected Blocking() {
    }

    public boolean isDynamic() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocked(Individual individual) {
        Timer timer = individual.getABox().getKB().timers.startTimer("blocking");
        try {
            boolean bl = !individual.isRoot() && (this.isIndirectlyBlocked(individual) || this.isDirectlyBlockedInt(individual));
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    public boolean isIndirectlyBlocked(Individual individual) {
        Individual individual2 = individual.getParent();
        if (individual2 == null) {
            return false;
        }
        individual.setBlocked(this.isBlocked(individual2));
        return individual.isBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectlyBlocked(Individual individual) {
        Timer timer = individual.getABox().getKB().timers.startTimer("dBlocking");
        try {
            boolean bl = this.isDirectlyBlockedInt(individual);
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    protected boolean isDirectlyBlockedInt(Individual individual) {
        Individual individual2 = individual.getParent();
        if (individual.isRoot() || individual2.isRoot()) {
            return false;
        }
        BlockingContext blockingContext = new BlockingContext(individual);
        while (blockingContext.moveBlockerUp()) {
            if (!this.isDirectlyBlockedBy(blockingContext)) continue;
            individual.setBlocked(true);
            if (log.isLoggable(Level.FINER)) {
                log.finer(individual + " blocked by " + blockingContext.blocker);
            }
            return true;
        }
        if (PelletOptions.USE_ANYWHERE_BLOCKING) {
            assert (blockingContext.blocker.isRoot());
            return this.isDirectlyBlockedByDescendant(blockingContext);
        }
        return false;
    }

    protected boolean isDirectlyBlockedByDescendant(BlockingContext blockingContext) {
        if (blockingContext.blocked.getParent().equals(blockingContext.blocker)) {
            return false;
        }
        if (!blockingContext.blocker.isRoot() && this.isDirectlyBlockedBy(blockingContext)) {
            blockingContext.blocked.setBlocked(true);
            if (log.isLoggable(Level.FINER)) {
                log.finer(blockingContext.blocked + " blocked by " + blockingContext.blocker);
            }
            return true;
        }
        Individual individual = blockingContext.blocker;
        for (Edge edge : individual.getOutEdges()) {
            Node node = edge.getTo();
            if (!blockingContext.moveBlockerDown(node)) continue;
            if (this.isDirectlyBlockedByDescendant(blockingContext)) {
                return true;
            }
            blockingContext.moveBlockerUp();
        }
        return false;
    }

    protected abstract boolean isDirectlyBlockedBy(BlockingContext var1);
}

