/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena.graph.query;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;
import org.mindswap.pellet.jena.graph.query.BooleanQueryHandler;
import org.mindswap.pellet.jena.graph.query.BuiltinTypeQueryHandler;
import org.mindswap.pellet.jena.graph.query.ObjectVarHandler;
import org.mindswap.pellet.jena.graph.query.SubjectObjectVarHandler;
import org.mindswap.pellet.jena.graph.query.SubjectVarHandler;
import org.mindswap.pellet.jena.graph.query.TripleQueryHandler;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.iterator.FlattenningIterator;
import org.mindswap.pellet.utils.iterator.IteratorUtils;
import org.mindswap.pellet.utils.iterator.NestedIterator;

public class GraphQueryHandler {
    public static final Logger log = Logger.getLogger(GraphQueryHandler.class.getName());
    protected static final Node VAR = Node.ANY;
    protected static final Node CONST = Node.createURI((String)"CONST");
    private static final Node[] BUILTIN_PREDICATES = new Node[]{RDF.type.asNode(), OWL.sameAs.asNode(), OWL.differentFrom.asNode(), RDFS.subClassOf.asNode(), OWL.equivalentClass.asNode(), OWL.complementOf.asNode(), OWL.disjointWith.asNode(), RDFS.subPropertyOf.asNode(), OWL.equivalentProperty.asNode(), OWL.inverseOf.asNode(), OWL2.propertyDisjointWith.asNode(), RDFS.domain.asNode(), RDFS.range.asNode()};
    private static final Node[] BUILTIN_QUERY_PREDICATES = new Node[]{ReasonerVocabulary.directRDFType.asNode(), ReasonerVocabulary.directSubClassOf.asNode(), ReasonerVocabulary.directSubPropertyOf.asNode()};
    private static final Node[] BUILTIN_TYPES = new Node[]{OWL.Class.asNode(), OWL.AnnotationProperty.asNode(), OWL.ObjectProperty.asNode(), OWL.DatatypeProperty.asNode(), OWL.FunctionalProperty.asNode(), OWL.InverseFunctionalProperty.asNode(), OWL.TransitiveProperty.asNode(), OWL.SymmetricProperty.asNode(), OWL2.AsymmetricProperty.asNode(), OWL2.ReflexiveProperty.asNode(), OWL2.IrreflexiveProperty.asNode()};
    private static final Node[] BUILTIN_QUERY_TYPES = new Node[]{RDFS.Class.asNode(), RDF.Property.asNode()};
    private static final Set<Node> BUILTIN_KEYWORDS = new HashSet<Node>();
    private static final Map<Triple, TripleQueryHandler> QUERY_HANDLERS;

    private static void registerHandler(Node node, Resource resource, Node node2, TripleQueryHandler tripleQueryHandler) {
        GraphQueryHandler.registerHandler(node, resource.asNode(), node2, tripleQueryHandler);
    }

    private static void registerHandler(Node node, Resource resource, Resource resource2, TripleQueryHandler tripleQueryHandler) {
        GraphQueryHandler.registerHandler(node, resource.asNode(), resource2.asNode(), tripleQueryHandler);
    }

    private static void registerHandler(Node node, Node node2, Node node3, TripleQueryHandler tripleQueryHandler) {
        TripleQueryHandler tripleQueryHandler2;
        Triple triple = Triple.create((Node)node, (Node)node2, (Node)node3);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Registering handler for pattern: " + triple);
        }
        if ((tripleQueryHandler2 = QUERY_HANDLERS.put(triple, tripleQueryHandler)) != null && log.isLoggable(Level.SEVERE)) {
            log.severe("Existing handler found for pattern: " + triple);
        }
    }

    private static void registerQueryHandlers() {
        GraphQueryHandler.registerHandler(VAR, VAR, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return true;
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ModelExtractor modelExtractor = new ModelExtractor(knowledgeBase);
                modelExtractor.setSelector(ModelExtractor.StatementType.ALL_STATEMENTS);
                Graph graph = modelExtractor.extractModel().getGraph();
                return graph.find((TripleMatch)Triple.ANY);
            }
        });
        GraphQueryHandler.registerHandler(VAR, VAR, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node3);
                return knowledgeBase.isClass((ATerm)aTermAppl) || knowledgeBase.isProperty((ATerm)aTermAppl) || knowledgeBase.isIndividual((ATerm)aTermAppl);
            }

            @Override
            public ExtendedIterator<Triple> find(final KnowledgeBase knowledgeBase, final GraphLoader graphLoader, final Node node, Node node2, final Node node3) {
                NullIterator nullIterator = NullIterator.instance();
                if (!node3.isLiteral()) {
                    for (ExtendedIterator extendedIterator : BUILTIN_PREDICATES) {
                        nullIterator = nullIterator.andThen(GraphQueryHandler.findTriple(knowledgeBase, graphLoader, node, (Node)extendedIterator, node3));
                    }
                }
                ExtendedIterator extendedIterator = WrappedIterator.create((Iterator)new NestedIterator<ATermAppl, Triple>(knowledgeBase.getProperties()){

                    @Override
                    public Iterator<Triple> getInnerIterator(ATermAppl aTermAppl) {
                        Node node2 = JenaUtils.makeGraphNode(aTermAppl);
                        return GraphQueryHandler.findTriple(knowledgeBase, graphLoader, node, node2, node3);
                    }
                });
                return nullIterator.andThen((Iterator)extendedIterator);
            }
        });
        GraphQueryHandler.registerHandler(CONST, VAR, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node);
                return knowledgeBase.isClass((ATerm)aTermAppl) || knowledgeBase.isProperty((ATerm)aTermAppl) || knowledgeBase.isIndividual((ATerm)aTermAppl);
            }

            @Override
            public ExtendedIterator<Triple> find(final KnowledgeBase knowledgeBase, final GraphLoader graphLoader, final Node node, Node node2, final Node node3) {
                NullIterator nullIterator = NullIterator.instance();
                for (Node node4 : BUILTIN_PREDICATES) {
                    nullIterator = nullIterator.andThen(GraphQueryHandler.findTriple(knowledgeBase, graphLoader, node, node4, node3));
                }
                ExtendedIterator extendedIterator = WrappedIterator.create((Iterator)new NestedIterator<ATermAppl, Triple>(knowledgeBase.getProperties()){

                    @Override
                    public Iterator<Triple> getInnerIterator(ATermAppl aTermAppl) {
                        Node node2 = JenaUtils.makeGraphNode(aTermAppl);
                        return GraphQueryHandler.findTriple(knowledgeBase, graphLoader, node, node2, node3);
                    }
                });
                return nullIterator.andThen((Iterator)extendedIterator);
            }
        });
        GraphQueryHandler.registerHandler(CONST, VAR, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node);
                return knowledgeBase.isClass((ATerm)aTermAppl) || knowledgeBase.isProperty((ATerm)aTermAppl) || knowledgeBase.isIndividual((ATerm)aTermAppl);
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ExtendedIterator extendedIterator;
                block3: {
                    block2: {
                        extendedIterator = NullIterator.instance();
                        ATermAppl aTermAppl = graphLoader.node2term(node);
                        ATermAppl aTermAppl2 = graphLoader.node2term(node3);
                        if (!knowledgeBase.isIndividual((ATerm)aTermAppl) && !knowledgeBase.isIndividual((ATerm)aTermAppl2)) break block2;
                        if (!knowledgeBase.isIndividual((ATerm)aTermAppl)) break block3;
                        List<ATermAppl> list = knowledgeBase.getProperties(graphLoader.node2term(node), graphLoader.node2term(node3));
                        extendedIterator = this.propertyFiller(node, list, node3);
                        if (!knowledgeBase.isIndividual((ATerm)aTermAppl2)) break block3;
                        if (knowledgeBase.isSameAs(aTermAppl, aTermAppl2)) {
                            extendedIterator = extendedIterator.andThen((Iterator)new SingletonIterator((Object)Triple.create((Node)node, (Node)OWL.sameAs.asNode(), (Node)node3)));
                        }
                        if (!knowledgeBase.isDifferentFrom(aTermAppl, aTermAppl2)) break block3;
                        extendedIterator = extendedIterator.andThen((Iterator)new SingletonIterator((Object)Triple.create((Node)node, (Node)OWL.differentFrom.asNode(), (Node)node3)));
                        break block3;
                    }
                    for (Node node4 : BUILTIN_PREDICATES) {
                        extendedIterator = extendedIterator.andThen(GraphQueryHandler.findTriple(knowledgeBase, graphLoader, node, node4, node3));
                    }
                }
                return extendedIterator;
            }
        });
        GraphQueryHandler.registerHandler(VAR, CONST, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node2);
                if (!knowledgeBase.isProperty((ATerm)aTermAppl)) {
                    return false;
                }
                for (ATermAppl aTermAppl2 : knowledgeBase.getIndividuals()) {
                    if (!knowledgeBase.hasKnownPropertyValue(aTermAppl2, aTermAppl, null).isTrue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public ExtendedIterator<Triple> find(final KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, final Node node2, Node node3) {
                final ATermAppl aTermAppl = graphLoader.node2term(node2);
                return WrappedIterator.create((Iterator)new NestedIterator<ATermAppl, Triple>(knowledgeBase.getIndividuals()){

                    @Override
                    public Iterator<Triple> getInnerIterator(ATermAppl aTermAppl2) {
                        Node node = JenaUtils.makeGraphNode(aTermAppl2);
                        return this.objectFiller(node, node2, knowledgeBase.getPropertyValues(aTermAppl, aTermAppl2));
                    }
                });
            }
        });
        GraphQueryHandler.registerHandler(VAR, CONST, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl;
                ATermAppl aTermAppl2 = graphLoader.node2term(node2);
                return !knowledgeBase.getIndividualsWithProperty(aTermAppl2, aTermAppl = graphLoader.node2term(node3)).isEmpty();
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node2);
                ATermAppl aTermAppl2 = graphLoader.node2term(node3);
                return this.subjectFiller(knowledgeBase.getIndividualsWithProperty(aTermAppl, aTermAppl2), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, CONST, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node);
                ATermAppl aTermAppl2 = graphLoader.node2term(node2);
                return knowledgeBase.isIndividual((ATerm)aTermAppl) && knowledgeBase.hasPropertyValue(aTermAppl, aTermAppl2, null);
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node);
                ATermAppl aTermAppl2 = graphLoader.node2term(node2);
                return this.objectFiller(node, node2, knowledgeBase.getPropertyValues(aTermAppl2, aTermAppl));
            }
        });
        GraphQueryHandler.registerHandler(CONST, CONST, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node);
                ATermAppl aTermAppl2 = graphLoader.node2term(node2);
                ATermAppl aTermAppl3 = graphLoader.node2term(node3);
                return knowledgeBase.hasPropertyValue(aTermAppl, aTermAppl2, aTermAppl3);
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return true;
            }

            @Override
            public ExtendedIterator<Triple> find(final KnowledgeBase knowledgeBase, final GraphLoader graphLoader, final Node node, final Node node2, Node node3) {
                ExtendedIterator extendedIterator = WrappedIterator.create((Iterator)new NestedIterator<Node, Triple>(Arrays.asList(BUILTIN_TYPES)){

                    @Override
                    public Iterator<Triple> getInnerIterator(Node node3) {
                        return GraphQueryHandler.findTriple(knowledgeBase, graphLoader, node, node2, node3);
                    }
                });
                ExtendedIterator extendedIterator2 = WrappedIterator.create((Iterator)new NestedIterator<ATermAppl, Triple>(knowledgeBase.getAllClasses()){

                    @Override
                    public Iterator<Triple> getInnerIterator(ATermAppl aTermAppl) {
                        return this.subjectFiller(knowledgeBase.getInstances(aTermAppl), node2, JenaUtils.makeGraphResource(aTermAppl));
                    }
                });
                return extendedIterator.andThen((Iterator)extendedIterator2);
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.hasInstance((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectFiller(knowledgeBase.getInstances(graphLoader.node2term(node3)), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node);
                return knowledgeBase.isClass((ATerm)aTermAppl) || knowledgeBase.isProperty((ATerm)aTermAppl) || knowledgeBase.isIndividual((ATerm)aTermAppl);
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, final Node node, final Node node2, Node node3) {
                Object object;
                ATermAppl aTermAppl = graphLoader.node2term(node);
                if (knowledgeBase.isIndividual((ATerm)aTermAppl)) {
                    return this.objectSetFiller(node, node2, knowledgeBase.getTypes(aTermAppl));
                }
                ArrayList<Node> arrayList = new ArrayList<Node>();
                if (knowledgeBase.isClass((ATerm)aTermAppl)) {
                    arrayList.add(OWL.Class.asNode());
                } else if (knowledgeBase.isDatatype(aTermAppl)) {
                    arrayList.add(RDFS.Datatype.asNode());
                } else if (knowledgeBase.isObjectProperty((ATerm)aTermAppl)) {
                    object = knowledgeBase.getRole((ATerm)aTermAppl);
                    arrayList.add(OWL.ObjectProperty.asNode());
                    if (((Role)object).isFunctional()) {
                        arrayList.add(OWL.FunctionalProperty.asNode());
                    }
                    if (((Role)object).isInverseFunctional()) {
                        arrayList.add(OWL.InverseFunctionalProperty.asNode());
                    }
                    if (((Role)object).isTransitive()) {
                        arrayList.add(OWL.TransitiveProperty.asNode());
                    }
                    if (((Role)object).isSymmetric()) {
                        arrayList.add(OWL.SymmetricProperty.asNode());
                    }
                    if (((Role)object).isAsymmetric()) {
                        arrayList.add(OWL2.AsymmetricProperty.asNode());
                    }
                    if (((Role)object).isReflexive()) {
                        arrayList.add(OWL2.ReflexiveProperty.asNode());
                    }
                    if (((Role)object).isIrreflexive()) {
                        arrayList.add(OWL2.IrreflexiveProperty.asNode());
                    }
                } else if (knowledgeBase.isDatatypeProperty((ATerm)aTermAppl)) {
                    object = knowledgeBase.getRole((ATerm)aTermAppl);
                    arrayList.add(OWL.DatatypeProperty.asNode());
                    if (((Role)object).isFunctional()) {
                        arrayList.add(OWL.FunctionalProperty.asNode());
                    }
                    if (((Role)object).isInverseFunctional()) {
                        arrayList.add(OWL.InverseFunctionalProperty.asNode());
                    }
                } else if (knowledgeBase.isAnnotationProperty((ATerm)aTermAppl)) {
                    arrayList.add(OWL.AnnotationProperty.asNode());
                }
                object = new Map1<Node, Triple>(){

                    public Triple map1(Node node3) {
                        return Triple.create((Node)node, (Node)node2, (Node)node3);
                    }
                };
                return WrappedIterator.create(arrayList.iterator()).mapWith((Map1)object);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isType(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directRDFType, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return IteratorUtils.flatten(knowledgeBase.getTypes(aTermAppl, true).iterator());
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getIndividuals();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getIndividuals().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directRDFType, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getInstances(aTermAppl, true);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directRDFType, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isIndividual((ATerm)graphLoader.node2term(node));
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectSetFiller(node, node2, knowledgeBase.getTypes(graphLoader.node2term(node), true));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directRDFType, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.getInstances(graphLoader.node2term(node3), true).contains(graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.Class, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAllClasses();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, RDFS.Class, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAllClasses();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.Class, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, RDFS.Class, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, RDF.Property, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, RDF.Property, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.ObjectProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isObjectProperty((ATerm)graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.ObjectProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getObjectProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.DatatypeProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isDatatypeProperty((ATerm)graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.DatatypeProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getDataProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.AnnotationProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isAnnotationProperty((ATerm)graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.AnnotationProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAnnotationProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.TransitiveProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isTransitiveProperty(graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.TransitiveProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getTransitiveProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.SymmetricProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isSymmetricProperty(graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.SymmetricProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getSymmetricProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.FunctionalProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isFunctionalProperty(graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.FunctionalProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getFunctionalProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.InverseFunctionalProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isInverseFunctionalProperty(graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.InverseFunctionalProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getInverseFunctionalProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL2.ReflexiveProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isReflexiveProperty(graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL2.ReflexiveProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getReflexiveProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL2.IrreflexiveProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isIrreflexiveProperty(graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL2.IrreflexiveProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getIrreflexiveProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL2.AsymmetricProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isAsymmetricProperty(graphLoader.node2term(node));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL2.AsymmetricProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAsymmetricProperties();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.subClassOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)knowledgeBase.getSuperClasses(aTermAppl, false));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.subClassOf, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectSetFiller(knowledgeBase.getSubClasses(graphLoader.node2term(node3)), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.subClassOf, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectSetFiller(node, node2, knowledgeBase.getSuperClasses(graphLoader.node2term(node)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.subClassOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isSubClassOf(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directSubClassOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)knowledgeBase.getSuperClasses(aTermAppl, true));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directSubClassOf, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node3)) && !node3.equals((Object)OWL.Nothing.asNode());
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectSetFiller(knowledgeBase.getSubClasses(graphLoader.node2term(node3), true), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directSubClassOf, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node)) && !node3.equals((Object)OWL.Thing.asNode());
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectSetFiller(node, node2, knowledgeBase.getSuperClasses(graphLoader.node2term(node), true));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directSubClassOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.getSuperClasses(graphLoader.node2term(node), true).contains(knowledgeBase.getAllEquivalentClasses(graphLoader.node2term(node3)));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.equivalentClass, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getAllEquivalentClasses(aTermAppl).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.equivalentClass, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectFiller(knowledgeBase.getAllEquivalentClasses(graphLoader.node2term(node3)), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.equivalentClass, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectFiller(node, node2, knowledgeBase.getAllEquivalentClasses(graphLoader.node2term(node)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.equivalentClass, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isEquivalentClass(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.disjointWith, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)knowledgeBase.getDisjointClasses(aTermAppl));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.disjointWith, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectSetFiller(knowledgeBase.getDisjointClasses(graphLoader.node2term(node3)), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.disjointWith, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isClass((ATerm)graphLoader.node2term(node));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectSetFiller(node, node2, knowledgeBase.getDisjointClasses(graphLoader.node2term(node)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.disjointWith, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isDisjointClass(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.complementOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getComplements(aTermAppl).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.complementOf, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getComplements(aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.complementOf, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getComplements(aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.complementOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isComplement(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.subPropertyOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)knowledgeBase.getAllSuperProperties(aTermAppl));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.subPropertyOf, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectSetFiller(knowledgeBase.getAllSubProperties(graphLoader.node2term(node3)), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.subPropertyOf, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectSetFiller(node, node2, knowledgeBase.getAllSuperProperties(graphLoader.node2term(node)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.subPropertyOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isSubPropertyOf(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directSubPropertyOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)knowledgeBase.getSuperProperties(aTermAppl, true));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directSubPropertyOf, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectSetFiller(knowledgeBase.getSubProperties(graphLoader.node2term(node3), true), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directSubPropertyOf, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectSetFiller(node, node2, knowledgeBase.getSuperProperties(graphLoader.node2term(node), true));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directSubPropertyOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.getSuperProperties(graphLoader.node2term(node), true).contains(knowledgeBase.getAllEquivalentProperties(graphLoader.node2term(node3)));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.domain, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getDomains(aTermAppl).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.domain, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
                ATermAppl aTermAppl = graphLoader.node2term(node3);
                for (ATermAppl aTermAppl2 : knowledgeBase.getProperties()) {
                    if (!knowledgeBase.getDomains(aTermAppl2).contains(aTermAppl)) continue;
                    arrayList.add(aTermAppl2);
                }
                return this.subjectFiller(arrayList, node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.domain, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getDomains(aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.domain, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.hasDomain(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.range, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getRanges((ATerm)aTermAppl).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.range, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
                ATermAppl aTermAppl = graphLoader.node2term(node3);
                for (ATermAppl aTermAppl2 : knowledgeBase.getProperties()) {
                    if (!knowledgeBase.getRanges((ATerm)aTermAppl2).contains(aTermAppl)) continue;
                    arrayList.add(aTermAppl2);
                }
                return this.subjectFiller(arrayList, node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.range, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getRanges((ATerm)aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.range, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.hasRange(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.equivalentProperty, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getAllEquivalentProperties(aTermAppl).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.equivalentProperty, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node3));
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectFiller(knowledgeBase.getAllEquivalentProperties(graphLoader.node2term(node3)), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.equivalentProperty, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isProperty((ATerm)graphLoader.node2term(node));
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectFiller(node, node2, knowledgeBase.getAllEquivalentProperties(graphLoader.node2term(node)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.equivalentProperty, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isEquivalentProperty(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.inverseOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getInverses((ATerm)aTermAppl).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.inverseOf, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getInverses((ATerm)aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.inverseOf, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getInverses((ATerm)aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.inverseOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isInverse(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL2.propertyDisjointWith, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)knowledgeBase.getDisjointProperties(aTermAppl));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.getExpressivity().hasDisjointRoles();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL2.propertyDisjointWith, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getDisjointProperties(graphLoader.node2term(node3)).isEmpty();
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.subjectSetFiller(knowledgeBase.getDisjointProperties(graphLoader.node2term(node3)), node2, node3);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL2.propertyDisjointWith, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getDisjointProperties(graphLoader.node2term(node)).isEmpty();
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return this.objectSetFiller(node, node2, knowledgeBase.getDisjointProperties(graphLoader.node2term(node)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL2.propertyDisjointWith, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                ATermAppl aTermAppl = graphLoader.node2term(node);
                ATermAppl aTermAppl2 = graphLoader.node2term(node3);
                return (knowledgeBase.isObjectProperty((ATerm)aTermAppl) && knowledgeBase.isObjectProperty((ATerm)aTermAppl2) || knowledgeBase.isDatatypeProperty((ATerm)aTermAppl) && knowledgeBase.isDatatypeProperty((ATerm)aTermAppl2)) && knowledgeBase.isDisjointProperty(aTermAppl, aTermAppl2);
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.sameAs, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getAllSames(aTermAppl).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getIndividuals();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getIndividuals().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.sameAs, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getAllSames(aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.sameAs, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getAllSames(aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.sameAs, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isSameAs(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.differentFrom, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getDifferents(aTermAppl).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase knowledgeBase) {
                return knowledgeBase.getIndividuals();
            }

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return !knowledgeBase.getIndividuals().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.differentFrom, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getDifferents(aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.differentFrom, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
                return knowledgeBase.getDifferents(aTermAppl);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.differentFrom, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
                return knowledgeBase.isDifferentFrom(graphLoader.node2term(node), graphLoader.node2term(node3));
            }
        });
    }

    public static boolean isBuiltin(Node node) {
        return BUILTIN_KEYWORDS.contains(node);
    }

    public static Node normalize(Node node) {
        return node == VAR || node.isVariable() ? VAR : (GraphQueryHandler.isBuiltin(node) ? node : CONST);
    }

    public static ExtendedIterator<Triple> findTriple(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
        TripleQueryHandler tripleQueryHandler;
        Node node4 = GraphQueryHandler.normalize(node);
        Node node5 = GraphQueryHandler.normalize(node2);
        Node node6 = GraphQueryHandler.normalize(node3);
        if (node5 == VAR && node6 != VAR && node6 != CONST) {
            node2 = node5 = RDF.type.asNode();
        }
        if ((tripleQueryHandler = QUERY_HANDLERS.get(Triple.create((Node)node4, (Node)node5, (Node)node6))) == null && log.isLoggable(Level.WARNING)) {
            log.warning("No query handler found for " + node + " " + node2 + " " + node3);
        }
        return tripleQueryHandler == null ? NullIterator.instance() : tripleQueryHandler.find(knowledgeBase, graphLoader, node, node2, node3);
    }

    public static boolean containsTriple(KnowledgeBase knowledgeBase, GraphLoader graphLoader, Node node, Node node2, Node node3) {
        TripleQueryHandler tripleQueryHandler;
        Node node4 = GraphQueryHandler.normalize(node);
        Node node5 = GraphQueryHandler.normalize(node2);
        Node node6 = GraphQueryHandler.normalize(node3);
        if (node5 == VAR && node6 != VAR && node6 != CONST) {
            node2 = node5 = RDF.type.asNode();
        }
        if ((tripleQueryHandler = QUERY_HANDLERS.get(Triple.create((Node)node4, (Node)node5, (Node)node6))) == null && log.isLoggable(Level.WARNING)) {
            log.warning("No query handler found for " + node + " " + node2 + " " + node3);
        }
        return tripleQueryHandler != null && tripleQueryHandler.contains(knowledgeBase, graphLoader, node, node2, node3);
    }

    static {
        for (Node node : BUILTIN_PREDICATES) {
            BUILTIN_KEYWORDS.add(node);
        }
        for (Node node : BUILTIN_QUERY_PREDICATES) {
            BUILTIN_KEYWORDS.add(node);
        }
        for (Node node : BUILTIN_TYPES) {
            BUILTIN_KEYWORDS.add(node);
        }
        for (Node node : BUILTIN_QUERY_TYPES) {
            BUILTIN_KEYWORDS.add(node);
        }
        QUERY_HANDLERS = CollectionUtils.makeMap();
        GraphQueryHandler.registerQueryHandlers();
    }
}

