/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.parser;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.parser.QueryParser;
import com.clarkparsia.pellet.sparqldl.parser.SparqldlExtensionsVocabulary;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.BuiltinTerm;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.ATermUtils;

public class ARQParser
implements QueryParser {
    public static Logger log = Logger.getLogger(ARQParser.class.getName());
    private Set<Triple> triples;
    private Map<Node, ATerm> terms;
    private KnowledgeBase kb;
    private QuerySolution initialBinding;
    private boolean handleVariableSPO = true;

    public ARQParser() {
        this(true);
    }

    public ARQParser(boolean bl) {
        this.handleVariableSPO = bl;
    }

    @Override
    public Query parse(InputStream inputStream, KnowledgeBase knowledgeBase) {
        try {
            return this.parse(new InputStreamReader(inputStream), knowledgeBase);
        }
        catch (IOException iOException) {
            log.severe("Error creating a reader from the input stream.");
            throw new RuntimeException("Error creating a reader from the input stream.");
        }
    }

    @Override
    public Query parse(String string, KnowledgeBase knowledgeBase) {
        com.hp.hpl.jena.query.Query query = QueryFactory.create((String)string, (Syntax)Syntax.syntaxSPARQL);
        return this.parse(query, knowledgeBase);
    }

    private Query parse(Reader reader, KnowledgeBase knowledgeBase) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string).append("\n");
            string = bufferedReader.readLine();
        }
        return this.parse(stringBuffer.toString(), knowledgeBase);
    }

    @Override
    public Query parse(com.hp.hpl.jena.query.Query query, KnowledgeBase knowledgeBase) {
        ArrayList<Triple> arrayList;
        this.kb = knowledgeBase;
        if (query.isDescribeType()) {
            throw new UnsupportedQueryException("DESCRIBE queries cannot be answered with PelletQueryEngine");
        }
        Element element = query.getQueryPattern();
        if (!(element instanceof ElementGroup)) {
            throw new UnsupportedQueryException("ElementGroup was expected, but found '" + element.getClass() + "'.");
        }
        ElementGroup elementGroup = (ElementGroup)element;
        List list = elementGroup.getElements();
        Element element2 = (Element)list.get(0);
        if (list.size() != 1 || !(element2 instanceof ElementTriplesBlock) && !(element2 instanceof ElementPathBlock)) {
            throw new UnsupportedQueryException("Complex query patterns are not supported yet.");
        }
        if (element2 instanceof ElementPathBlock) {
            arrayList = new ArrayList();
            for (TriplePath triplePath : ((ElementPathBlock)element2).getPattern()) {
                if (!triplePath.isTriple()) {
                    throw new UnsupportedQueryException("Path expressions are not supported yet.");
                }
                arrayList.add(triplePath.asTriple());
            }
        } else {
            arrayList = ((ElementTriplesBlock)element2).getPattern().getList();
        }
        query.setResultVars();
        return this.parse(arrayList, query.getResultVars(), knowledgeBase, query.isDistinct());
    }

    private void initBuiltinTerms() {
        this.terms = new HashMap<Node, ATerm>();
        this.terms.put(OWL.Thing.asNode(), (ATerm)TermFactory.TOP);
        this.terms.put(OWL.Nothing.asNode(), (ATerm)TermFactory.BOTTOM);
        this.terms.put(OWL2.topObjectProperty.asNode(), (ATerm)TermFactory.TOP_OBJECT_PROPERTY);
        this.terms.put(OWL2.topDataProperty.asNode(), (ATerm)TermFactory.TOP_DATA_PROPERTY);
        this.terms.put(OWL2.bottomObjectProperty.asNode(), (ATerm)TermFactory.BOTTOM_OBJECT_PROPERTY);
        this.terms.put(OWL2.bottomDataProperty.asNode(), (ATerm)TermFactory.BOTTOM_DATA_PROPERTY);
    }

    public Query parse(BasicPattern basicPattern, Collection<?> collection, KnowledgeBase knowledgeBase, boolean bl) throws UnsupportedQueryException {
        return this.parse(basicPattern.getList(), collection, knowledgeBase, bl);
    }

    public Query parse(List<Triple> list, Collection<?> collection, KnowledgeBase knowledgeBase, boolean bl) throws UnsupportedQueryException {
        Node node;
        Node node2;
        Triple triple22;
        this.kb = knowledgeBase;
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>();
        this.initBuiltinTerms();
        this.triples = new LinkedHashSet<Triple>(this.resolveParameterization(list));
        QueryImpl queryImpl = new QueryImpl(knowledgeBase, bl);
        for (Triple triple22 : collection) {
            queryImpl.addResultVar(ATermUtils.makeVar((String)triple22));
        }
        for (Triple triple22 : new ArrayList<Triple>(this.triples)) {
            if (!this.triples.contains(triple22)) continue;
            Node node32 = triple22.getSubject();
            node2 = triple22.getPredicate();
            node = triple22.getObject();
            if (BuiltinTerm.isSyntax(node2) || BuiltinTerm.isSyntax(node)) continue;
            this.cache(node32);
            this.cache(node2);
            this.cache(node);
        }
        HashSet hashSet3 = new HashSet();
        if (this.triples.isEmpty()) {
            throw new UnsupportedQueryException("Empty BGT");
        }
        for (Triple triple : this.triples) {
            node2 = triple.getSubject();
            node = triple.getPredicate();
            Node node3 = triple.getObject();
            ATermAppl aTermAppl = (ATermAppl)this.terms.get(node2);
            ATermAppl aTermAppl2 = (ATermAppl)this.terms.get(node);
            ATermAppl aTermAppl3 = (ATermAppl)this.terms.get(node3);
            if (node.equals((Object)RDF.Nodes.type)) {
                if (node3.equals((Object)OWL.Class.asNode())) {
                    queryImpl.add(QueryAtomFactory.SubClassOfAtom(aTermAppl, TermFactory.TOP));
                    if (!ATermUtils.isVar(aTermAppl)) continue;
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                    if (!this.handleVariableSPO) continue;
                    hashSet.remove(aTermAppl);
                    hashSet2.add(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL2.NamedIndividual.asNode())) {
                    queryImpl.add(QueryAtomFactory.TypeAtom(aTermAppl, TermFactory.TOP));
                    if (!ATermUtils.isVar(aTermAppl)) continue;
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                    if (!this.handleVariableSPO) continue;
                    hashSet.remove(aTermAppl);
                    hashSet2.add(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL.ObjectProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.ObjectPropertyAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL.DatatypeProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.DatatypePropertyAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)RDF.Property.asNode())) {
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL.FunctionalProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.FunctionalAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL.InverseFunctionalProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.InverseFunctionalAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL.TransitiveProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.TransitiveAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL.SymmetricProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.SymmetricAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL2.AsymmetricProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.AsymmetricAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL2.ReflexiveProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.ReflexiveAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (node3.equals((Object)OWL2.IrreflexiveProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.IrreflexiveAtom(aTermAppl));
                    if (ATermUtils.isVar(aTermAppl)) {
                        this.ensureDistinguished(node2);
                        queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                        continue;
                    }
                    this.ensureTypedProperty(aTermAppl);
                    continue;
                }
                if (this.hasObject(node, RDF.type.asNode(), OWL.AnnotationProperty.asNode())) {
                    queryImpl.add(QueryAtomFactory.AnnotationAtom(aTermAppl, aTermAppl2, aTermAppl3));
                    if (ATermUtils.isVar(aTermAppl) || ATermUtils.isVar(aTermAppl2) || ATermUtils.isVar(aTermAppl3)) {
                        throw new UnsupportedQueryException("Variables in annotation atom are not supported.");
                    }
                    this.ensureTypedProperty(aTermAppl2);
                    continue;
                }
                queryImpl.add(QueryAtomFactory.TypeAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl3)) {
                    this.ensureDistinguished(node3);
                    queryImpl.addDistVar(aTermAppl3, Query.VarType.CLASS);
                } else if (!knowledgeBase.isClass((ATerm)aTermAppl3) && log.isLoggable(Level.FINE)) {
                    log.fine("Class " + aTermAppl3 + " used in the query is not defined in the KB.");
                }
                if (!ARQParser.isDistinguishedVariable(node2)) continue;
                queryImpl.addDistVar(aTermAppl, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (node.equals((Object)OWL.sameAs.asNode())) {
                queryImpl.add(QueryAtomFactory.SameAsAtom(aTermAppl, aTermAppl3));
                if (ARQParser.isDistinguishedVariable(node2)) {
                    queryImpl.addDistVar(aTermAppl, Query.VarType.INDIVIDUAL);
                }
                if (!ARQParser.isDistinguishedVariable(node3)) continue;
                queryImpl.addDistVar(aTermAppl3, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (node.equals((Object)OWL.differentFrom.asNode())) {
                queryImpl.add(QueryAtomFactory.DifferentFromAtom(aTermAppl, aTermAppl3));
                if (ARQParser.isDistinguishedVariable(node2)) {
                    queryImpl.addDistVar(aTermAppl, Query.VarType.INDIVIDUAL);
                }
                if (!ARQParser.isDistinguishedVariable(node3)) continue;
                queryImpl.addDistVar(aTermAppl3, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (node.equals((Object)RDFS.subClassOf.asNode())) {
                queryImpl.add(QueryAtomFactory.SubClassOfAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.CLASS);
                continue;
            }
            if (node.equals((Object)SparqldlExtensionsVocabulary.strictSubClassOf.asNode())) {
                queryImpl.add(QueryAtomFactory.StrictSubClassOfAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.CLASS);
                continue;
            }
            if (node.equals((Object)SparqldlExtensionsVocabulary.directSubClassOf.asNode())) {
                queryImpl.add(QueryAtomFactory.DirectSubClassOfAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.CLASS);
                continue;
            }
            if (node.equals((Object)OWL.equivalentClass.asNode())) {
                queryImpl.add(QueryAtomFactory.EquivalentClassAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.CLASS);
                continue;
            }
            if (node.equals((Object)OWL.disjointWith.asNode())) {
                queryImpl.add(QueryAtomFactory.DisjointWithAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.CLASS);
                continue;
            }
            if (node.equals((Object)OWL.complementOf.asNode())) {
                queryImpl.add(QueryAtomFactory.ComplementOfAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.CLASS);
                continue;
            }
            if (node.equals((Object)OWL2.propertyDisjointWith.asNode())) {
                this.ensureTypedProperty(aTermAppl);
                this.ensureTypedProperty(aTermAppl3);
                queryImpl.add(QueryAtomFactory.PropertyDisjointWithAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                hashSet.remove(aTermAppl3);
                hashSet2.add(aTermAppl3);
                continue;
            }
            if (node.equals((Object)RDFS.subPropertyOf.asNode())) {
                this.ensureTypedProperty(aTermAppl);
                this.ensureTypedProperty(aTermAppl3);
                queryImpl.add(QueryAtomFactory.SubPropertyOfAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                hashSet.remove(aTermAppl3);
                hashSet2.add(aTermAppl3);
                continue;
            }
            if (node.equals((Object)SparqldlExtensionsVocabulary.directSubPropertyOf.asNode())) {
                this.ensureTypedProperty(aTermAppl);
                this.ensureTypedProperty(aTermAppl3);
                queryImpl.add(QueryAtomFactory.DirectSubPropertyOfAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                hashSet.remove(aTermAppl3);
                hashSet2.add(aTermAppl3);
                continue;
            }
            if (node.equals((Object)SparqldlExtensionsVocabulary.strictSubPropertyOf.asNode())) {
                this.ensureTypedProperty(aTermAppl);
                this.ensureTypedProperty(aTermAppl3);
                queryImpl.add(QueryAtomFactory.StrictSubPropertyOfAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                hashSet.remove(aTermAppl3);
                hashSet2.add(aTermAppl3);
                continue;
            }
            if (node.equals((Object)OWL.equivalentProperty.asNode())) {
                this.ensureTypedProperty(aTermAppl);
                this.ensureTypedProperty(aTermAppl3);
                queryImpl.add(QueryAtomFactory.EquivalentPropertyAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                hashSet.remove(aTermAppl3);
                hashSet2.add(aTermAppl3);
                continue;
            }
            if (node.equals((Object)RDFS.domain.asNode())) {
                this.ensureTypedProperty(aTermAppl);
                queryImpl.add(QueryAtomFactory.DomainAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                continue;
            }
            if (node.equals((Object)RDFS.range.asNode())) {
                this.ensureTypedProperty(aTermAppl);
                queryImpl.add(QueryAtomFactory.RangeAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl, Query.VarType.CLASS);
                continue;
            }
            if (node.equals((Object)OWL.inverseOf.asNode())) {
                this.ensureTypedProperty(aTermAppl);
                this.ensureTypedProperty(aTermAppl3);
                queryImpl.add(QueryAtomFactory.InverseOfAtom(aTermAppl, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                hashSet.remove(aTermAppl3);
                hashSet2.add(aTermAppl3);
                continue;
            }
            if (node.equals((Object)SparqldlExtensionsVocabulary.directType.asNode())) {
                queryImpl.add(QueryAtomFactory.DirectTypeAtom(aTermAppl, aTermAppl3));
                if (ARQParser.isDistinguishedVariable(node2)) {
                    queryImpl.addDistVar(aTermAppl, Query.VarType.INDIVIDUAL);
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.CLASS);
                continue;
            }
            if (knowledgeBase.isAnnotationProperty((ATerm)aTermAppl2)) {
                if (!PelletOptions.USE_ANNOTATION_SUPPORT) {
                    throw new UnsupportedQueryException("Cannot answer annotation queries when PelletOptions.USE_ANNOTATION_SUPPORT is false!");
                }
                queryImpl.add(QueryAtomFactory.AnnotationAtom(aTermAppl, aTermAppl2, aTermAppl3));
                if (ATermUtils.isVar(aTermAppl)) {
                    this.ensureDistinguished(node2);
                    queryImpl.addDistVar(aTermAppl, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        hashSet.remove(aTermAppl);
                        hashSet2.add(aTermAppl);
                    }
                }
                if (!ATermUtils.isVar(aTermAppl3)) continue;
                this.ensureDistinguished(node3);
                queryImpl.addDistVar(aTermAppl3, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                hashSet.remove(aTermAppl3);
                hashSet2.add(aTermAppl3);
                continue;
            }
            if (aTermAppl == null || aTermAppl2 == null || aTermAppl3 == null) {
                throw new UnsupportedQueryException("Atom conversion incomplete for: " + triple);
            }
            this.ensureTypedProperty(aTermAppl2);
            queryImpl.add(QueryAtomFactory.PropertyValueAtom(aTermAppl, aTermAppl2, aTermAppl3));
            if (ATermUtils.isVar(aTermAppl2)) {
                this.ensureDistinguished(node);
                queryImpl.addDistVar(aTermAppl2, Query.VarType.PROPERTY);
                if (!hashSet2.contains(aTermAppl2)) {
                    hashSet.add(aTermAppl2);
                }
            }
            if (ARQParser.isDistinguishedVariable(node2)) {
                queryImpl.addDistVar(aTermAppl, Query.VarType.INDIVIDUAL);
            }
            if (!ARQParser.isDistinguishedVariable(node3)) continue;
            if (ATermUtils.isVar(aTermAppl2)) {
                hashSet3.add(aTermAppl3);
                continue;
            }
            if (knowledgeBase.isObjectProperty((ATerm)aTermAppl2)) {
                queryImpl.addDistVar(aTermAppl3, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (!knowledgeBase.isDatatypeProperty((ATerm)aTermAppl2)) continue;
            queryImpl.addDistVar(aTermAppl3, Query.VarType.LITERAL);
        }
        triple22 = hashSet3.iterator();
        while (triple22.hasNext()) {
            ATermAppl aTermAppl = (ATermAppl)triple22.next();
            if (!queryImpl.getDistVars().contains(aTermAppl)) {
                queryImpl.addDistVar(aTermAppl, Query.VarType.LITERAL);
            }
            queryImpl.addDistVar(aTermAppl, Query.VarType.INDIVIDUAL);
        }
        if (!this.handleVariableSPO) {
            return queryImpl;
        }
        if (hashSet.isEmpty()) {
            return queryImpl;
        }
        throw new UnsupportedQueryException("Queries with variable predicates are not supported (add the pattern {?p rdf:type owl:ObjectProperty} or {?p rdf:type owl:DatatypeProperty} to the query)");
    }

    public void setInitialBinding(QuerySolution querySolution) {
        this.initialBinding = querySolution;
    }

    private void ensureDistinguished(Node node) {
        this.ensureDistinguished(node, "Non-distinguished variables in class and predicate positions are not supported : ");
    }

    private void ensureDistinguished(Node node, String string) {
        if (!ARQParser.isDistinguishedVariable(node)) {
            throw new UnsupportedQueryException(string + node);
        }
    }

    private void ensureTypedProperty(ATermAppl aTermAppl) {
        if (ATermUtils.isVar(aTermAppl)) {
            return;
        }
        Role role = this.kb.getRole((ATerm)aTermAppl);
        if (role == null) {
            throw new UnsupportedQueryException("Unknown role: " + aTermAppl);
        }
        if (role.isUntypedRole()) {
            throw new UnsupportedQueryException("Untyped role: " + aTermAppl);
        }
    }

    public static boolean isDistinguishedVariable(Node node) {
        return Var.isVar((Node)node) && (Var.isNamedVar((Node)node) || PelletOptions.TREAT_ALL_VARS_DISTINGUISHED);
    }

    private Node getObject(Node node, Node node2) {
        Iterator<Triple> iterator = this.triples.iterator();
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            if (!node.equals((Object)triple.getSubject()) || !node2.equals((Object)triple.getPredicate())) continue;
            iterator.remove();
            return triple.getObject();
        }
        return null;
    }

    private boolean hasObject(Node node, Node node2) {
        for (Triple triple : this.triples) {
            if (!node.equals((Object)triple.getSubject()) || !node2.equals((Object)triple.getPredicate())) continue;
            return true;
        }
        return false;
    }

    private boolean hasObject(Node node, Node node2, Node node3) {
        Iterator<Triple> iterator = this.triples.iterator();
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            if (!node.equals((Object)triple.getSubject()) || !node2.equals((Object)triple.getPredicate())) continue;
            iterator.remove();
            if (node3.equals((Object)triple.getObject())) {
                return true;
            }
            throw new UnsupportedQueryException("Expecting rdf:type " + node3 + " but found rdf:type " + triple.getObject());
        }
        return false;
    }

    private ATermList createList(Node node) {
        if (node.equals((Object)RDF.nil.asNode())) {
            return ATermUtils.EMPTY_LIST;
        }
        if (this.terms.containsKey(node)) {
            return (ATermList)this.terms.get(node);
        }
        this.hasObject(node, RDF.type.asNode(), RDF.List.asNode());
        Node node2 = this.getObject(node, RDF.first.asNode());
        Node node3 = this.getObject(node, RDF.rest.asNode());
        if (node2 == null || node3 == null) {
            throw new UnsupportedQueryException("Invalid list structure: List " + node + " does not have a " + (node2 == null ? "rdf:first" : "rdf:rest") + " property.");
        }
        ATermList aTermList = ATermUtils.makeList((ATerm)this.node2term(node2), this.createList(node3));
        this.terms.put(node, (ATerm)aTermList);
        return aTermList;
    }

    private ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        ATermAppl aTermAppl = ATermUtils.TOP;
        this.hasObject(node, RDF.type.asNode(), OWL.Restriction.asNode());
        Node node2 = this.getObject(node, OWL.onProperty.asNode());
        if (node2 == null) {
            return aTermAppl;
        }
        ATermAppl aTermAppl2 = this.node2term(node2);
        if (!this.kb.isProperty((ATerm)aTermAppl2)) {
            throw new UnsupportedQueryException("Property " + aTermAppl2 + " is not present in KB.");
        }
        Node node3 = null;
        node3 = this.getObject(node, OWL.hasValue.asNode());
        if (node3 != null) {
            if (PelletOptions.USE_PSEUDO_NOMINALS) {
                if (node3.isLiteral()) {
                    aTermAppl = ATermUtils.makeMin((ATerm)aTermAppl2, 1, (ATerm)ATermUtils.TOP_LIT);
                } else {
                    ATermAppl aTermAppl3 = ATermUtils.makeTermAppl(node3.getURI());
                    if (!this.kb.isIndividual((ATerm)aTermAppl3)) {
                        throw new UnsupportedQueryException("Individual " + aTermAppl3 + " is not present in KB.");
                    }
                    ATermAppl aTermAppl4 = ATermUtils.makeTermAppl(node3.getURI() + "_nom");
                    aTermAppl = ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)aTermAppl4);
                }
            } else {
                ATermAppl aTermAppl5 = this.node2term(node3);
                aTermAppl = ATermUtils.makeHasValue((ATerm)aTermAppl2, (ATerm)aTermAppl5);
            }
        } else {
            node3 = this.getObject(node, OWL2.hasSelf.asNode());
            if (node3 != null) {
                ATermAppl aTermAppl6 = this.node2term(node3);
                if (ATermUtils.isVar(aTermAppl6)) {
                    throw new UnsupportedQueryException("Variables not supported in hasSelf restriction");
                }
                aTermAppl = ATermUtils.makeSelf(aTermAppl2);
            } else {
                node3 = this.getObject(node, OWL.allValuesFrom.asNode());
                if (node3 != null) {
                    ATermAppl aTermAppl7 = this.node2term(node3);
                    if (ATermUtils.isVar(aTermAppl7)) {
                        throw new UnsupportedQueryException("Variables not supported in allValuesFrom restriction");
                    }
                    aTermAppl = ATermUtils.makeAllValues((ATerm)aTermAppl2, (ATerm)aTermAppl7);
                } else {
                    node3 = this.getObject(node, OWL.someValuesFrom.asNode());
                    if (node3 != null) {
                        ATermAppl aTermAppl8 = this.node2term(node3);
                        if (ATermUtils.isVar(aTermAppl8)) {
                            throw new UnsupportedQueryException("Variables not supported in someValuesFrom restriction");
                        }
                        aTermAppl = ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)aTermAppl8);
                    } else {
                        node3 = this.getObject(node, OWL.minCardinality.asNode());
                        if (node3 != null) {
                            aTermAppl = this.createCardinalityRestriction(node, OWL.minCardinality.asNode(), aTermAppl2, node3);
                        } else {
                            node3 = this.getObject(node, OWL2.minQualifiedCardinality.asNode());
                            if (node3 != null) {
                                aTermAppl = this.createCardinalityRestriction(node, OWL2.minQualifiedCardinality.asNode(), aTermAppl2, node3);
                            } else {
                                node3 = this.getObject(node, OWL.maxCardinality.asNode());
                                if (node3 != null) {
                                    aTermAppl = this.createCardinalityRestriction(node, OWL.maxCardinality.asNode(), aTermAppl2, node3);
                                } else {
                                    node3 = this.getObject(node, OWL2.maxQualifiedCardinality.asNode());
                                    if (node3 != null) {
                                        aTermAppl = this.createCardinalityRestriction(node, OWL2.maxQualifiedCardinality.asNode(), aTermAppl2, node3);
                                    } else {
                                        node3 = this.getObject(node, OWL.cardinality.asNode());
                                        if (node3 != null) {
                                            aTermAppl = this.createCardinalityRestriction(node, OWL.cardinality.asNode(), aTermAppl2, node3);
                                        } else {
                                            node3 = this.getObject(node, OWL2.qualifiedCardinality.asNode());
                                            if (node3 != null) {
                                                aTermAppl = this.createCardinalityRestriction(node, OWL2.qualifiedCardinality.asNode(), aTermAppl2, node3);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return aTermAppl;
    }

    private ATermAppl createCardinalityRestriction(Node node, Node node2, ATermAppl aTermAppl, Node node3) throws UnsupportedQueryException {
        try {
            ATermAppl aTermAppl2 = null;
            Node node4 = null;
            node4 = this.getObject(node, OWL2.onClass.asNode());
            if (node4 != null) {
                if (node4.isVariable()) {
                    throw new UnsupportedQueryException("Variables not allowed in cardinality qualification");
                }
                if (!this.kb.isObjectProperty((ATerm)aTermAppl)) {
                    return null;
                }
                aTermAppl2 = this.node2term(node4);
            } else {
                node4 = this.getObject(node, OWL2.onDataRange.asNode());
                if (node4 != null) {
                    if (node4.isVariable()) {
                        throw new UnsupportedQueryException("Variables not allowed in cardinality qualification");
                    }
                    if (!this.kb.isDatatypeProperty((ATerm)aTermAppl)) {
                        return null;
                    }
                    aTermAppl2 = this.node2term(node4);
                } else {
                    PropertyType propertyType = this.kb.getPropertyType((ATerm)aTermAppl);
                    aTermAppl2 = propertyType == PropertyType.OBJECT ? ATermUtils.TOP : (propertyType == PropertyType.DATATYPE ? ATermUtils.TOP_LIT : ATermUtils.TOP);
                }
            }
            int n = Integer.parseInt(node3.getLiteralLexicalForm());
            if (node2.equals((Object)OWL.minCardinality.asNode()) || node2.equals((Object)OWL2.minQualifiedCardinality.asNode())) {
                return ATermUtils.makeMin((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
            }
            if (node2.equals((Object)OWL.maxCardinality.asNode()) || node2.equals((Object)OWL2.maxQualifiedCardinality.asNode())) {
                return ATermUtils.makeMax((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
            }
            return ATermUtils.makeCard((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Invalid cardinality", exception);
            return null;
        }
    }

    private ATermAppl node2term(Node node) {
        if (!this.terms.containsKey(node)) {
            this.cache(node);
        }
        return (ATermAppl)this.terms.get(node);
    }

    private void cache(Node node) {
        if (this.terms.containsKey(node) || BuiltinTerm.isBuiltin(node)) {
            return;
        }
        ATermAppl aTermAppl = null;
        if (node.isLiteral()) {
            aTermAppl = JenaUtils.makeLiteral(node.getLiteral());
        } else if (this.hasObject(node, OWL.onProperty.asNode())) {
            aTermAppl = this.createRestriction(node);
            this.terms.put(node, (ATerm)aTermAppl);
        } else if (node.isBlank() || node.isVariable()) {
            Node node2 = null;
            node2 = this.getObject(node, OWL.intersectionOf.asNode());
            if (node2 != null) {
                ATermList aTermList = this.createList(node2);
                this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                aTermAppl = ATermUtils.makeAnd(aTermList);
            } else {
                node2 = this.getObject(node, OWL.unionOf.asNode());
                if (node2 != null) {
                    ATermList aTermList = this.createList(node2);
                    this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                    aTermAppl = ATermUtils.makeOr(aTermList);
                } else {
                    node2 = this.getObject(node, OWL.oneOf.asNode());
                    if (node2 != null) {
                        ATermList aTermList = this.createList(node2);
                        this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                        ATermList aTermList2 = ATermUtils.EMPTY_LIST;
                        ATermList aTermList3 = aTermList;
                        while (!aTermList3.isEmpty()) {
                            ATermAppl aTermAppl2;
                            ATermAppl aTermAppl3 = (ATermAppl)aTermList3.getFirst();
                            if (PelletOptions.USE_PSEUDO_NOMINALS) {
                                aTermAppl2 = ATermUtils.makeTermAppl(aTermAppl3.getName() + "_nominal");
                                aTermList2 = aTermList2.insert((ATerm)aTermAppl2);
                            } else {
                                aTermAppl2 = ATermUtils.makeValue((ATerm)aTermAppl3);
                                aTermList2 = aTermList2.insert((ATerm)aTermAppl2);
                            }
                            aTermList3 = aTermList3.getNext();
                        }
                        aTermAppl = ATermUtils.makeOr(aTermList2);
                    } else if (Var.isBlankNodeVar((Node)node) && (node2 = this.getObject(node, OWL.complementOf.asNode())) != null) {
                        ATermAppl aTermAppl4 = this.node2term(node2);
                        this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                        aTermAppl = ATermUtils.makeNot((ATerm)aTermAppl4);
                    } else if (node.isVariable()) {
                        aTermAppl = ATermUtils.makeVar(node.getName());
                    } else {
                        node2 = this.getObject(node, OWL.complementOf.asNode());
                        if (node2 != null) {
                            log.info("Blank nodes in class variable positions are not supported");
                        }
                        aTermAppl = ATermUtils.makeBnode(node.getBlankNodeId().toString());
                    }
                }
            }
        } else {
            String string = node.getURI();
            aTermAppl = ATermUtils.makeTermAppl(string);
        }
        this.terms.put(node, (ATerm)aTermAppl);
    }

    private List<Triple> resolveParameterization(List<?> list) {
        if (list == null) {
            throw new NullPointerException("The set of triples cannot be null");
        }
        if (this.initialBinding == null) {
            this.initialBinding = new QuerySolutionMap();
        }
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        for (Triple triple : list.toArray(new Triple[list.size()])) {
            if (!list.contains(triple)) continue;
            Node node = this.resolveParameterization(triple.getSubject());
            Node node2 = this.resolveParameterization(triple.getPredicate());
            Node node3 = this.resolveParameterization(triple.getObject());
            arrayList.add(Triple.create((Node)node, (Node)node2, (Node)node3));
        }
        return arrayList;
    }

    private Node resolveParameterization(Node node) {
        if (node == null) {
            throw new NullPointerException("Node is null");
        }
        if (this.initialBinding == null) {
            throw new NullPointerException("Initial binding is null");
        }
        if (node.isConcrete()) {
            return node;
        }
        RDFNode rDFNode = this.initialBinding.get(node.getName());
        if (rDFNode == null) {
            return node;
        }
        return rDFNode.asNode();
    }
}

