/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tbox.impl.TBoxExpImpl;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.tbox.impl.TgBox;
import org.mindswap.pellet.tbox.impl.TuBox;
import org.mindswap.pellet.utils.ATermUtils;

public class RuleAbsorber {
    public static final Logger log = TgBox.log;
    public static final Map<ATermAppl, String> FACETS = new HashMap<ATermAppl, String>();
    private KnowledgeBase kb;
    private TuBox Tu;

    public RuleAbsorber(TBoxExpImpl tBoxExpImpl) {
        this.kb = tBoxExpImpl.getKB();
        this.Tu = tBoxExpImpl.Tu;
    }

    public boolean absorbRule(Set<ATermAppl> set, Set<ATermAppl> set2) {
        Object object3;
        Object object2;
        int n = 0;
        int n2 = 0;
        ATermAppl aTermAppl = null;
        for (ATermAppl aTermAppl2 : set) {
            if (ATermUtils.isPrimitive(aTermAppl2)) {
                object2 = this.Tu.getTD((ATerm)aTermAppl2);
                if (object2 != null && !((TermDefinition)object2).getEqClassAxioms().isEmpty()) continue;
                ++n2;
                continue;
            }
            if (ATermUtils.isSomeValues(aTermAppl2)) {
                ++n;
                continue;
            }
            if (!ATermUtils.isNot(aTermAppl2)) continue;
            aTermAppl = aTermAppl2;
        }
        if (aTermAppl == null || n == 0 && n2 < 2) {
            return false;
        }
        set.remove(aTermAppl);
        AtomIVariable atomIVariable = new AtomIVariable("var");
        int n3 = 0;
        object2 = new ArrayList();
        for (Object object3 : set) {
            n3 = this.processClass(atomIVariable, (ATermAppl)object3, (List<RuleAtom>)object2, n3);
        }
        ArrayList arrayList = new ArrayList();
        this.processClass(atomIVariable, ATermUtils.negate(aTermAppl), arrayList, 1);
        object3 = new Rule(arrayList, (Collection<? extends RuleAtom>)object2, set2);
        this.kb.addRule((Rule)object3);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Absorbed rule: " + object3);
        }
        return true;
    }

    protected int processClass(AtomIObject atomIObject, ATermAppl aTermAppl, List<RuleAtom> list, int n) {
        AFun aFun = aTermAppl.getAFun();
        if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                n = this.processClass(atomIObject, aTermAppl2, list, n);
                aTermList = aTermList.getNext();
            }
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
            if (aTermAppl4.getAFun().equals(ATermUtils.VALUEFUN)) {
                ATermAppl aTermAppl5 = (ATermAppl)aTermAppl4.getArgument(0);
                if (this.kb.isDatatypeProperty((ATerm)aTermAppl3)) {
                    AtomDConstant atomDConstant = new AtomDConstant(aTermAppl5);
                    DatavaluedPropertyAtom datavaluedPropertyAtom = new DatavaluedPropertyAtom(aTermAppl3, atomIObject, atomDConstant);
                    list.add(datavaluedPropertyAtom);
                } else {
                    AtomIConstant atomIConstant = new AtomIConstant(aTermAppl5);
                    IndividualPropertyAtom individualPropertyAtom = new IndividualPropertyAtom(aTermAppl3, atomIObject, atomIConstant);
                    list.add(individualPropertyAtom);
                }
            } else {
                ++n;
                if (this.kb.isDatatypeProperty((ATerm)aTermAppl3)) {
                    AtomDVariable atomDVariable = new AtomDVariable("var" + n);
                    DatavaluedPropertyAtom datavaluedPropertyAtom = new DatavaluedPropertyAtom(aTermAppl3, atomIObject, atomDVariable);
                    list.add(datavaluedPropertyAtom);
                    this.processDatatype(atomDVariable, aTermAppl4, list);
                } else {
                    AtomIVariable atomIVariable = new AtomIVariable("var" + n);
                    IndividualPropertyAtom individualPropertyAtom = new IndividualPropertyAtom(aTermAppl3, atomIObject, atomIVariable);
                    list.add(individualPropertyAtom);
                    n = this.processClass(atomIVariable, aTermAppl4, list, n);
                }
            }
        } else if (!aTermAppl.equals(ATermUtils.TOP)) {
            list.add(new ClassAtom(aTermAppl, atomIObject));
        }
        return n;
    }

    protected void processDatatype(AtomDObject atomDObject, ATermAppl aTermAppl, List<RuleAtom> list) {
        AFun aFun = aTermAppl.getAFun();
        if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                this.processDatatype(atomDObject, aTermAppl2, list);
                aTermList = aTermList.getNext();
            }
        } else if (aFun.equals(ATermUtils.RESTRDATATYPEFUN)) {
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
            list.add(new DataRangeAtom(aTermAppl3, atomDObject));
            ATermList aTermList = (ATermList)aTermAppl.getArgument(1);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl4 = (ATermAppl)aTermList.getFirst();
                ATermAppl aTermAppl5 = (ATermAppl)aTermAppl4.getArgument(0);
                String string = FACETS.get(aTermAppl5);
                if (string == null) {
                    list.add(new DataRangeAtom(aTermAppl, atomDObject));
                    return;
                }
                ATermAppl aTermAppl6 = (ATermAppl)aTermAppl4.getArgument(1);
                list.add(new BuiltInAtom(string, atomDObject, new AtomDConstant(aTermAppl6)));
                aTermList = aTermList.getNext();
            }
        } else {
            list.add(new DataRangeAtom(aTermAppl, atomDObject));
        }
    }

    static {
        FACETS.put(Facet.XSD.MIN_INCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#greaterThanOrEqual");
        FACETS.put(Facet.XSD.MIN_EXCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#greaterThan");
        FACETS.put(Facet.XSD.MAX_INCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#lessThanOrEqual");
        FACETS.put(Facet.XSD.MAX_EXCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#lessThan");
    }
}

