/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class SomeValuesRule
extends AbstractTableauRule {
    public SomeValuesRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.EXISTENTIAL, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual individual) {
        if (!individual.canApply(2)) {
            return;
        }
        List<ATermAppl> list = individual.getTypes(2);
        int n = list.size();
        for (int i = individual.applyNext[2]; i < n; ++i) {
            ATermAppl aTermAppl = list.get(i);
            this.applySomeValuesRule(individual, aTermAppl);
            if (!this.strategy.getABox().isClosed() && !individual.isPruned()) continue;
            return;
        }
        individual.applyNext[2] = n;
    }

    protected void applySomeValuesRule(Individual individual, ATermAppl aTermAppl) {
        Object object;
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(0);
        ATermAppl aTermAppl4 = (ATermAppl)aTermAppl2.getArgument(1);
        DependencySet dependencySet = individual.getDepends((ATerm)aTermAppl);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && dependencySet == null) {
            return;
        }
        aTermAppl4 = ATermUtils.negate(aTermAppl4);
        if (aTermAppl3.equals(ATermUtils.TOP_OBJECT_PROPERTY)) {
            if (ATermUtils.isNominal(aTermAppl4)) {
                return;
            }
            for (Node node : this.strategy.getABox().getNodes()) {
                if (!node.isIndividual() || node.isPruned() || !node.hasType((ATerm)aTermAppl4)) continue;
                return;
            }
            Individual individual2 = this.strategy.createFreshIndividual(individual, dependencySet);
            this.strategy.addType(individual2, aTermAppl4, dependencySet);
            return;
        }
        Role role = this.strategy.getABox().getRole((ATerm)aTermAppl3);
        boolean bl = false;
        boolean bl2 = individual.isBlockable();
        Node node = null;
        Edge edge2 = null;
        EdgeList edgeList = individual.getRNeighborEdges(role);
        for (Edge edge2 : edgeList) {
            node = edge2.getNeighbor(individual);
            if (PelletOptions.USE_COMPLETION_QUEUE && node.isPruned()) {
                node = null;
                continue;
            }
            if (!node.hasType((ATerm)aTermAppl4) || !(bl = bl2 || node.isLiteral() || !this.strategy.getBlocking().isBlocked((Individual)node))) continue;
        }
        if (bl) {
            return;
        }
        if (role.isDatatypeRole()) {
            object = (Literal)node;
            if (ATermUtils.isNominal(aTermAppl4) && !PelletOptions.USE_PSEUDO_NOMINALS) {
                ATermAppl aTermAppl5;
                this.strategy.getABox().copyOnWrite();
                ATermAppl aTermAppl6 = (ATermAppl)aTermAppl4.getArgument(0);
                if (aTermAppl6.getArgument(2).equals((Object)ATermUtils.NO_DATATYPE)) {
                    aTermAppl5 = aTermAppl6;
                } else {
                    try {
                        aTermAppl5 = this.strategy.getABox().getDatatypeReasoner().getCanonicalRepresentation(aTermAppl6);
                    }
                    catch (InvalidLiteralException invalidLiteralException) {
                        String string = "Invalid literal encountered in nominal when attempting to apply some values rule: " + invalidLiteralException.getMessage();
                        throw new InternalReasonerException(string, invalidLiteralException);
                    }
                    catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
                        String string = "Unrecognized datatype for literal encountered in nominal when attempting to apply some values rule: " + unrecognizedDatatypeException.getMessage();
                        throw new InternalReasonerException(string, unrecognizedDatatypeException);
                    }
                }
                object = this.strategy.getABox().addLiteral(aTermAppl5);
            } else {
                if (!role.isFunctional() || object == null) {
                    object = this.strategy.getABox().addLiteral(dependencySet);
                } else {
                    dependencySet = dependencySet.union(role.getExplainFunctional(), this.strategy.getABox().doExplanation());
                    dependencySet = dependencySet.union(edge2.getDepends(), this.strategy.getABox().doExplanation());
                }
                this.strategy.addType((Node)object, aTermAppl4, dependencySet);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("SOME: " + individual + " -> " + aTermAppl3 + " -> " + object + " : " + ATermUtils.toString(aTermAppl4) + " - " + dependencySet);
            }
            this.strategy.addEdge(individual, role, (Node)object, dependencySet);
        } else if (ATermUtils.isNominal(aTermAppl4) && !PelletOptions.USE_PSEUDO_NOMINALS) {
            this.strategy.getABox().copyOnWrite();
            object = (ATermAppl)aTermAppl4.getArgument(0);
            node = this.strategy.getABox().getIndividual((ATerm)object);
            if (log.isLoggable(Level.FINE)) {
                log.fine("VAL : " + individual + " -> " + ATermUtils.toString(aTermAppl3) + " -> " + node + " - " + dependencySet);
            }
            if (node == null) {
                if (ATermUtils.isAnonNominal((ATermAppl)object)) {
                    node = this.strategy.getABox().addIndividual((ATermAppl)object, dependencySet);
                } else {
                    if (ATermUtils.isLiteral((ATermAppl)object)) {
                        throw new InternalReasonerException("Object Property " + role + " is used with a hasValue restriction " + "where the value is a literal: " + ATermUtils.toString((ATermAppl)object));
                    }
                    throw new InternalReasonerException("Nominal " + aTermAppl4 + " is not found in the KB!");
                }
            }
            if (node.isMerged()) {
                dependencySet = dependencySet.union(node.getMergeDependency(true), this.strategy.getABox().doExplanation());
                node = node.getSame();
            }
            this.strategy.addEdge(individual, role, node, dependencySet);
        } else {
            DependencySet dependencySet2;
            boolean bl3 = false;
            boolean bl4 = false;
            DependencySet dependencySet3 = dependencySet2 = role.isFunctional() ? role.getExplainFunctional() : individual.hasMax1(role);
            if (dependencySet2 != null) {
                dependencySet = dependencySet.union(dependencySet2, this.strategy.getABox().doExplanation());
                if (edge2 != null) {
                    bl3 = true;
                    bl4 = true;
                } else {
                    Set<Role> set = role.isFunctional() ? role.getFunctionalSupers() : role.getSubRoles();
                    for (Role role2 : set) {
                        edgeList = individual.getRNeighborEdges(role2);
                        if (edgeList.isEmpty()) continue;
                        if (bl3) {
                            DependencySet dependencySet4 = DependencySet.INDEPENDENT;
                            if (PelletOptions.USE_TRACING) {
                                dependencySet4 = role.isFunctional() ? role.getExplainSuper((ATerm)role2.getName()) : role.getExplainSub((ATerm)role2.getName());
                            }
                            Edge edge3 = edgeList.edgeAt(0);
                            Node node2 = edge3.getNeighbor(individual);
                            DependencySet dependencySet5 = dependencySet.union(edge2.getDepends(), this.strategy.getABox().doExplanation()).union(edge3.getDepends(), this.strategy.getABox().doExplanation()).union(dependencySet4, this.strategy.getABox().doExplanation());
                            this.strategy.mergeTo(node, node2, dependencySet5);
                            continue;
                        }
                        bl3 = true;
                        edge2 = edgeList.edgeAt(0);
                        node = edge2.getNeighbor(individual);
                    }
                    if (node != null) {
                        node = node.getSame();
                    }
                }
            }
            if (bl3) {
                dependencySet = dependencySet.union(edge2.getDepends(), this.strategy.getABox().doExplanation());
            } else {
                node = this.strategy.createFreshIndividual(individual, dependencySet);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("SOME: " + individual + " -> " + role + " -> " + node + " : " + ATermUtils.toString(aTermAppl4) + (bl3 ? "" : " (*)") + " - " + dependencySet);
            }
            this.strategy.addType(node, aTermAppl4, dependencySet);
            if (!bl4) {
                if (individual.isBlockable() && node.isConceptRoot()) {
                    this.strategy.addEdge((Individual)node, role.getInverse(), individual, dependencySet);
                } else {
                    this.strategy.addEdge(individual, role, node, dependencySet);
                }
            }
        }
    }
}

