/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.OutputStream;
import java.net.URI;

public class RDFModelWriter {
    private static final String ANON_URI = "#anon";
    private static final URI TMP_URI = URI.create("tag:clarkparsia.com,2008:pellint:tmp");

    private static String toString(RDFNode rDFNode) {
        if (rDFNode.isLiteral()) {
            return ((Literal)rDFNode).getLexicalForm();
        }
        if (rDFNode.isAnon()) {
            return ANON_URI + rDFNode.asNode().getBlankNodeLabel();
        }
        return ((Resource)rDFNode).getURI();
    }

    public void write(OutputStream outputStream, RDFModel rDFModel) {
        Model model = ModelFactory.createDefaultModel();
        for (Statement statement : rDFModel.getStatements()) {
            model.add(statement);
        }
        model.write(outputStream);
    }
}

