/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.AlphaIndex;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.AlphaStore;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import com.clarkparsia.pellet.rules.rete.Node;
import com.clarkparsia.pellet.rules.rete.Rule;
import com.clarkparsia.pellet.rules.rete.RuleNode;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class Compiler {
    public static final ATermAppl DIFF_FROM;
    public static final TermTuple EMPTY_TUPLE;
    public static final Fact EMPTY_FACT;
    public static final int OBJ = 2;
    public static final int PRED = 0;
    public static final ATermAppl SAME_AS;
    public static final int SUBJ = 1;
    public static final ATermAppl TYPE;
    ABox abox;
    AlphaIndex alphaIndex;
    Interpreter interpreter;

    public Compiler(Interpreter interpreter, ABox aBox) {
        this.abox = aBox;
        this.interpreter = interpreter;
        this.alphaIndex = new AlphaIndex();
    }

    public boolean addDifferents(Individual individual) {
        boolean bl = false;
        for (org.mindswap.pellet.Node node : individual.getDifferents()) {
            if (!node.isNamedIndividual() || node.isPruned()) continue;
            bl |= this.interpreter.addFact(this.createDifferent(individual, node, individual.getDifferenceDependency(node)));
        }
        return bl;
    }

    public boolean addFact(Edge edge) {
        Individual individual = edge.getFrom();
        org.mindswap.pellet.Node node = edge.getTo().getSame();
        if (!node.isRootNominal() || node.isPruned()) {
            return false;
        }
        DependencySet dependencySet = edge.getDepends();
        Role role = edge.getRole();
        boolean bl = this.addFact(role, individual, node, dependencySet);
        if (role.isObjectRole()) {
            bl |= this.addFact(role.getInverse(), (Individual)node, individual, dependencySet);
        }
        return bl;
    }

    private boolean addFact(Role role, Individual individual, org.mindswap.pellet.Node node, DependencySet dependencySet) {
        boolean bl = false;
        for (Role role2 : role.getSuperRoles()) {
            bl |= this.interpreter.addFact(this.createFact(role2.getName(), individual, node, dependencySet.union(role.getExplainSuper((ATerm)role2.getName()), this.abox.doExplanation())));
        }
        return bl;
    }

    public boolean addFact(Individual individual, ATermAppl aTermAppl, DependencySet dependencySet) {
        boolean bl = false;
        return bl |= this.interpreter.addFact(this.createFact(individual, aTermAppl, dependencySet));
    }

    public void compile(Rule rule, Set<ATermAppl> set) {
        Node node;
        AlphaStore alphaStore = new AlphaStore();
        for (TermTuple object : rule.getBody()) {
            node = this.makeAlphaNode(object);
            alphaStore.addNode((AlphaNode)node);
        }
        alphaStore.sort();
        switch (alphaStore.nodes.size()) {
            case 0: {
                Object object2 = this.makeAlphaNode(EMPTY_TUPLE);
                alphaStore.addNode((AlphaNode)object2);
            }
            case 1: {
                Object object2 = alphaStore.nodes.get(0);
                node = this.makeBetaNode((Node)object2, (Node)object2, false);
                ((Node)object2).add((BetaNode)node);
                ((BetaNode)node).rule = new RuleNode(rule, set);
                ((BetaNode)node).rule.betaNode = node;
                break;
            }
            default: {
                Iterator<AlphaNode> iterator = alphaStore.nodes.iterator();
                Object object2 = iterator.next();
                AlphaNode alphaNode = iterator.next();
                node = this.makeBetaNode((Node)object2, alphaNode, true);
                ((Node)object2).add((BetaNode)node);
                alphaNode.add((BetaNode)node);
                while (iterator.hasNext()) {
                    AlphaNode alphaNode2 = iterator.next();
                    node = this.makeBetaNode(node, alphaNode2, true);
                    alphaNode2.add((BetaNode)node);
                }
                ((BetaNode)node).rule = new RuleNode(rule, set);
                ((BetaNode)node).rule.betaNode = node;
            }
        }
    }

    public void compileFacts(ABox aBox) {
        this.interpreter.addFact(EMPTY_FACT);
        IndividualIterator individualIterator = aBox.getIndIterator();
        while (individualIterator.hasNext()) {
            Individual individual = (Individual)individualIterator.next();
            this.processIndividual(individual);
        }
    }

    private Fact createDifferent(Individual individual, org.mindswap.pellet.Node node, DependencySet dependencySet) {
        ATermAppl aTermAppl = individual.getName();
        ATermAppl aTermAppl2 = node.getName();
        return new Fact(dependencySet, DIFF_FROM, aTermAppl, aTermAppl2);
    }

    private Fact createFact(ATermAppl aTermAppl, Individual individual, org.mindswap.pellet.Node node, DependencySet dependencySet) {
        ATermAppl aTermAppl2 = aTermAppl;
        ATermAppl aTermAppl3 = individual.getName();
        ATermAppl aTermAppl4 = node.getName();
        return new Fact(dependencySet, aTermAppl2, aTermAppl3, aTermAppl4);
    }

    private Fact createFact(Individual individual, ATermAppl aTermAppl, DependencySet dependencySet) {
        ATermAppl aTermAppl2 = TYPE;
        ATermAppl aTermAppl3 = individual.getName();
        ATermAppl aTermAppl4 = aTermAppl;
        return new Fact(dependencySet, aTermAppl2, aTermAppl3, aTermAppl4);
    }

    private AlphaNode makeAlphaNode(TermTuple termTuple) {
        return this.alphaIndex.add(termTuple);
    }

    private BetaNode makeBetaNode(Node node, Node node2, boolean bl) {
        BetaNode betaNode = new BetaNode(node, node2, this.abox.doExplanation());
        return betaNode;
    }

    public boolean processIndividual(Individual individual) {
        boolean bl = false;
        if (!individual.isRootNominal() || individual.isPruned()) {
            return false;
        }
        for (Object object : individual.getTypes()) {
            bl |= this.addFact(individual, (ATermAppl)object, individual.getDepends((ATerm)object));
        }
        bl |= this.addDifferents(individual);
        for (Object object : individual.getOutEdges()) {
            bl |= this.addFact((Edge)object);
        }
        return bl;
    }

    public String toString() {
        return this.alphaIndex.toString();
    }

    static {
        EMPTY_TUPLE = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[0]);
        EMPTY_FACT = new Fact(DependencySet.INDEPENDENT, new ATermAppl[0]);
        String string = "tag:clarkparsia.info,2007:pellet:dl-safe-rules:predicate:";
        DIFF_FROM = ATermUtils.makeTermAppl(string + "differentFrom");
        SAME_AS = ATermUtils.makeTermAppl(string + "sameAs");
        TYPE = ATermUtils.makeTermAppl(string + "type");
    }
}

