/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyRestrictedDatatype;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.IntervalRelations;
import com.clarkparsia.pellet.datatypes.OWLRealInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class RestrictedRealDatatype
implements RestrictedDatatype<Number> {
    private static final Logger log = Logger.getLogger(RestrictedRealDatatype.class.getCanonicalName());
    private final Datatype<? extends Number> datatype;
    private final RestrictedDatatype<Number> empty;
    private final boolean enumerable;
    private final boolean finite;
    private final List<OWLRealInterval> intervals;

    public RestrictedRealDatatype(Datatype<? extends Number> datatype, OWLRealInterval oWLRealInterval) {
        this.datatype = datatype;
        this.empty = new EmptyRestrictedDatatype<Number>(datatype);
        this.intervals = Collections.singletonList(oWLRealInterval);
        this.finite = oWLRealInterval.isFinite();
        this.enumerable = oWLRealInterval.isPoint() || oWLRealInterval.getType().equals((Object)OWLRealInterval.LineType.INTEGER_ONLY);
    }

    private RestrictedRealDatatype(RestrictedRealDatatype restrictedRealDatatype, List<OWLRealInterval> list) {
        boolean bl;
        this.datatype = restrictedRealDatatype.datatype;
        this.empty = restrictedRealDatatype.empty;
        this.intervals = Collections.unmodifiableList(list);
        if (restrictedRealDatatype.finite) {
            this.finite = true;
        } else {
            bl = true;
            for (OWLRealInterval oWLRealInterval : list) {
                if (oWLRealInterval.isFinite()) continue;
                bl = false;
                break;
            }
            this.finite = bl;
        }
        if (restrictedRealDatatype.enumerable) {
            this.enumerable = true;
        } else {
            bl = true;
            for (OWLRealInterval oWLRealInterval : list) {
                if (oWLRealInterval.isPoint() || oWLRealInterval.getType().equals((Object)OWLRealInterval.LineType.INTEGER_ONLY)) continue;
                bl = false;
                break;
            }
            this.enumerable = bl;
        }
    }

    @Override
    public RestrictedDatatype<Number> applyConstrainingFacet(ATermAppl aTermAppl, Object object) {
        boolean bl;
        Number number;
        boolean bl2;
        Number number2;
        Facet facet = Facet.Registry.get(aTermAppl);
        if (facet == null) {
            String string = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), aTermAppl, object);
            log.severe(string);
            throw new IllegalArgumentException(string);
        }
        Number number3 = null;
        if (object instanceof Number && !OWLRealUtils.acceptable((number3 = (Number)object).getClass())) {
            number3 = null;
        }
        if (number3 == null) {
            String string = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), facet, object);
            log.severe(string);
            throw new IllegalArgumentException(string);
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(facet)) {
            number2 = null;
            bl2 = false;
            number = number3;
            bl = false;
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(facet)) {
            number2 = null;
            bl2 = false;
            number = number3;
            bl = true;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(facet)) {
            number2 = number3;
            bl2 = false;
            number = null;
            bl = false;
        } else if (Facet.XSD.MIN_INCLUSIVE.equals(facet)) {
            number2 = number3;
            bl2 = true;
            number = null;
            bl = false;
        } else {
            throw new IllegalStateException();
        }
        OWLRealInterval oWLRealInterval = new OWLRealInterval(number2, number, bl2, bl, OWLRealInterval.LineType.CONTINUOUS);
        ArrayList<OWLRealInterval> arrayList = new ArrayList<OWLRealInterval>();
        boolean bl3 = false;
        for (OWLRealInterval oWLRealInterval2 : this.intervals) {
            OWLRealInterval oWLRealInterval3 = oWLRealInterval2.intersection(oWLRealInterval);
            if (oWLRealInterval3 != null) {
                arrayList.add(oWLRealInterval3);
                if (oWLRealInterval2 == oWLRealInterval3) continue;
                bl3 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl3) {
            if (arrayList.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, arrayList);
        }
        return this;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (OWLRealUtils.acceptable(number.getClass())) {
                for (OWLRealInterval oWLRealInterval : this.intervals) {
                    if (!oWLRealInterval.contains(number)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (!this.finite || n <= 0) {
            return true;
        }
        Number number = 0;
        for (OWLRealInterval oWLRealInterval : this.intervals) {
            number = OWLRealUtils.integerSum(number, oWLRealInterval.size());
            if (OWLRealUtils.compare(n, number) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<Number> exclude(Collection<?> collection) {
        boolean bl = false;
        ArrayList<OWLRealInterval> arrayList = new ArrayList<OWLRealInterval>(this.intervals);
        block0: for (Object obj : collection) {
            if (!(obj instanceof Number)) continue;
            Number number = (Number)obj;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                OWLRealInterval oWLRealInterval;
                OWLRealInterval oWLRealInterval2 = (OWLRealInterval)iterator.next();
                if (!oWLRealInterval2.contains(number)) continue;
                bl = true;
                iterator.remove();
                OWLRealInterval oWLRealInterval3 = oWLRealInterval2.less(number);
                if (oWLRealInterval3 != null) {
                    arrayList.add(oWLRealInterval3);
                }
                if ((oWLRealInterval = oWLRealInterval2.greater(number)) == null) continue block0;
                arrayList.add(oWLRealInterval);
                continue block0;
            }
        }
        if (bl) {
            if (arrayList.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, arrayList);
        }
        return this;
    }

    @Override
    public Datatype<? extends Number> getDatatype() {
        return this.datatype;
    }

    @Override
    public Number getValue(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<Number> intersect(RestrictedDatatype<?> restrictedDatatype, boolean bl) {
        if (restrictedDatatype instanceof RestrictedRealDatatype) {
            OWLRealInterval oWLRealInterval;
            Object object;
            Object object2;
            Object object3;
            RestrictedRealDatatype restrictedRealDatatype = (RestrictedRealDatatype)restrictedDatatype;
            ArrayList<OWLRealInterval> arrayList = new ArrayList<OWLRealInterval>();
            if (bl) {
                object3 = new ArrayList<OWLRealInterval>(Arrays.asList(OWLRealInterval.allReals()));
                for (OWLRealInterval oWLRealInterval2 : restrictedRealDatatype.intervals) {
                    object2 = new ArrayList();
                    object = object3.iterator();
                    while (object.hasNext()) {
                        oWLRealInterval = (OWLRealInterval)object.next();
                        object2.addAll(oWLRealInterval.remove(oWLRealInterval2));
                    }
                    object3 = object2;
                }
            } else {
                object3 = restrictedRealDatatype.intervals;
            }
            for (OWLRealInterval oWLRealInterval2 : this.intervals) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    oWLRealInterval = oWLRealInterval2.intersection((OWLRealInterval)object);
                    if (oWLRealInterval == null) continue;
                    arrayList.add(oWLRealInterval);
                }
            }
            if (arrayList.equals(this.intervals)) {
                return this;
            }
            if (arrayList.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, arrayList);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return this.enumerable;
    }

    @Override
    public boolean isFinite() {
        return this.finite;
    }

    @Override
    public int size() {
        if (!this.finite) {
            throw new IllegalStateException();
        }
        Number number = 0;
        for (OWLRealInterval oWLRealInterval : this.intervals) {
            number = OWLRealUtils.integerSum(number, oWLRealInterval.size());
            if (OWLRealUtils.compare(Integer.MAX_VALUE, number) > 0) continue;
            return Integer.MAX_VALUE;
        }
        return number;
    }

    @Override
    public RestrictedDatatype<Number> union(RestrictedDatatype<?> restrictedDatatype) {
        if (restrictedDatatype instanceof RestrictedRealDatatype) {
            RestrictedRealDatatype restrictedRealDatatype = (RestrictedRealDatatype)restrictedDatatype;
            ArrayList<OWLRealInterval> arrayList = new ArrayList<OWLRealInterval>(this.intervals);
            EnumSet<IntervalRelations> enumSet = EnumSet.complementOf(EnumSet.of(IntervalRelations.PRECEDED_BY, IntervalRelations.PRECEDES));
            for (OWLRealInterval oWLRealInterval : restrictedRealDatatype.intervals) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    OWLRealInterval oWLRealInterval2 = (OWLRealInterval)object.next();
                    IntervalRelations intervalRelations = oWLRealInterval.compare(oWLRealInterval2);
                    if (!enumSet.contains((Object)intervalRelations)) continue;
                    object.remove();
                    arrayList2.add(oWLRealInterval2);
                }
                if (arrayList2.isEmpty()) {
                    arrayList.add(oWLRealInterval);
                    continue;
                }
                object = new HashSet();
                for (OWLRealInterval oWLRealInterval2 : arrayList2) {
                    object.addAll(oWLRealInterval.union(oWLRealInterval2));
                }
                arrayList.addAll((Collection<OWLRealInterval>)object);
            }
            return new RestrictedRealDatatype(this, arrayList);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Number> valueIterator() {
        if (!this.enumerable) {
            throw new IllegalStateException();
        }
        return new Iterator<Number>(){
            final Iterator<OWLRealInterval> iit;
            Iterator<Number> nit;
            {
                this.iit = RestrictedRealDatatype.this.intervals.iterator();
                this.nit = null;
            }

            @Override
            public boolean hasNext() {
                while (this.nit == null || !this.nit.hasNext()) {
                    if (this.iit.hasNext()) {
                        this.nit = this.iit.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Number next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.nit.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return String.format("{%s,%s}", this.datatype, this.intervals);
    }
}

