/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import org.apache.jena.atlas.lib.Callback;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pingback;

public class AlarmClock {
    public Timer timer = null;
    public Set<Pingback<?>> outstanding = new HashSet();
    private static AlarmClock singleton = new AlarmClock();
    public long timeStart = System.currentTimeMillis();

    public static AlarmClock get() {
        return singleton;
    }

    public synchronized long getCount() {
        return this.outstanding.size();
    }

    public synchronized Pingback<?> add(Callback<?> callback, long delay) {
        return this.add(callback, null, delay);
    }

    public synchronized <T> Pingback<T> add(Callback<T> callback, T argument, long delay) {
        Pingback<T> x = new Pingback<T>(this, callback, argument);
        this.add$(x, delay);
        return x;
    }

    private <T> void add$(Pingback<T> pingback, long delay) {
        if (this.outstanding.contains(pingback)) {
            throw new InternalErrorException("Pingback already in use");
        }
        this.getTimer().schedule(pingback.timerTask, delay);
        this.outstanding.add(pingback);
    }

    public synchronized <T> Pingback<T> reset(Pingback<T> pingback, long delay) {
        if (this.timer != null) {
            this.cancel$(pingback, false);
        }
        pingback = new Pingback(this, pingback.callback, pingback.arg);
        this.add$(pingback, delay);
        return pingback;
    }

    public synchronized void cancel(Pingback<?> pingback) {
        if (pingback == null) {
            return;
        }
        this.cancel$(pingback, true);
    }

    private void cancel$(Pingback<?> pingback, boolean clearTimer) {
        if (this.timer == null) {
            return;
        }
        this.outstanding.remove(pingback);
        if (clearTimer && this.getCount() == 0L) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        return this.timer;
    }
}

