/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io;

import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.BitsInt;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.Ref;

public class JSWriter {
    private IndentedWriter out = IndentedWriter.stdout;
    private static String ArrayStart = "[ ";
    private static String ArrayFinish = " ]";
    private static String ArraySep = ", ";
    private static String ObjectStart = "{ ";
    private static String ObjectFinish = "}";
    private static String ObjectSep = " ,";
    private static String ObjectPairSep = " : ";
    Deque<Ref<Boolean>> stack = new ArrayDeque<Ref<Boolean>>();
    private static boolean writeJavaScript = false;

    public JSWriter() {
        this(IndentedWriter.stdout);
    }

    public JSWriter(OutputStream ps) {
        this(new IndentedWriter(ps));
    }

    public JSWriter(IndentedWriter ps) {
        this.out = ps;
    }

    public void startOutput() {
    }

    public void finishOutput() {
        this.out.flush();
    }

    public void startObject() {
        this.startCompound();
        this.out.print(ObjectStart);
        this.out.incIndent();
    }

    public void finishObject() {
        this.out.decIndent();
        if (this.isFirst()) {
            this.out.print(ObjectFinish);
        } else {
            this.out.ensureStartOfLine();
            this.out.println(ObjectFinish);
        }
        this.finishCompound();
    }

    public void key(String key) {
        if (this.isFirst()) {
            this.out.println();
            this.setNotFirst();
        } else {
            this.out.println(ObjectSep);
        }
        this.value(key);
        this.out.print(ObjectPairSep);
    }

    public void pair(String key, String value) {
        this.key(key);
        this.value(value);
    }

    public void pair(String key, boolean val) {
        this.key(key);
        this.value(val);
    }

    public void pair(String key, long val) {
        this.key(key);
        this.value(val);
    }

    public void startArray() {
        this.startCompound();
        this.out.print(ArrayStart);
    }

    public void finishArray() {
        this.out.print(ArrayFinish);
        this.finishCompound();
    }

    public void arrayElement(String str2) {
        this.arrayElementProcess();
        this.value(str2);
    }

    private void arrayElementProcess() {
        if (this.isFirst()) {
            this.setNotFirst();
        } else {
            this.out.print(ArraySep);
        }
    }

    public void arrayElement(boolean b) {
        this.arrayElementProcess();
        this.value(b);
    }

    public void arrayElement(long integer) {
        this.arrayElementProcess();
        this.value(integer);
    }

    public void arraySep() {
        this.out.print(ArraySep);
    }

    public static String outputQuotedString(String string) {
        IndentedLineBuffer b = new IndentedLineBuffer();
        JSWriter.outputQuotedString(b, string);
        return b.asString();
    }

    public static void outputQuotedString(IndentedWriter out, String string) {
        boolean allowBareWords = writeJavaScript;
        int quoteChar = 34;
        int len = string.length();
        if (allowBareWords) {
            boolean safeBareWord = true;
            if (len != 0) {
                safeBareWord = JSWriter.isA2Z(string.charAt(0));
            }
            if (safeBareWord) {
                for (int i = 1; i < len; ++i) {
                    char ch = string.charAt(i);
                    if (JSWriter.isA2ZN(ch)) continue;
                    safeBareWord = false;
                    break;
                }
            }
            if (safeBareWord) {
                out.print(string);
                return;
            }
        }
        if (allowBareWords) {
            quoteChar = 39;
        }
        out.print((char)quoteChar);
        block10: for (int i = 0; i < len; ++i) {
            int ch = string.charAt(i);
            if (ch == quoteChar) {
                JSWriter.esc(out, (char)quoteChar);
                continue;
            }
            switch (ch) {
                case 92: {
                    JSWriter.esc(out, '\\');
                    continue block10;
                }
                case 47: {
                    if (i > 0 && string.charAt(i - 1) == '<') {
                        JSWriter.esc(out, '/');
                        continue block10;
                    }
                    out.print((char)ch);
                    continue block10;
                }
                case 8: {
                    JSWriter.esc(out, 'b');
                    continue block10;
                }
                case 12: {
                    JSWriter.esc(out, 'f');
                    continue block10;
                }
                case 10: {
                    JSWriter.esc(out, 'n');
                    continue block10;
                }
                case 13: {
                    JSWriter.esc(out, 'r');
                    continue block10;
                }
                case 9: {
                    JSWriter.esc(out, 't');
                    continue block10;
                }
                default: {
                    if (ch == quoteChar) {
                        JSWriter.esc(out, '\"');
                        continue block10;
                    }
                    if (ch < 32 || ch >= 127 && ch <= 159 || ch >= 8192 && ch < 8448) {
                        out.print("\\u");
                        int x = ch;
                        x = JSWriter.oneHex(out, x, 3);
                        x = JSWriter.oneHex(out, x, 2);
                        x = JSWriter.oneHex(out, x, 1);
                        x = JSWriter.oneHex(out, x, 0);
                        continue block10;
                    }
                    out.print((char)ch);
                }
            }
        }
        if (quoteChar != 0) {
            out.print((char)quoteChar);
        }
    }

    private void startCompound() {
        this.stack.push(new Ref<Boolean>(true));
    }

    private void finishCompound() {
        this.stack.pop();
    }

    private boolean isFirst() {
        return this.stack.peek().getValue();
    }

    private void setNotFirst() {
        this.stack.peek().setValue(false);
    }

    private void value(String x) {
        this.out.print(JSWriter.outputQuotedString(x));
    }

    private void value(boolean b) {
        this.out.print(Boolean.toString(b));
    }

    private void value(long integer) {
        this.out.print(Long.toString(integer));
    }

    private static boolean isA2Z(int ch) {
        return JSWriter.range(ch, 'a', 'z') || JSWriter.range(ch, 'A', 'Z');
    }

    private static boolean isA2ZN(int ch) {
        return JSWriter.range(ch, 'a', 'z') || JSWriter.range(ch, 'A', 'Z') || JSWriter.range(ch, '0', '9');
    }

    private static boolean isNumeric(int ch) {
        return JSWriter.range(ch, '0', '9');
    }

    private static boolean isWhitespace(int ch) {
        return ch == 32 || ch == 9 || ch == 13 || ch == 10 || ch == 12;
    }

    private static boolean isNewlineChar(int ch) {
        return ch == 13 || ch == 10;
    }

    private static boolean range(int ch, char a, char b) {
        return ch >= a && ch <= b;
    }

    private static void esc(IndentedWriter out, char ch) {
        out.print('\\');
        out.print(ch);
    }

    private static int oneHex(IndentedWriter out, int x, int i) {
        int y = BitsInt.unpack(x, 4 * i, 4 * i + 4);
        char charHex = Chars.hexDigitsUC[y];
        out.print(charHex);
        return BitsInt.clear(x, 4 * i, 4 * i + 4);
    }
}

