/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public abstract class NestedIterator<Outer, Inner>
implements Iterator<Inner> {
    private Iterator<? extends Outer> outerIterator;
    private Iterator<? extends Inner> innerIterator;

    public NestedIterator(Iterable<? extends Outer> iterable) {
        this(iterable.iterator());
    }

    public NestedIterator(Iterator<? extends Outer> iterator) {
        this.outerIterator = iterator;
        this.findIterator();
    }

    private void findIterator() {
        while (this.outerIterator.hasNext()) {
            Outer Outer = this.outerIterator.next();
            this.innerIterator = this.getInnerIterator(Outer);
            if (!this.innerIterator.hasNext()) continue;
            return;
        }
        this.innerIterator = IteratorUtils.emptyIterator();
    }

    public abstract Iterator<? extends Inner> getInnerIterator(Outer var1);

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public Inner next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Inner Inner = this.innerIterator.next();
        if (!this.innerIterator.hasNext()) {
            this.findIterator();
        }
        return Inner;
    }

    @Override
    public void remove() {
        this.innerIterator.remove();
    }
}

