/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class SetUtils {
    public static final Set<?> EMPTY_SET = new EmptySet();

    public static <T> Set<T> add(T t, Set<T> set) {
        int n = set.size();
        if (n == 0) {
            set = SetUtils.singleton(t);
        } else if (n == 1) {
            T t2 = set.iterator().next();
            if (!t2.equals(t)) {
                set = SetUtils.binary(t2, t);
            }
        } else {
            set.add(t);
        }
        return set;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T> Set<T> remove(Object object, Set<T> set) {
        int n = set.size();
        if (n != 0) {
            if (n == 1) {
                if (set.contains(object)) {
                    set = Collections.emptySet();
                }
            } else {
                set.remove(object);
            }
        }
        return set;
    }

    public static final <T> Set<T> singleton(T t) {
        return Collections.singleton(t);
    }

    public static final <T> Set<T> binary(T t, T t2) {
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.add(t);
        hashSet.add(t2);
        return hashSet;
    }

    public static <T> Set<T> union(Collection<? extends Collection<? extends T>> collection) {
        HashSet<T> hashSet = new HashSet<T>();
        for (Collection<T> collection2 : collection) {
            hashSet.addAll(collection2);
        }
        return hashSet;
    }

    public static <T> Set<T> union(Collection<? extends T> collection, Collection<? extends T> collection2) {
        HashSet<T> hashSet = new HashSet<T>(collection);
        hashSet.addAll(collection2);
        return hashSet;
    }

    public static <T> Set<T> intersection(Collection<? extends Collection<? extends T>> collection) {
        Iterator<Collection<T>> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return new HashSet();
        }
        HashSet<T> hashSet = new HashSet<T>(iterator.next());
        while (iterator.hasNext()) {
            Collection<? extends T> collection2 = iterator.next();
            hashSet.retainAll(collection2);
        }
        return hashSet;
    }

    public static <T> Set<T> intersection(Collection<? extends T> collection, Collection<? extends T> collection2) {
        HashSet<T> hashSet = new HashSet<T>(collection);
        hashSet.retainAll(collection2);
        return hashSet;
    }

    public static boolean intersects(Collection<?> collection, Collection<?> collection2) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!collection2.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean subset(Set<?> set, Set<?> set2) {
        return set.size() <= set2.size() && set2.containsAll(set);
    }

    public static <T> boolean equals(Set<T> set, Set<T> set2) {
        return set.size() == set2.size() && set.containsAll(set2);
    }

    public static <T> Set<T> difference(Collection<T> collection, Collection<? extends Object> collection2) {
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(collection);
        if (collection2 instanceof Set) {
            hashSet.removeAll(collection2);
        } else {
            for (Object object : collection2) {
                hashSet.remove(object);
            }
        }
        return hashSet;
    }

    public static <T> Set<T> create(T ... TArray) {
        HashSet<T> hashSet = new HashSet<T>(TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            hashSet.add(TArray[i]);
        }
        return hashSet;
    }

    public static <T> Set<T> create(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    private static class EmptySet
    extends AbstractSet<Object> {
        private EmptySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return IteratorUtils.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }
    }
}

