/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.lintpattern.axiom.DisjunctionSizeCollector;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.Severity;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class LargeDisjunctionPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new SimpleLintFormat();
    private int m_MaxAllowed = 10;
    private DisjunctionSizeCollector m_Visitor = new DisjunctionSizeCollector();

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + " (MaxAllowed = " + this.m_MaxAllowed + ")";
    }

    @Override
    public String getDescription() {
        return "Too many disjuncts in a disjunction - maximum recommended is " + this.m_MaxAllowed;
    }

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void setMaxAllowed(int n) {
        this.m_MaxAllowed = n;
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        this.visitNaryClassAxiom((OWLClassAxiom)oWLDisjointClassesAxiom);
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        this.visitNaryClassAxiom((OWLClassAxiom)oWLDisjointUnionAxiom);
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        this.visitNaryClassAxiom((OWLClassAxiom)oWLEquivalentClassesAxiom);
    }

    public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        this.visitNaryClassAxiom((OWLClassAxiom)oWLSubClassOfAxiom);
    }

    private void visitNaryClassAxiom(OWLClassAxiom oWLClassAxiom) {
        this.m_Visitor.reset();
        oWLClassAxiom.accept((OWLObjectVisitor)this.m_Visitor);
        int n = this.m_Visitor.getDisjunctionSize();
        if (n > this.m_MaxAllowed) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom(oWLClassAxiom);
            lint.setSeverity(new Severity(n));
            this.setLint(lint);
        }
    }
}

