/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;

public class EquivalentToMaxCardinalityPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return "A named concept is equivalent to a max cardinality restriction";
    }

    @Override
    public boolean isFixable() {
        return true;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        Set set = oWLEquivalentClassesAxiom.getClassExpressions();
        if (set.size() != 2) {
            return;
        }
        OWLClass oWLClass = null;
        OWLClassExpression oWLClassExpression = null;
        for (OWLClassExpression oWLClassExpression2 : set) {
            if (!oWLClassExpression2.isAnonymous()) {
                oWLClass = oWLClassExpression2.asOWLClass();
                continue;
            }
            if (!(oWLClassExpression2 instanceof OWLObjectMaxCardinality) && !(oWLClassExpression2 instanceof OWLDataMaxCardinality)) continue;
            oWLClassExpression = oWLClassExpression2;
        }
        if (oWLClass != null && oWLClassExpression != null) {
            OWLClassExpression oWLClassExpression2;
            Lint lint = this.makeLint();
            lint.addParticipatingClass(oWLClass);
            lint.addParticipatingAxiom((OWLClassAxiom)oWLEquivalentClassesAxiom);
            oWLClassExpression2 = OWL.subClassOf((OWLClassExpression)oWLClass, oWLClassExpression);
            LintFixer lintFixer = new LintFixer((OWLAxiom)oWLEquivalentClassesAxiom, (OWLAxiom)oWLClassExpression2);
            lint.setLintFixer(lintFixer);
            this.setLint(lint);
        }
    }
}

