/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.IncrementalChangeTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;

public class SimpleIncrementalChangeTracker
implements IncrementalChangeTracker {
    private HashSet<Edge> deletedEdges;
    private HashMap<Node, Set<ATermAppl>> deletedTypes;
    private HashSet<Edge> newEdges;
    private HashSet<Individual> newIndividuals;
    private HashSet<Node> unprunedNodes;
    private HashSet<Individual> updatedIndividuals;

    public SimpleIncrementalChangeTracker() {
        this.deletedEdges = new HashSet();
        this.deletedTypes = new HashMap();
        this.newEdges = new HashSet();
        this.newIndividuals = new HashSet();
        this.unprunedNodes = new HashSet();
        this.updatedIndividuals = new HashSet();
    }

    private SimpleIncrementalChangeTracker(SimpleIncrementalChangeTracker simpleIncrementalChangeTracker, ABox aBox) {
        Node node;
        Node node2;
        this.deletedEdges = new HashSet(simpleIncrementalChangeTracker.deletedEdges.size());
        for (Edge object : simpleIncrementalChangeTracker.deletedEdges) {
            node2 = aBox.getIndividual((ATerm)object.getFrom().getName());
            if (node2 == null) {
                throw new NullPointerException();
            }
            node = aBox.getNode((ATerm)object.getTo().getName());
            if (node == null) {
                throw new NullPointerException();
            }
            this.newEdges.add(new DefaultEdge(object.getRole(), (Individual)node2, node, object.getDepends()));
        }
        this.deletedTypes = new HashMap(simpleIncrementalChangeTracker.deletedTypes.size());
        for (Map.Entry entry : simpleIncrementalChangeTracker.deletedTypes.entrySet()) {
            node2 = aBox.getNode((ATerm)((Node)entry.getKey()).getName());
            if (node2 == null) {
                throw new NullPointerException();
            }
            this.deletedTypes.put(node2, new HashSet((Collection)entry.getValue()));
        }
        this.newEdges = new HashSet(simpleIncrementalChangeTracker.newEdges.size());
        for (Edge edge : simpleIncrementalChangeTracker.newEdges) {
            node2 = aBox.getIndividual((ATerm)edge.getFrom().getName());
            if (node2 == null) {
                throw new NullPointerException();
            }
            node = aBox.getNode((ATerm)edge.getTo().getName());
            if (node == null) {
                throw new NullPointerException();
            }
            this.newEdges.add(new DefaultEdge(edge.getRole(), (Individual)node2, node, edge.getDepends()));
        }
        this.newIndividuals = new HashSet(simpleIncrementalChangeTracker.newIndividuals.size());
        for (Individual individual : simpleIncrementalChangeTracker.newIndividuals) {
            node2 = aBox.getIndividual((ATerm)individual.getName());
            if (node2 == null) {
                throw new NullPointerException();
            }
            this.newIndividuals.add((Individual)node2);
        }
        this.unprunedNodes = new HashSet(simpleIncrementalChangeTracker.unprunedNodes.size());
        for (Node node3 : simpleIncrementalChangeTracker.unprunedNodes) {
            node2 = aBox.getNode((ATerm)node3.getName());
            if (node2 == null) {
                throw new NullPointerException();
            }
            this.unprunedNodes.add(node2);
        }
        this.updatedIndividuals = new HashSet(simpleIncrementalChangeTracker.updatedIndividuals.size());
        for (Individual individual : simpleIncrementalChangeTracker.updatedIndividuals) {
            node2 = aBox.getIndividual((ATerm)individual.getName());
            if (node2 == null) {
                throw new NullPointerException();
            }
            this.updatedIndividuals.add((Individual)node2);
        }
    }

    @Override
    public boolean addDeletedEdge(Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        return this.deletedEdges.add(edge);
    }

    @Override
    public boolean addDeletedType(Node node, ATermAppl aTermAppl) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (aTermAppl == null) {
            throw new NullPointerException();
        }
        Set<ATermAppl> set = this.deletedTypes.get(node);
        if (set == null) {
            set = new HashSet<ATermAppl>();
            this.deletedTypes.put(node, set);
        }
        return set.add(aTermAppl);
    }

    @Override
    public boolean addNewEdge(Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        return this.newEdges.add(edge);
    }

    @Override
    public boolean addNewIndividual(Individual individual) {
        if (individual == null) {
            throw new NullPointerException();
        }
        return this.newIndividuals.add(individual);
    }

    @Override
    public boolean addUnprunedNode(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        return this.unprunedNodes.add(node);
    }

    @Override
    public boolean addUpdatedIndividual(Individual individual) {
        if (individual == null) {
            throw new NullPointerException();
        }
        return this.updatedIndividuals.add(individual);
    }

    @Override
    public void clear() {
        this.deletedEdges.clear();
        this.deletedTypes.clear();
        this.newEdges.clear();
        this.newIndividuals.clear();
        this.unprunedNodes.clear();
        this.updatedIndividuals.clear();
    }

    @Override
    public SimpleIncrementalChangeTracker copy(ABox aBox) {
        return new SimpleIncrementalChangeTracker(this, aBox);
    }

    @Override
    public Iterator<Edge> deletedEdges() {
        return Collections.unmodifiableSet(this.deletedEdges).iterator();
    }

    @Override
    public Iterator<Map.Entry<Node, Set<ATermAppl>>> deletedTypes() {
        return Collections.unmodifiableMap(this.deletedTypes).entrySet().iterator();
    }

    @Override
    public Iterator<Edge> newEdges() {
        return Collections.unmodifiableSet(this.newEdges).iterator();
    }

    @Override
    public Iterator<Individual> newIndividuals() {
        return Collections.unmodifiableSet(this.newIndividuals).iterator();
    }

    @Override
    public Iterator<Node> unprunedNodes() {
        return Collections.unmodifiableSet(this.unprunedNodes).iterator();
    }

    @Override
    public Iterator<Individual> updatedIndividuals() {
        return Collections.unmodifiableSet(this.updatedIndividuals).iterator();
    }
}

