/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.jena.SlicedResultSet;
import com.clarkparsia.pellet.sparqldl.jena.SortedResultSet;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLResultSet;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.FileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.PelletInfGraph;

class SparqlDLExecution
implements QueryExecution {
    public static Logger log = Logger.getLogger(SparqlDLExecution.class.getName());
    private com.hp.hpl.jena.query.Query query;
    private Dataset source;
    private QuerySolution initialBinding;
    private boolean purePelletQueryExec = false;
    private boolean handleVariableSPO = true;

    public SparqlDLExecution(String string, Model model) {
        this(QueryFactory.create((String)string), model);
    }

    public SparqlDLExecution(com.hp.hpl.jena.query.Query query, Model model) {
        this(query, DatasetFactory.create((Model)model));
    }

    public SparqlDLExecution(com.hp.hpl.jena.query.Query query, Dataset dataset) {
        this(query, dataset, true);
    }

    public SparqlDLExecution(com.hp.hpl.jena.query.Query query, Dataset dataset, boolean bl) {
        this.query = query;
        this.source = dataset;
        this.handleVariableSPO = bl;
        Graph graph = dataset.getDefaultModel().getGraph();
        if (!(graph instanceof PelletInfGraph)) {
            throw new QueryException("PelletQueryExecution can only be used with Pellet-backed models");
        }
        if (PelletOptions.FULL_SIZE_ESTIMATE) {
            ((PelletInfGraph)graph).getKB().getSizeEstimate().computeAll();
        }
    }

    public Model execDescribe() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Model execDescribe(Model model) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Model execConstruct() {
        Model model = ModelFactory.createDefaultModel();
        this.execConstruct(model);
        return model;
    }

    public Model execConstruct(Model model) {
        this.ensureQueryType(QueryType.CONSTRUCT);
        ResultSet resultSet = this.exec();
        if (resultSet == null) {
            QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source, (QuerySolution)this.initialBinding).execConstruct(model);
        } else {
            model.setNsPrefixes((PrefixMapping)this.source.getDefaultModel());
            model.setNsPrefixes(this.query.getPrefixMapping());
            HashSet hashSet = new HashSet();
            Template template = this.query.getConstructTemplate();
            while (resultSet.hasNext()) {
                HashMap hashMap = new HashMap();
                Binding binding = resultSet.nextBinding();
                template.subst(hashSet, (Map)hashMap, binding);
            }
            for (Binding binding : hashSet) {
                Statement statement = ModelUtils.tripleToStatement((Model)model, (Triple)binding);
                if (statement == null) continue;
                model.add(statement);
            }
            this.close();
        }
        return model;
    }

    public boolean execAsk() {
        this.ensureQueryType(QueryType.ASK);
        ResultSet resultSet = this.exec();
        return resultSet != null ? resultSet.hasNext() : QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source, (QuerySolution)this.initialBinding).execAsk();
    }

    public ResultSet execSelect() {
        this.ensureQueryType(QueryType.SELECT);
        ResultSet resultSet = this.exec();
        return resultSet != null ? resultSet : QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source, (QuerySolution)this.initialBinding).execSelect();
    }

    private ResultSet exec() {
        try {
            if (this.source.listNames().hasNext()) {
                throw new UnsupportedQueryException("Named graphs is not supported by Pellet");
            }
            PelletInfGraph pelletInfGraph = (PelletInfGraph)this.source.getDefaultModel().getGraph();
            KnowledgeBase knowledgeBase = pelletInfGraph.getKB();
            pelletInfGraph.prepare();
            QueryParameters queryParameters = new QueryParameters(this.initialBinding);
            ARQParser aRQParser = new ARQParser(this.handleVariableSPO);
            aRQParser.setInitialBinding(this.initialBinding);
            Query query = aRQParser.parse(this.query, knowledgeBase);
            query.setQueryParameters(queryParameters);
            Object object = new SparqlDLResultSet(QueryEngine.exec(query), this.source.getDefaultModel(), queryParameters);
            List list = this.query.getOrderBy();
            if (list != null && !list.isEmpty()) {
                object = new SortedResultSet((ResultSet)object, list);
            }
            if (this.query.hasOffset() || this.query.hasLimit()) {
                long l = this.query.hasOffset() ? this.query.getOffset() : 0L;
                long l2 = this.query.hasLimit() ? this.query.getLimit() : Long.MAX_VALUE;
                object = new SlicedResultSet((ResultSet)object, l, l2);
            }
            return object;
        }
        catch (UnsupportedQueryException unsupportedQueryException) {
            log.log(this.purePelletQueryExec ? Level.INFO : Level.FINE, "This is not a SPARQL-DL query: " + unsupportedQueryException.getMessage());
            if (this.purePelletQueryExec) {
                throw unsupportedQueryException;
            }
            log.fine("Falling back to Jena query engine");
            return null;
        }
    }

    public void abort() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public void close() {
        log.fine("Closing PelletQueryExecution '" + this.hashCode() + "'.");
    }

    public void setFileManager(FileManager fileManager) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public void setInitialBinding(QuerySolution querySolution) {
        this.initialBinding = querySolution;
    }

    public Context getContext() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    private void ensureQueryType(QueryType queryType) throws QueryExecException {
        QueryType queryType2 = SparqlDLExecution.getQueryType(this.query);
        if (queryType2 != queryType) {
            throw new QueryExecException("Attempt to execute a " + (Object)((Object)queryType2) + " query as a " + (Object)((Object)queryType) + " query");
        }
    }

    private static QueryType getQueryType(com.hp.hpl.jena.query.Query query) {
        if (query.isSelectType()) {
            return QueryType.SELECT;
        }
        if (query.isConstructType()) {
            return QueryType.CONSTRUCT;
        }
        if (query.isDescribeType()) {
            return QueryType.DESCRIBE;
        }
        if (query.isAskType()) {
            return QueryType.ASK;
        }
        return null;
    }

    public boolean isPurePelletQueryExec() {
        return this.purePelletQueryExec;
    }

    public void setPurePelletQueryExec(boolean bl) {
        this.purePelletQueryExec = bl;
    }

    public Iterator<Triple> execConstructTriples() {
        return ModelUtils.statementsToTriples((Iterator)this.execConstruct().listStatements());
    }

    public Iterator<Triple> execDescribeTriples() {
        return ModelUtils.statementsToTriples((Iterator)this.execDescribe().listStatements());
    }

    public com.hp.hpl.jena.query.Query getQuery() {
        return this.query;
    }

    public long getTimeout1() {
        return -1L;
    }

    public long getTimeout2() {
        return -1L;
    }

    public void setTimeout(long l) {
    }

    public void setTimeout(long l, TimeUnit timeUnit) {
    }

    public void setTimeout(long l, long l2) {
    }

    public void setTimeout(long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2) {
    }

    private static enum QueryType {
        ASK,
        CONSTRUCT,
        DESCRIBE,
        SELECT;

    }
}

