/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphCaching;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.StorageConfig;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.Session;
import com.hp.hpl.jena.update.GraphStore;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.Tuple;

public final class DatasetGraphTDB
extends DatasetGraphCaching
implements Sync,
Closeable,
GraphStore,
Session {
    private TripleTable tripleTable;
    private QuadTable quadTable;
    private DatasetPrefixesTDB prefixes;
    private final ReorderTransformation transform;
    private final StorageConfig config;
    private GraphTDB effectiveDefaultGraph;
    private boolean closed = false;
    private boolean readOnly = false;
    private static Transform<Tuple<NodeId>, NodeId> project0 = new Transform<Tuple<NodeId>, NodeId>(){

        public NodeId convert(Tuple<NodeId> item) {
            return (NodeId)item.get(0);
        }
    };

    public DatasetGraphTDB(TripleTable tripleTable, QuadTable quadTable, DatasetPrefixesTDB prefixes, ReorderTransformation transform, StorageConfig config) {
        this.tripleTable = tripleTable;
        this.quadTable = quadTable;
        this.prefixes = prefixes;
        this.transform = transform;
        this.config = config;
        this.effectiveDefaultGraph = this.getDefaultGraphTDB();
    }

    protected DatasetGraphTDB(DatasetGraphTDB other) {
        this(other.tripleTable, other.quadTable, other.prefixes, other.transform, other.config);
    }

    public DatasetGraphTDB duplicate() {
        return new DatasetGraphTDB(this.tripleTable, this.quadTable, this.prefixes, this.transform, this.config);
    }

    public QuadTable getQuadTable() {
        return this.quadTable;
    }

    public TripleTable getTripleTable() {
        return this.tripleTable;
    }

    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return DatasetGraphTDB.triples2quadsDftGraph(this.getTripleTable().find(s, p, o));
    }

    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return this.getQuadTable().find(g, s, p, o);
    }

    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return this.getQuadTable().find(Node.ANY, s, p, o);
    }

    protected static Iterator<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return DatasetGraphTDB.triples2quads((Node)Quad.defaultGraphIRI, iter);
    }

    protected void addToDftGraph(Node s, Node p, Node o) {
        this.getTripleTable().add(s, p, o);
    }

    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.getQuadTable().add(g, s, p, o);
    }

    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.getTripleTable().delete(s, p, o);
    }

    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.getQuadTable().delete(g, s, p, o);
    }

    public GraphTDB getDefaultGraphTDB() {
        return (GraphTDB)this.getDefaultGraph();
    }

    public GraphTDB getGraphTDB(Node graphNode) {
        return (GraphTDB)this.getGraph(graphNode);
    }

    protected void _close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.tripleTable.close();
        this.quadTable.close();
        this.prefixes.close();
        this.tripleTable = null;
        this.quadTable = null;
        this.prefixes = null;
    }

    public boolean containsGraph(Node graphNode) {
        if (Quad.isDefaultGraphExplicit((Node)graphNode) || Quad.isUnionGraph((Node)graphNode)) {
            return true;
        }
        return this._containsGraph(graphNode);
    }

    protected boolean _containsGraph(Node graphNode) {
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().findAsNodeIds(graphNode, null, null, null);
        if (x == null) {
            return false;
        }
        boolean result = x.hasNext();
        return result;
    }

    protected Graph _createDefaultGraph() {
        return new GraphTriplesTDB(this, this.tripleTable, this.prefixes);
    }

    protected Graph _createNamedGraph(Node graphNode) {
        return new GraphNamedTDB(this, graphNode);
    }

    public void setEffectiveDefaultGraph(GraphTDB g) {
        this.effectiveDefaultGraph = g;
    }

    public GraphTDB getEffectiveDefaultGraph() {
        return this.effectiveDefaultGraph;
    }

    public StorageConfig getConfig() {
        return this.config;
    }

    @Deprecated
    public ReorderTransformation getTransform() {
        return this.getReorderTransform();
    }

    public ReorderTransformation getReorderTransform() {
        return this.transform;
    }

    public DatasetPrefixesTDB getPrefixes() {
        return this.prefixes;
    }

    public Iterator<Node> listGraphNodes() {
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().findAll();
        Iter z = Iter.iter(x).map(project0).distinct();
        return NodeLib.nodes(this.quadTable.getNodeTupleTable().getNodeTable(), (Iterator<NodeId>)z);
    }

    public long size() {
        return Iter.count(this.listGraphNodes());
    }

    public boolean isEmpty() {
        return this.getTripleTable().isEmpty() && this.getQuadTable().isEmpty();
    }

    public void clear() {
        this.getTripleTable().clearTriples();
        this.getQuadTable().clearQuads();
    }

    public Location getLocation() {
        return this.config.location;
    }

    public void sync() {
        this.tripleTable.sync();
        this.quadTable.sync();
        this.prefixes.sync();
    }

    public void startRequest() {
    }

    public void finishRequest() {
    }

    public Dataset toDataset() {
        return DatasetImpl.wrap((DatasetGraph)this);
    }

    public void addGraph(Node graphName, Graph graph) {
        Graph g = this.getGraph(graphName);
        GraphUtil.addInto((Graph)g, (Graph)graph);
    }

    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("Can't set default graph via GraphStore on a TDB-backed dataset");
    }

    @Override
    public void startUpdate() {
    }

    @Override
    public void finishUpdate() {
    }

    @Override
    public void startRead() {
    }

    @Override
    public void finishRead() {
    }
}

