/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.OWLEntityURIConverterStrategy;

public class OWLEntityTinyURIConversionStrategy
implements OWLEntityURIConverterStrategy {
    public static final String DEFAULT_BASE = "http://tinyname.org#";
    private final String base;
    private final Map<OWLEntity, IRI> entityNameMap;
    private final OWLEntityFragmentProvider fragmentProvider;

    public OWLEntityTinyURIConversionStrategy() {
        this(DEFAULT_BASE);
    }

    public OWLEntityTinyURIConversionStrategy(String base) {
        this.base = base;
        this.entityNameMap = new HashMap<OWLEntity, IRI>();
        this.fragmentProvider = new OWLEntityFragmentProvider();
    }

    @Override
    public IRI getConvertedIRI(OWLEntity entity) {
        IRI iri = this.entityNameMap.get(entity);
        if (iri != null) {
            return iri;
        }
        if (entity instanceof OWLDatatype) {
            return entity.getIRI();
        }
        String name = this.fragmentProvider.getName(entity);
        iri = IRI.create(this.base + name);
        this.entityNameMap.put(entity, iri);
        return iri;
    }

    private static class OWLEntityFragmentProvider
    implements OWLEntityVisitor {
        private String name;
        private int classCount = 0;
        private int objectPropertyCount = 0;
        private int dataPropertyCount = 0;
        private int individualCount = 0;
        private int annotationPropertyCount = 0;
        private int datatypeCount = 0;

        public String getName(OWLEntity entity) {
            if (entity.isBuiltIn()) {
                return entity.getIRI().toString();
            }
            entity.accept(this);
            return this.name;
        }

        @Override
        public void visit(OWLClass cls) {
            ++this.classCount;
            this.name = "C" + this.classCount;
        }

        @Override
        public void visit(OWLDatatype datatype) {
            ++this.datatypeCount;
            this.name = "dt" + this.datatypeCount;
        }

        @Override
        public void visit(OWLNamedIndividual individual) {
            ++this.individualCount;
            this.name = "i" + this.individualCount;
        }

        @Override
        public void visit(OWLDataProperty property) {
            ++this.dataPropertyCount;
            this.name = "dp" + this.dataPropertyCount;
        }

        @Override
        public void visit(OWLObjectProperty property) {
            ++this.objectPropertyCount;
            this.name = "op" + this.objectPropertyCount;
        }

        @Override
        public void visit(OWLAnnotationProperty property) {
            ++this.annotationPropertyCount;
            this.name = "ap" + this.annotationPropertyCount;
        }
    }
}

