/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Locale;
import org.coode.owlapi.rdfxml.parser.AbstractClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class ObjectHasSelfTranslator
extends AbstractClassExpressionTranslator {
    public ObjectHasSelfTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public boolean matchesStrict(IRI mainNode) {
        OWLLiteral literal = this.getConsumer().getLiteralObject(mainNode, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), false);
        return literal != null && this.isStrictBooleanTrueLiteral(literal) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
    }

    private boolean isStrictBooleanTrueLiteral(OWLLiteral literal) {
        return OWL2Datatype.XSD_BOOLEAN.getIRI().equals(literal.getDatatype().getIRI()) && literal.getLiteral().toLowerCase(Locale.ENGLISH).equals("true");
    }

    @Override
    public boolean matchesLax(IRI mainNode) {
        return this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isLiteralPresent(mainNode, OWLRDFVocabulary.OWL_HAS_SELF);
    }

    @Override
    public OWLObjectHasSelf translate(IRI mainNode) {
        this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.getConsumer().getLiteralObject(mainNode, OWLRDFVocabulary.OWL_HAS_SELF, true);
        IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
        OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(propertyIRI);
        return this.getDataFactory().getOWLObjectHasSelf(property);
    }
}

