/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.modularity.ModularityUtils;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.io.SystemOutDocumentTarget;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class PelletModularity
extends PelletCmdApp {
    private OWLAPILoader loader;
    private ModuleType moduleType;
    private String[] entityNames;

    @Override
    public String getAppCmd() {
        return "pellet modularity " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public String getAppId() {
        return "PelletModularity: Extract ontology modules for classes and write it to the STDOUT";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        PelletCmdOption pelletCmdOption = new PelletCmdOption("signature");
        pelletCmdOption.setShortOption("s");
        pelletCmdOption.setType("Space separated list");
        pelletCmdOption.setDescription("One or more entity URI(s) or local name(s) to be extracted as a module. Example: \"Animal Wildlife Rainforest\"");
        pelletCmdOption.setIsMandatory(true);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("type");
        pelletCmdOption.setShortOption("t");
        pelletCmdOption.setType("lower| upper | upper-of-lower | lower-of-upper");
        pelletCmdOption.setDefaultValue("lower");
        pelletCmdOption.setDescription("The type of the module that will be extracted. See http://bit.ly/ontology-module-types for an explanation of the module types.");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        return pelletCmdOptions;
    }

    @Override
    public void run() {
        this.loadEntityNames();
        this.loadModuleType();
        this.loadOntology();
        this.extractModule();
    }

    private void loadOntology() {
        this.loader = (OWLAPILoader)this.getLoader("OWLAPIv3");
        this.getKB();
    }

    private void loadEntityNames() {
        String string = this.options.getOption("signature").getValueAsString();
        if (string == null) {
            throw new PelletCmdException("No signature provided");
        }
        this.entityNames = string.split(" ");
        if (this.entityNames.length == 0) {
            throw new PelletCmdException("No signature provided");
        }
    }

    private void loadModuleType() {
        String string = this.options.getOption("type").getValueAsString();
        if (string.equalsIgnoreCase("lower")) {
            this.moduleType = ModuleType.TOP;
        } else if (string.equalsIgnoreCase("upper")) {
            this.moduleType = ModuleType.BOT;
        } else if (string.equalsIgnoreCase("upper-of-lower")) {
            this.moduleType = ModuleType.BOT_OF_TOP;
        } else if (string.equalsIgnoreCase("lower-of-upper")) {
            this.moduleType = ModuleType.TOP_OF_BOT;
        } else {
            throw new PelletCmdException("Unknown module type: " + string);
        }
    }

    private void extractModule() {
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
        for (String string : this.entityNames) {
            OWLEntity oWLEntity = OntologyUtils.findEntity(string, this.loader.getAllOntologies());
            if (oWLEntity == null) {
                throw new PelletCmdException("Entity not found in ontology: " + string);
            }
            hashSet.add(oWLEntity);
        }
        Set<OWLAxiom> set = ModularityUtils.extractModule(this.loader.getOntology(), hashSet, this.moduleType);
        try {
            OWLOntology oWLException = this.loader.getManager().createOntology(set);
            this.loader.getManager().saveOntology(oWLException, (OWLOntologyFormat)new RDFXMLOntologyFormat(), (OWLOntologyDocumentTarget)new SystemOutDocumentTarget());
        }
        catch (OWLException oWLException) {
            throw new RuntimeException(oWLException);
        }
    }
}

