/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.EnumSet;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.utils.SetUtils;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletExtractInferences
extends PelletCmdApp {
    private EnumSet<ModelExtractor.StatementType> selector;

    @Override
    public String getAppId() {
        return "PelletExtractInferences: Extract a set of inferences from an ontology";
    }

    @Override
    public String getAppCmd() {
        return "pellet extract " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        PelletCmdOption pelletCmdOption = new PelletCmdOption("statements");
        pelletCmdOption.setShortOption("s");
        pelletCmdOption.setDescription("Statements to extract. The option accepts all axioms of the OWL functional syntax plus some additional ones. Valid arguments are: " + this.validStatementArguments() + ". Example: \"DirectSubClassOf DirectSubPropertyOf\"");
        pelletCmdOption.setType("Space separated list surrounded by quotes");
        pelletCmdOption.setDefaultValue("DefaultStatements");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOptions.add(this.getLoaderOption());
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        pelletCmdOptions.add(this.getInputFormatOption());
        return pelletCmdOptions;
    }

    @Override
    public void run() {
        this.mapStatementTypes();
        this.extractInferences();
    }

    private void extractInferences() {
        if (this.selector.size() == 0) {
            throw new PelletCmdException("Selector is empty, provide types to extract");
        }
        ModelExtractor modelExtractor = new ModelExtractor(this.getKB());
        modelExtractor.setSelector(this.selector);
        Model model = ModelFactory.createDefaultModel();
        if (SetUtils.intersects(this.selector, ModelExtractor.StatementType.ALL_CLASS_STATEMENTS)) {
            this.startTask("Extracting class statements");
            modelExtractor.extractClassModel(model);
            this.finishTask("Extracting class statements");
        }
        if (SetUtils.intersects(this.selector, ModelExtractor.StatementType.ALL_PROPERTY_STATEMENTS)) {
            this.startTask("Extracting property statements");
            modelExtractor.extractPropertyModel(model);
            this.finishTask("Extracting property statements");
        }
        if (SetUtils.intersects(this.selector, ModelExtractor.StatementType.ALL_INDIVIDUAL_STATEMENTS)) {
            this.startTask("Extracting individual statements");
            modelExtractor.extractIndividualModel(model);
            this.finishTask("Extracting individual statements");
        }
        this.output(model);
    }

    private String validStatementArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("DefaultStatements");
        arrayList.add("AllClass");
        arrayList.add("AllIndividual");
        arrayList.add("AllProperty");
        arrayList.add("AllStatements");
        arrayList.add("AllStatementsIncludingJena");
        arrayList.add("ClassAssertion");
        arrayList.add("ComplementOf");
        arrayList.add("DataPropertyAssertion");
        arrayList.add("DifferentIndividuals");
        arrayList.add("DirectClassAssertion");
        arrayList.add("DirectSubClassOf");
        arrayList.add("DirectSubPropertyOf");
        arrayList.add("DisjointClasses");
        arrayList.add("DisjointProperties");
        arrayList.add("EquivalentClasses");
        arrayList.add("EquivalentProperties");
        arrayList.add("InverseProperties");
        arrayList.add("ObjectPropertyAssertion");
        arrayList.add("PropertyAssertion");
        arrayList.add("SameIndividual");
        arrayList.add("SubClassOf");
        arrayList.add("SubPropertyOf");
        return ((Object)arrayList).toString();
    }

    private void mapStatementTypes() {
        String string = this.options.getOption("statements").getValueAsString();
        String[] stringArray = string.split(" ");
        if (stringArray.length == 0) {
            throw new PelletCmdException("No values for statements argument given");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equalsIgnoreCase("DefaultStatements")) {
                this.selectorAddAll(ModelExtractor.StatementType.DEFAULT_STATEMENTS);
                continue;
            }
            if (string2.equalsIgnoreCase("AllStatements")) {
                this.selectorAddAll(ModelExtractor.StatementType.ALL_STATEMENTS);
                continue;
            }
            if (string2.equalsIgnoreCase("AllStatementsIncludingJena")) {
                this.selectorAddAll(ModelExtractor.StatementType.ALL_STATEMENTS_INCLUDING_JENA);
                continue;
            }
            if (string2.equalsIgnoreCase("AllClass")) {
                this.selectorAddAll(ModelExtractor.StatementType.ALL_CLASS_STATEMENTS);
                continue;
            }
            if (string2.equalsIgnoreCase("AllIndividual")) {
                this.selectorAddAll(ModelExtractor.StatementType.ALL_INDIVIDUAL_STATEMENTS);
                continue;
            }
            if (string2.equalsIgnoreCase("AllProperty")) {
                this.selectorAddAll(ModelExtractor.StatementType.ALL_PROPERTY_STATEMENTS);
                continue;
            }
            if (string2.equalsIgnoreCase("ClassAssertion")) {
                this.selectorAdd(ModelExtractor.StatementType.ALL_INSTANCE);
                continue;
            }
            if (string2.equalsIgnoreCase("ComplementOf")) {
                this.selectorAdd(ModelExtractor.StatementType.COMPLEMENT_CLASS);
                continue;
            }
            if (string2.equalsIgnoreCase("DataPropertyAssertion")) {
                this.selectorAdd(ModelExtractor.StatementType.DATA_PROPERTY_VALUE);
                continue;
            }
            if (string2.equalsIgnoreCase("DifferentIndividuals")) {
                this.selectorAdd(ModelExtractor.StatementType.DIFFERENT_FROM);
                continue;
            }
            if (string2.equalsIgnoreCase("DirectClassAssertion")) {
                this.selectorAdd(ModelExtractor.StatementType.DIRECT_INSTANCE);
                continue;
            }
            if (string2.equalsIgnoreCase("DirectSubClassOf")) {
                this.selectorAdd(ModelExtractor.StatementType.DIRECT_SUBCLASS);
                continue;
            }
            if (string2.equalsIgnoreCase("DirectSubPropertyOf")) {
                this.selectorAdd(ModelExtractor.StatementType.DIRECT_SUBPROPERTY);
                continue;
            }
            if (string2.equalsIgnoreCase("DisjointClasses")) {
                this.selectorAdd(ModelExtractor.StatementType.DISJOINT_CLASS);
                continue;
            }
            if (string2.equalsIgnoreCase("DisjointProperties")) {
                this.selectorAdd(ModelExtractor.StatementType.DISJOINT_PROPERTY);
                continue;
            }
            if (string2.equalsIgnoreCase("EquivalentClasses")) {
                this.selectorAdd(ModelExtractor.StatementType.EQUIVALENT_CLASS);
                continue;
            }
            if (string2.equalsIgnoreCase("EquivalentProperties")) {
                this.selectorAdd(ModelExtractor.StatementType.EQUIVALENT_PROPERTY);
                continue;
            }
            if (string2.equalsIgnoreCase("InverseProperties")) {
                this.selectorAdd(ModelExtractor.StatementType.INVERSE_PROPERTY);
                continue;
            }
            if (string2.equalsIgnoreCase("ObjectPropertyAssertion")) {
                this.selectorAdd(ModelExtractor.StatementType.OBJECT_PROPERTY_VALUE);
                continue;
            }
            if (string2.equalsIgnoreCase("PropertyAssertion")) {
                this.selectorAddAll(ModelExtractor.StatementType.PROPERTY_VALUE);
                continue;
            }
            if (string2.equalsIgnoreCase("SameIndividual")) {
                this.selectorAdd(ModelExtractor.StatementType.SAME_AS);
                continue;
            }
            if (string2.equalsIgnoreCase("SubClassOf")) {
                this.selectorAdd(ModelExtractor.StatementType.ALL_SUBCLASS);
                continue;
            }
            if (string2.equalsIgnoreCase("SubPropertyOf")) {
                this.selectorAdd(ModelExtractor.StatementType.ALL_SUBPROPERTY);
                continue;
            }
            throw new PelletCmdException("Unknown statement type: " + string2);
        }
        if (this.selector == null) {
            this.selector = ModelExtractor.StatementType.DEFAULT_STATEMENTS;
        }
    }

    private void selectorAddAll(EnumSet<ModelExtractor.StatementType> enumSet) {
        if (this.selector == null) {
            this.selector = enumSet;
        } else {
            this.selector.addAll(enumSet);
        }
    }

    private void selectorAdd(ModelExtractor.StatementType statementType) {
        if (this.selector == null) {
            this.selector = EnumSet.of(statementType);
        } else {
            this.selector.add(statementType);
        }
    }
}

